package com.bizunited.empower.business.common.util.wx.open;

import org.apache.commons.lang3.Validate;

/**
 * 获取第三方小程序需要的URL等信息工具类
 */
public class InternalWxOpenInfoProcessor {
  private final InternalWxOpenInfoParam internalWxOpenInfoParam = new InternalWxOpenInfoParam();

  /**
   * 设置获取第三方小程序信息所需的参数
   * @param url 公司内部第三方小程序维护平台
   * @param tenantCode 租户编码
   * @param appletType 小程序类型
   */
  public void setInternalWxOpenInfoParam(String url, String tenantCode, Integer appletType) {
    Validate.notBlank(url, "内部微信第三方请求地址不能为空");
    Validate.notBlank(tenantCode, "内部微信第三方请求租户不能为空");
    Validate.notNull(appletType, "内部微信第三方请求小程序类型不能为空");

    internalWxOpenInfoParam.setUrl(url);
    internalWxOpenInfoParam.setTenantCode(tenantCode);
    internalWxOpenInfoParam.setAppletType(appletType);
  }

  /**
   * 内部系统第三方小程序配置信息
   * @return
   */
  public InternalWxOpenInfoParam getInternalWxOpenInfoParam(){
    return this.internalWxOpenInfoParam;
  }

  /**
   * 内部系统第三方小程序信息获取需要的参数
   */
  class InternalWxOpenInfoParam {
    /**
     * 内部系统地址yml配置
     */
    private String url;

    /**
     * 租户Code（租户Code + 小程序类型 = 内部系统第三方唯一小程序）
     */
    private String tenantCode;

    /**
     * 小程序类型（租户Code + 小程序类型 = 内部系统第三方唯一小程序）
     */
    private Integer appletType;

    public String getUrl() {
      return url;
    }

    public void setUrl(String url) {
      this.url = url;
    }

    public String getTenantCode() {
      return tenantCode;
    }

    public void setTenantCode(String tenantCode) {
      this.tenantCode = tenantCode;
    }

    public Integer getAppletType() {
      return appletType;
    }

    public void setAppletType(Integer appletType) {
      this.appletType = appletType;
    }
  }
}
