package com.bizunited.empower.business.decoration.controller;

import com.bizunited.empower.business.decoration.service.DecorationProductVoService;
import com.bizunited.empower.business.product.vo.ProductVo;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 店铺装修--商品分组展示商品的Controller
 */
@RestController
@RequestMapping("/v1/decorationProductVo")
public class DecorationProductVoController extends BaseController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(DecorationProductVoController.class);

  @Autowired
  private DecorationProductVoService decorationProductVoService;


  @ApiOperation(value = "根据装修商品组条件，查询商品信息，只查询已上架数据")
  @GetMapping("findByDecorationCondition")
  public ResponseModel findByDecorationCondition(@RequestParam(value = "productCategoryFlatCode",required = false) @ApiParam(name = "快速商品分类编码",value = "productCategoryFlatCode") String productCategoryFlatCode ,
                                                 @RequestParam(value = "displayOrder",required = false) @ApiParam(name = "展示排序：价格升序3，价格降序4",value = "displayOrder") Integer displayOrder,
                                                 @RequestParam(value = "displayNum",required = false) @ApiParam(name = "展示数量",value = "displayNum") Integer displayNum,
                                                 @RequestParam(value = "customerCode",required = false) @ApiParam(name = "客户编码",value = "customerCode") String customerCode){
    try {

      List<ProductVo> result = decorationProductVoService.findByDecorationCondition(productCategoryFlatCode,displayOrder,displayNum,customerCode);
      return this.buildHttpResultW(result,"preferentialItems","productSpecifications","productUnitAndPrices","productFiles","productUnitAndPrices.productUnit","productUnitSpecificationAndPrices","productUnitSpecificationAndPrices.productUnit","productUnitSpecificationAndPrices.productSpecification","productUnitSpecificationAndPrices.productSpecification.preferentialItems");
    }catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }
}
