package com.bizunited.empower.business.decoration.controller;

import com.alibaba.fastjson.JSONArray;
import com.bizunited.empower.business.decoration.entity.DecorationTerminalMiniSchema;
import com.bizunited.empower.business.decoration.service.DecorationTerminalMiniService;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 小程序端装修结构体信息Controller层
 */
@RestController
@RequestMapping("/v1/decorationTerminalMini")
public class DecorationTerminalMiniController extends BaseController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(DecorationTerminalMiniController.class);

  @Autowired
  private DecorationTerminalMiniService decorationTerminalMiniService;


  /**
   * 保存小程序端商城-装修的jsonSchema
   * @param jsonSchema 装修结构体jsonSchema
   * */
  @ApiOperation(value = "保存小程序端商城-装修的结构体信息")
  @PostMapping(value="")
  public ResponseModel save(@RequestBody @ApiParam(name="jsonSchema" , value="json结构体") JSONArray jsonSchema) {
    try {
      DecorationTerminalMiniSchema current = decorationTerminalMiniService.save(jsonSchema);
      return this.buildHttpResultW(current, StringUtils.EMPTY);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 查询指定租户的装修结构体信息
   * @param tenantCode 租户编码
   */
  @ApiOperation(value = "查询指定租户的装修结构体信息")
  @GetMapping(value="/findByTenantCode")
  public ResponseModel findByTenantCode(@RequestParam("tenantCode") @ApiParam(name = "tenantCode",value = "租户编码") String tenantCode) {
    try {
      DecorationTerminalMiniSchema current = decorationTerminalMiniService.findByTenantCode(tenantCode);
      return this.buildHttpResultW(current, StringUtils.EMPTY);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * pc端 查询指定租户的装修结构体信息(json格式)
   * @param tenantCode 租户编码
   */
  @ApiOperation(value = "查询指定租户的装修结构体信息(json格式)")
  @GetMapping(value="/findSchemaByTenantCode")
  public ResponseModel findSchemaByTenantCode(@RequestParam("tenantCode") @ApiParam(name = "tenantCode",value = "租户编码") String tenantCode) {
    try {
      JSONArray current = decorationTerminalMiniService.findSchemaByTenantCode(tenantCode);
      return this.buildHttpResultW(current, StringUtils.EMPTY);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 小程序端 查询指定租户的装修结构体信息(json格式)
   */
  @ApiOperation(value = "查询指定租户的装修结构体信息(json格式)")
  @GetMapping(value="/findSchema")
  public ResponseModel findSchema() {
    try {
      JSONArray current = decorationTerminalMiniService.findSchema();
      return this.buildHttpResultW(current, StringUtils.EMPTY);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }
}
