package com.bizunited.empower.business.decoration.controller;

import com.bizunited.empower.business.decoration.dto.PictureAdvertisementDto;
import com.bizunited.empower.business.decoration.entity.PictureAdvertisement;
import com.bizunited.empower.business.decoration.service.PictureAdvertisementService;
import com.bizunited.empower.business.decoration.vo.PictureAdvertisementVo;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * DecorationPictureAdvertisement业务模型的MVC Controller层实现，基于HTTP Restful风格
 * @author hc
 */
@RestController
@RequestMapping("/v1/pictureAdvertisement")
public class PictureAdvertisementController extends BaseController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(PictureAdvertisementController.class);
  
  @Autowired
  private PictureAdvertisementService pictureAdvertisementService;

  /**
   * 相关的创建过程，http接口。请注意该创建过程除了可以创建decorationPictureAdvertisement中的基本信息以外，还可以对decorationPictureAdvertisement中属于OneToMany关联的明细信息一同进行创建注意：基于（DecorationPictureAdvertisement）模型的创建操作传入的decorationPictureAdvertisementJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   * */
  @ApiOperation(value = "相关的创建过程，http接口。请注意该创建过程除了可以创建decorationPictureAdvertisement中的基本信息以外，还可以对decorationPictureAdvertisement中属于OneToMany关联的明细信息一同进行创建注意：基于（DecorationPictureAdvertisement）模型的创建操作传入的decorationPictureAdvertisementJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）")
  @PostMapping(value="")
  public ResponseModel create(@RequestBody @ApiParam(name="decorationPictureAdvertisement" , value="相关的创建过程，http接口。请注意该创建过程除了可以创建decorationPictureAdvertisement中的基本信息以外，还可以对decorationPictureAdvertisement中属于OneToMany关联的明细信息一同进行创建注意：基于（DecorationPictureAdvertisement）模型的创建操作传入的decorationPictureAdvertisementJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）") PictureAdvertisement pictureAdvertisement) {
    try {
      PictureAdvertisement current = this.pictureAdvertisementService.create(pictureAdvertisement);
      return this.buildHttpResultW(current, StringUtils.EMPTY);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（DecorationPictureAdvertisement）的修改操作传入的decorationPictureAdvertisementJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   * */
  @ApiOperation(value = "相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（DecorationPictureAdvertisement）的修改操作传入的decorationPictureAdvertisementJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）")
  @PatchMapping(value="")
  public ResponseModel update(@RequestBody @ApiParam(name="decorationPictureAdvertisement" , value="相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（DecorationPictureAdvertisement）的修改操作传入的decorationPictureAdvertisementJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）") PictureAdvertisement pictureAdvertisement) {
    try {
      PictureAdvertisement current = this.pictureAdvertisementService.update(pictureAdvertisement);
      return this.buildHttpResultW(current, StringUtils.EMPTY);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  @ApiOperation(value = "分页条件查询")
  @RequestMapping(value="/queryPage" , method={RequestMethod.GET})
  public ResponseModel queryPage(@ApiParam(name = "dto", value = "图片广告dto结构体") PictureAdvertisementDto dto, @PageableDefault(value = 50) Pageable pageable){
    try {
      Page<PictureAdvertisementVo> results = pictureAdvertisementService.queryPage(dto,pageable);
      return this.buildHttpResultW(results, StringUtils.EMPTY);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }


  /**
   * 相关的查询过程，http接口。通过主键进行数据的查询
   * */
  @ApiOperation(value = "相关的查询过程，http接口。通过主键进行数据的查询")
  @DeleteMapping(value="/{id}")
  public ResponseModel deleteById(@PathVariable("id") @ApiParam(name="id" , value="主键")String id){ 
    try {
      this.pictureAdvertisementService.deleteById(id);
      return this.buildHttpResult();
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 按照DecorationPictureAdvertisement实体中的（code）广告编号进行查询
   * @param code 广告编号
   */
  @ApiOperation(value = "按照DecorationPictureAdvertisement实体中的（code）广告编号进行查询")
  @RequestMapping(value="/findByCode" , method={RequestMethod.GET})
  public ResponseModel findByCode(@RequestParam("code") @ApiParam("广告编号") String code) {
    try { 
      PictureAdvertisement result = this.pictureAdvertisementService.findByCode(code);
      return this.buildHttpResultW(result, StringUtils.EMPTY);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }


  /**
   * 根据指定编码，上下架广告
   */
  @ApiOperation(value = "根据指定编码，上下架广告")
  @RequestMapping(value="/updateByCodeAndSelfStatus" , method={RequestMethod.PATCH})
  public ResponseModel updateByCodeAndSelfStatus(@RequestParam("code") @ApiParam("广告编号") String code,
                                           @RequestParam("selfStatus") @ApiParam("上下架状态") Integer selfStatus){
    try {
      pictureAdvertisementService.updateByCodeAndSelfStatus(code,selfStatus);
      return this.buildHttpResult();
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 更新点击量
   */
  @ApiOperation(value = "更新点击量")
  @RequestMapping(value="/updateHitNumByCode" , method={RequestMethod.POST})
  public ResponseModel updateHitNumByCode(@RequestParam("code") @ApiParam("广告编号") String code){
    try {
      pictureAdvertisementService.updateHitNumByCode(code);
      return this.buildHttpResult();
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }
} 
