package com.bizunited.empower.business.decoration.controller;

import com.bizunited.empower.business.decoration.dto.ProductGroupDto;
import com.bizunited.empower.business.decoration.entity.ProductGroup;
import com.bizunited.empower.business.decoration.service.ProductGroupService;
import com.bizunited.empower.business.decoration.vo.ProductGroupVo;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * DecorationProductGroup业务模型的MVC Controller层实现，基于HTTP Restful风格
 * @author hc
 */
@RestController
@RequestMapping("/v1/productGroup")
public class ProductGroupController extends BaseController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(ProductGroupController.class);
  
  @Autowired
  private ProductGroupService productGroupService;

  /**
   * 相关的创建过程，http接口。请注意该创建过程除了可以创建decorationProductGroup中的基本信息以外，还可以对decorationProductGroup中属于OneToMany关联的明细信息一同进行创建注意：基于（DecorationProductGroup）模型的创建操作传入的decorationProductGroupJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   * */
  @ApiOperation(value = "相关的创建过程，http接口。请注意该创建过程除了可以创建decorationProductGroup中的基本信息以外，还可以对decorationProductGroup中属于OneToMany关联的明细信息一同进行创建注意：基于（DecorationProductGroup）模型的创建操作传入的decorationProductGroupJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）")
  @PostMapping(value="")
  public ResponseModel create(@RequestBody @ApiParam(name="decorationProductGroup" , value="相关的创建过程，http接口。请注意该创建过程除了可以创建decorationProductGroup中的基本信息以外，还可以对decorationProductGroup中属于OneToMany关联的明细信息一同进行创建注意：基于（DecorationProductGroup）模型的创建操作传入的decorationProductGroupJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）") ProductGroup productGroup) {
    try {
      ProductGroup current = this.productGroupService.create(productGroup);
      return this.buildHttpResultW(current, StringUtils.EMPTY);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（DecorationProductGroup）的修改操作传入的decorationProductGroupJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   * */
  @ApiOperation(value = "相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（DecorationProductGroup）的修改操作传入的decorationProductGroupJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）")
  @PatchMapping(value="")
  public ResponseModel update(@RequestBody @ApiParam(name="decorationProductGroup" , value="相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（DecorationProductGroup）的修改操作传入的decorationProductGroupJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）") ProductGroup productGroup) {
    try {
      ProductGroup current = this.productGroupService.update(productGroup);
      return this.buildHttpResultW(current, StringUtils.EMPTY);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  @ApiOperation(value = "分页条件查询")
  @RequestMapping(value="/queryPage" , method={RequestMethod.GET})
  public ResponseModel queryPage(@ApiParam(name = "dto", value = "商品组结构体") ProductGroupDto dto, @PageableDefault(value = 50) Pageable pageable){
    try {
      Page<ProductGroupVo> results = productGroupService.queryPage(dto,pageable);
      return this.buildHttpResultW(results, StringUtils.EMPTY);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 相关的查询过程，http接口。通过主键进行数据的查询
   * */
  @ApiOperation(value = "相关的查询过程，http接口。通过主键进行数据的查询")
  @GetMapping(value="/{id}")
  public ResponseModel findById(@PathVariable("id") @ApiParam(name="id" , value="主键")String id){ 
    try {
      ProductGroup current = this.productGroupService.findById(id);
      return this.buildHttpResultW(current, StringUtils.EMPTY);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 相关的查询过程，http接口。通过主键进行数据的查询
   * */
  @ApiOperation(value = "相关的查询过程，http接口。通过主键进行数据的查询")
  @DeleteMapping(value="/{id}")
  public ResponseModel deleteById(@PathVariable("id") @ApiParam(name="id" , value="主键")String id){ 
    try {
      this.productGroupService.deleteById(id);
      return this.buildHttpResult();
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 按照DecorationProductGroup实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   * @param id 主键
   */
  @ApiOperation(value = "按照DecorationProductGroup实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @RequestMapping(value="/findDetailsById" , method={RequestMethod.GET})
  public ResponseModel findDetailsById(@RequestParam("id") @ApiParam("主键") String id) {
    try { 
      ProductGroup result = this.productGroupService.findDetailsById(id);
      return this.buildHttpResultW(result, StringUtils.EMPTY);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }  
  /**
   * 按照DecorationProductGroup实体中的（code）商品组编号进行查询
   * @param code 商品组编号
   */
  @ApiOperation(value = "按照DecorationProductGroup实体中的（code）商品组编号进行查询")
  @RequestMapping(value="/findByCode" , method={RequestMethod.GET})
  public ResponseModel findByCode(@RequestParam("code") @ApiParam("商品组编号") String code) {
    try { 
      ProductGroup result = this.productGroupService.findByCode(code);
      return this.buildHttpResultW(result, StringUtils.EMPTY);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }

  /**
   * 根据指定编码更新商品组上下架状态
   */
  @ApiOperation(value = "根据指定编码更新商品组上下架状态")
  @RequestMapping(value="/updateSelfStatusByCode" , method={RequestMethod.PATCH})
  public ResponseModel updateSelfStatusByCode(@RequestParam("code") @ApiParam("商品组编号") String code,
                                           @RequestParam("selfStatus") @ApiParam("商品组上下架状态") Integer selfStatus){
    try {
      productGroupService.updateSelfStatusByCode(code,selfStatus);
      return this.buildHttpResult();
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }


  /**
   * 根据租户编码，查询有效的商品组数据
   * @param tenantCode 租户编号
   */
  @ApiOperation(value = "按照DecorationProductGroup实体中的（tenantCode）租户编号进行查询")
  @RequestMapping(value="/findEffectiveByTenantCode" , method={RequestMethod.GET})
  public ResponseModel findEffectiveByTenantCode(@RequestParam(value = "tenantCode",required = false) @ApiParam("租户编号") String tenantCode) {
    try {
      List<ProductGroup> result = this.productGroupService.findEffectiveByTenantCode(tenantCode);
      return this.buildHttpResultW(result, StringUtils.EMPTY);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }
}
