package com.bizunited.empower.business.decoration.entity;

import com.bizunited.platform.common.entity.TenantOpEntity;
import com.bizunited.platform.saturn.engine.annotation.BuildCustomRepository;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;

@ApiModel(value = "ProductGroup", description = "装修商品组")
@Entity
@Table(name = "decoration_product_group",indexes = {@Index(columnList = "code,tenant_code",unique = true),
                                                    @Index(columnList = "title,tenant_code",unique = true)})
@org.hibernate.annotations.Table(appliesTo = "decoration_product_group", comment = "装修商品组")
@BuildCustomRepository
public class ProductGroup extends TenantOpEntity {

  private static final long serialVersionUID = 2021103985769812399L;

  /**
   * 已选商品数量
   */
  @Transient
  @ApiModelProperty("已选商品数量")
  private Integer selectNum;

  /** 商品组编号 */
  @Column(name = "code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 商品组编号 '")
  @SaturnColumn(description = "商品组编号")
  @ApiModelProperty("商品组编号")
  private String code;

  /** 商品组标题名称 */
  @Column(name = "title", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 商品组标题名称 '")
  @SaturnColumn(description = "商品组标题名称")
  @ApiModelProperty("商品组标题名称")
  private String title;

  /**
   * 排序权重(值越大越靠前)
   */
  @Column(name = "sort_index", nullable = false,columnDefinition = "INT(4) COMMENT '排序权重'")
  @SaturnColumn(description = "排序权重")
  @ApiModelProperty("排序权重")
  private Integer sortIndex;

  /**
   * 商品组状态：1(生效中) 2(已下架)
   */
  @Column(name = "tstatus", nullable = false,columnDefinition = "INT(4) COMMENT '商品组状态：1(生效中) 2(已下架)'")
  @SaturnColumn(description = "商品组状态")
  @ApiModelProperty("商品组状态：1(生效中) 2(已下架)")
  private Integer tstatus;

  /**
   * 上下架状态：1(上架) 2(下架)
   */
  @Column(name = "shelf_status", nullable = false,columnDefinition = "INT(4) COMMENT '上下架状态：1(上架) 2(下架)'")
  @SaturnColumn(description = "上下架状态")
  @ApiModelProperty("上下架状态：1(上架) 2(下架)")
  private Integer shelfStatus;

  /**
   * 展示数量
   */
  @Column(name = "display_num", nullable = false,columnDefinition = "INT(4) COMMENT '展示数量'")
  @SaturnColumn(description = "展示数量")
  @ApiModelProperty("展示数量")
  private Integer displayNum;

  /**
   * 展示类型：1(全部商品) 2(按分类展示)
   */
  @Column(name = "display_type", nullable = false,columnDefinition = "INT(4) COMMENT '展示类型：1(全部商品) 2(按分类展示)'")
  @SaturnColumn(description = "展示类型")
  @ApiModelProperty("展示类型：1(全部商品) 2(按分类展示)")
  private Integer displayType;

  /**
   * 展示顺序：1(新品优先) 2(销量优先) 3(价格优先) 4(价格降序)
   */
  @Column(name = "display_order", nullable = false,columnDefinition = "INT(4) COMMENT '展示顺序：1(新品优先) 2(销量优先) 3(价格升序) 4(价格降序)'")
  @SaturnColumn(description = "展示顺序")
  @ApiModelProperty("展示顺序：1(新品优先) 2(销量优先) 3(价格升序) 4(价格降序)")
  private Integer displayOrder;

  /** 商品分类编码 */
  @Column(name = "product_category_code", nullable = true, columnDefinition = "VARCHAR(64) COMMENT ' 商品分类编码 '")
  @SaturnColumn(description = "商品分类编码")
  @ApiModelProperty("商品分类编码")
  private String productCategoryCode;

  /** 商品分类编码 */
  @Column(name = "product_category_name", nullable = true, columnDefinition = "VARCHAR(64) COMMENT ' 商品分类名称 '")
  @SaturnColumn(description = "商品分类名称")
  @ApiModelProperty("商品分类名称")
  private String productCategoryName;


  public Integer getSelectNum() {
    return selectNum;
  }

  public void setSelectNum(Integer selectNum) {
    this.selectNum = selectNum;
  }

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public Integer getSortIndex() {
    return sortIndex;
  }

  public void setSortIndex(Integer sortIndex) {
    this.sortIndex = sortIndex;
  }

  public Integer getTstatus() {
    return tstatus;
  }

  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }

  public Integer getShelfStatus() {
    return shelfStatus;
  }

  public void setShelfStatus(Integer shelfStatus) {
    this.shelfStatus = shelfStatus;
  }

  public Integer getDisplayNum() {
    return displayNum;
  }

  public void setDisplayNum(Integer displayNum) {
    this.displayNum = displayNum;
  }

  public Integer getDisplayType() {
    return displayType;
  }

  public void setDisplayType(Integer displayType) {
    this.displayType = displayType;
  }

  public Integer getDisplayOrder() {
    return displayOrder;
  }

  public void setDisplayOrder(Integer displayOrder) {
    this.displayOrder = displayOrder;
  }

  public String getProductCategoryCode() {
    return productCategoryCode;
  }

  public void setProductCategoryCode(String productCategoryCode) {
    this.productCategoryCode = productCategoryCode;
  }

  public String getProductCategoryName() {
    return productCategoryName;
  }

  public void setProductCategoryName(String productCategoryName) {
    this.productCategoryName = productCategoryName;
  }
}
