package com.bizunited.empower.business.decoration.entity;

import com.bizunited.platform.common.entity.TenantEntity;
import com.bizunited.platform.saturn.engine.annotation.BuildCustomRepository;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

@ApiModel(value = "UserInvitation", description = "业务员邀请码信息")
@Entity
@Table(name = "user_invitation",indexes = {@Index(columnList = "invitation_code",unique = true),})
@org.hibernate.annotations.Table(appliesTo = "user_invitation", comment = "业务员邀请码信息")
@BuildCustomRepository
public class UserInvitation extends TenantEntity {
  private static final long serialVersionUID = -5785049906188880633L;

  /** 业务员账户 */
  @Column(name = "user_account", nullable = false, length = 64, columnDefinition = "VARCHAR(64) NOT NULL COMMENT ' 业务员账户 '")
  @SaturnColumn(description = "业务员账户")
  @ApiModelProperty("业务员账户")
  private String userAccount;

  /** 用户邀请码 */
  @Column(name = "invitation_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) NOT NULL COMMENT ' 用户邀请码 '")
  @SaturnColumn(description = "用户邀请码")
  @ApiModelProperty("用户邀请码")
  private String invitationCode;

  public String getUserAccount() {
    return userAccount;
  }

  public void setUserAccount(String userAccount) {
    this.userAccount = userAccount;
  }

  public String getInvitationCode() {
    return invitationCode;
  }

  public void setInvitationCode(String invitationCode) {
    this.invitationCode = invitationCode;
  }
}
