package com.bizunited.empower.business.decoration.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

public enum DecorationTypeEnum {
  PIC_ADVERT("banner","图片广告",1),
  HWORD_SEARCH("search","热词搜索",1),
  NAVIGATOR("navigator","快速入口",1),
  SHOP_WINDOW("shopWindow","橱窗商品",1),
  RECOMMEND_CATOGORY("recommendCatogory","推荐分类",0),
  PREFER_BRAND("preferenceBrand","品牌优选",0);

  /**
   * 装修结构类型编码
   */
  private String code;

  /**
   * 装修结果类型名称
   */
  private String name;

  /**
   * 装修结构是否默认固定组件（0否，1是）
   */
  private Integer defaultComptent;

  DecorationTypeEnum(String code,String name,Integer defaultComptent){
    this.code = code;
    this.name = name;
    this.defaultComptent = defaultComptent;
  }

  public static Set<String> codes(){
    return Arrays.stream(DecorationTypeEnum.values()).map(DecorationTypeEnum::getCode).collect(Collectors.toSet());
  }

  public static DecorationTypeEnum findByCode(String code){
    if(StringUtils.isBlank(code)){
      return null;
    }
    for(DecorationTypeEnum e : DecorationTypeEnum.values()){
      if(StringUtils.equals(e.getCode(),code)){
        return e;
      }
    }
    return null;
  }

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Integer getDefaultComptent() {
    return defaultComptent;
  }

  public void setDefaultComptent(Integer defaultComptent) {
    this.defaultComptent = defaultComptent;
  }
}
