package com.bizunited.empower.business.decoration.event.handle;

import com.bizunited.empower.business.customer.entity.CustomerRegister;
import com.bizunited.empower.business.customer.event.CustomerRegisterListener;
import com.bizunited.empower.business.decoration.service.UserInvitationService;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 客户自主注册事件处理器
 */
@Component
public class CustomerRegisterEventHandler implements CustomerRegisterListener {
  @Autowired
  private UserInvitationService userInvitationService;

  @Override
  public void onCreate(CustomerRegister customerRegister) {
    Validate.notNull(customerRegister, "在验证用户邀请码时，实体信息不能为空");
    Validate.notBlank(customerRegister.getTenantCode(), "在验证用户邀请码时，用户的租户信息不能为空");
    Validate.notBlank(customerRegister.getInvitationAccount(), "在验证用户邀请码时，用户的账户信息不能为空");
    Validate.notBlank(customerRegister.getInvitationCode(), "在验证用户邀请码时，用户的邀请码实体信息不能为空");

    userInvitationService.validateInvitationCode(customerRegister.getTenantCode(),
            customerRegister.getInvitationAccount(),
            customerRegister.getInvitationCode());
  }
}
