package com.bizunited.empower.business.decoration.repository;

import com.bizunited.empower.business.decoration.entity.ProductGroup;
import com.bizunited.empower.business.decoration.repository.internal.ProductGroupRepositoryCustom;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * DecorationProductGroup业务模型的数据库方法支持
 * @author hc
 */
@Repository("_DecorationProductGroupRepository")
public interface ProductGroupRepository
    extends
      JpaRepository<ProductGroup, String>
      ,JpaSpecificationExecutor<ProductGroup>
      , ProductGroupRepositoryCustom
  {

  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   * */
  @Query("select distinct decorationProductGroup from ProductGroup decorationProductGroup "
      + " where decorationProductGroup.id=:id ")
  ProductGroup findDetailsById(@Param("id") String id);
  /**
   * 按照商品组编号和租户编码进行查询
   * @param code 商品组编号
   * @param tenantCode 租户编码
   * */
  @Query(" from ProductGroup f where f.code = :code and tenantCode = :tenantCode")
  ProductGroup findByCodeAndTenantCode(@Param("code") String code, @Param("tenantCode") String tenantCode);

  /**
   * 按照商品组标题名称和租户编码进行查询
   * @param title 商品组标题名称
   * @param tenantCode 租户编码
   * */
  @Query(" from ProductGroup f where f.title = :title and tenantCode = :tenantCode")
  ProductGroup findByTitleAndTenantCode(@Param("title") String title, @Param("tenantCode") String tenantCode);

  /**
   * 根据租户编码，查询商品组数据
   * @param tenantCode 租户编码
   */
  @Query("from ProductGroup where tenantCode = :tenantCode  order by sortIndex desc")
  List<ProductGroup> findByTenantCode(@Param("tenantCode") String tenantCode);

  /**
   * 根据租户编码，查询有效的商品组数据
   * @param tenantCode 租户编码
   */
  @Query("from ProductGroup where tenantCode = :tenantCode and tstatus = 1 order by sortIndex desc")
  List<ProductGroup> findEffectiveByTenantCode(@Param("tenantCode") String tenantCode);
}