package com.bizunited.empower.business.decoration.repository;

import com.bizunited.empower.business.decoration.entity.UserInvitation;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Set;

/**
 * UserInvitation业务模型的数据库方法支持
 *
 * @author saturn
 */
@Repository("_UserInvitationRepository")
public interface UserInvitationRepository
        extends
        JpaRepository<UserInvitation, String>
        , JpaSpecificationExecutor<UserInvitation>{

  /**
   * 查询指定进销商，业务员账户下的业务员邀请码信息
   * @param tenantCode 租户
   * @param userAccount 业务员账户
   * @return 业务员邀请码信息
   */
  @Query("select distinct userInvitation from UserInvitation userInvitation "
          + " where userInvitation.tenantCode=:tenantCode and userInvitation.userAccount=:userAccount")
  UserInvitation findByTenantCodeAndAccounts(@Param("tenantCode") String tenantCode, @Param("userAccount") String userAccount);

  /**
   * 查询指定进销商，邀请码下的业务员邀请码信息
   * @param invitationCode 邀请码
   * @return 业务员邀请码信息
   */
  @Query("select distinct userInvitation from UserInvitation userInvitation "
          + " where userInvitation.invitationCode=:invitationCode")
  UserInvitation findByInvitationCode(@Param("invitationCode") String invitationCode);

  /**
   * 查询指定进销商，邀请码下的业务员邀请码信息
   * @param tenantCode 租户
   * @param invitationCode 邀请码
   * @return 业务员邀请码信息
   */
  @Query("select distinct userInvitation from UserInvitation userInvitation "
          + " where userInvitation.tenantCode=:tenantCode and userInvitation.userAccount=:userAccount" +
          " and userInvitation.invitationCode=:invitationCode")
  UserInvitation findAllByUserAccountAndInvitationCode(@Param("tenantCode") String tenantCode,
                                                       @Param("userAccount") String userAccount,
                                                       @Param("invitationCode") String invitationCode);

  /**
   * 查询指定进销商，指定的业务员账户列表的邀请码信息列表
   * @param tenantCode 当前租户
   * @param userAccount 指定的业务员账户
   * @return 指定的业务员账户邀请码列表
   */
  @Query("select distinct userInvitation from UserInvitation userInvitation "
          + " where userInvitation.tenantCode=:tenantCode and userInvitation.userAccount in :userAccount")
  List<UserInvitation> findByUserAccount(@Param("tenantCode") String tenantCode, @Param("userAccount")  Set<String> userAccount);
}