package com.bizunited.empower.business.decoration.repository.internal;

import com.bizunited.empower.business.decoration.dto.PictureAdvertisementDto;
import com.bizunited.empower.business.decoration.vo.PictureAdvertisementVo;
import com.bizunited.platform.common.repository.PageRepositoryImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * DecorationPictureAdvertisement模型的数据层自定义接口实现，可以由程序员根据实际情况完善
 * @author hc
 */
@Repository("_DecorationPictureAdvertisementRepositoryImpl")
public class PictureAdvertisementRepositoryImpl implements PictureAdvertisementRepositoryCustom, PageRepositoryImpl {

  @Autowired
  @PersistenceContext
  private EntityManager entityManager;

  @Override
  public Page<PictureAdvertisementVo> queryPage(PictureAdvertisementDto dto, Pageable pageable) {
    StringBuilder hql = new StringBuilder("select id,code,title,tstatus,shelf_status shelfStatus,content,effective_date effectiveDate,invalid_date invalidDate,relation_type relationType,link_code linkCode,relative_path relativePath,file_name fileName,tenant_code tenantCode,create_time createTime,sort_index sortIndex from decoration_picture_advertisement c where 1=1");
    StringBuilder countHql = new StringBuilder("select count(*) FROM decoration_picture_advertisement c where 1=1");
    Map<String, Object> parameters = new HashMap<>();
    if (dto != null) {
      String title = dto.getTitle();
      if(StringUtils.isNotBlank(title)){
        hql.append(" and c.title like concat('%',:title,'%')");
        countHql.append(" and c.title like concat('%',:title,'%')");
        parameters.put("title",title);
      }

      Date startTime = dto.getStartTime();
      if(startTime != null){
        hql.append(" and c.create_time >= date_format(:startTime,'%Y-%m-%d')");
        countHql.append(" and c.create_time >= date_format(:startTime,'%Y-%m-%d')");
        parameters.put("startTime",startTime);
      }

      Date endTime = dto.getEndTime();
      if(endTime != null){
        hql.append(" and c.create_time <= date_format(:endTime,'%Y-%m-%d')");
        countHql.append(" and c.create_time <= date_format(:endTime,'%Y-%m-%d')");
        parameters.put("endTime",endTime);
      }

      Set<Integer> status = dto.getStatus();
      if(!CollectionUtils.isEmpty(status)){
        hql.append(" and c.tstatus in (:status)");
        countHql.append(" and c.tstatus in (:status)");
        parameters.put("status",status);
      }

      if(StringUtils.isNotBlank(dto.getTenantCode())){
        hql.append(" and c.tenant_code = :tenantCode");
        countHql.append(" and c.tenant_code = :tenantCode");
        parameters.put("tenantCode",dto.getTenantCode());
      }
    }
    return queryByConditions(entityManager, hql.toString(), countHql.toString(), parameters, pageable, true, PictureAdvertisementVo.class);
  }
}
