package com.bizunited.empower.business.decoration.repository.internal;

import com.bizunited.empower.business.decoration.dto.ProductGroupDto;
import com.bizunited.empower.business.decoration.vo.ProductGroupVo;
import com.bizunited.platform.common.repository.PageRepositoryImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * DecorationProductGroup模型的数据层自定义接口实现，可以由程序员根据实际情况完善
 * @author hc
 */
@Repository("_ProductGroupRepositoryImpl")
public class ProductGroupRepositoryImpl implements ProductGroupRepositoryCustom, PageRepositoryImpl {
  @Autowired
  @PersistenceContext
  private EntityManager entityManager;
  @Override
  public Page<ProductGroupVo> queryPage(ProductGroupDto dto, Pageable pageable) {
    StringBuilder hql = new StringBuilder("select id,code,title,create_time createTime,sort_index sortIndex,tstatus," +
            "shelf_status shelfStatus,display_num displayNum,display_type displayType,display_order displayOrder," +
            "product_category_code productCategoryCode,product_category_name productCategoryName " +
            "from decoration_product_group c where 1=1");
    StringBuilder countHql = new StringBuilder("select count(*) FROM decoration_product_group c where 1=1");
    Map<String, Object> parameters = new HashMap<>();
    if (dto != null) {
      String title = dto.getTitle();
      if(StringUtils.isNotBlank(title)){
        hql.append(" and c.title like concat('%',:title,'%')");
        countHql.append(" and c.title like concat('%',:title,'%')");
        parameters.put("title",title);
      }

      Date startTime = dto.getStartTime();
      if(startTime != null){
        hql.append(" and c.create_time >= date_format(:startTime,'%Y-%m-%d')");
        countHql.append(" and c.create_time >= date_format(:startTime,'%Y-%m-%d')");
        parameters.put("startTime",startTime);
      }

      Date endTime = dto.getEndTime();
      if(endTime != null){
        hql.append(" and c.create_time <= date_format(:endTime,'%Y-%m-%d')");
        countHql.append(" and c.create_time <= date_format(:endTime,'%Y-%m-%d')");
        parameters.put("endTime",endTime);
      }

      Set<Integer> status = dto.getStatus();
      if(!CollectionUtils.isEmpty(status)){
        hql.append(" and c.tstatus in (:status)");
        countHql.append(" and c.tstatus in (:status)");
        parameters.put("status",status);
      }

      if(StringUtils.isNotBlank(dto.getTenantCode())){
        hql.append(" and c.tenant_code = :tenantCode");
        countHql.append(" and c.tenant_code = :tenantCode");
        parameters.put("tenantCode",dto.getTenantCode());
      }
    }
    return queryByConditions(entityManager, hql.toString(), countHql.toString(), parameters, pageable, true, ProductGroupVo.class);
  }
}
