package com.bizunited.empower.business.decoration.vo;

import com.bizunited.platform.common.vo.TenantOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

@ApiModel(value = "DecorationPictureAdvertisementVo", description = "目前这个VO专门用于装修图片广告查询结果的显示")
public class PictureAdvertisementVo  extends TenantOpVo {

  /**
   * 
   */
  private static final long serialVersionUID = -5467435841725230539L;

  /**
   * 点击数量
   */
  @ApiModelProperty("点击数量")
  private Long hitNum;

  /** 广告编号 */
  @ApiModelProperty("广告编号")
  private String code;

  /** 广告标题名称 */
  @ApiModelProperty("广告标题名称")
  private String title;

  /**
   * 广告状态：0(待生效) 1(生效中) 2(已下架) 3(已失效) 4(永久生效)
   */
  @ApiModelProperty("广告状态：0(待生效) 1(生效中) 2(已下架) 3(已失效) 4(永久生效)")
  private Integer tstatus;

  /**
   * 上下架状态：1(上架) 2(下架)
   */
  @ApiModelProperty("上下架状态：1(上架) 2(下架)")
  private Integer shelfStatus;

  /** 广告内容 */
  @ApiModelProperty("广告内容")
  private String content;

  /**
   * 生效时间
   * */
  @ApiModelProperty("生效时间")
  private Date effectiveDate;

  /**
   * 失效时间
   * */
  @ApiModelProperty("失效时间")
  private Date invalidDate;

  /**
   * 关联类型：1(商品) 2(无链接)
   */
  @ApiModelProperty("关联类型：1(商品) 2(无链接)")
  private Integer relationType;

  /** 关联的事物编码 */
  @ApiModelProperty("关联的事物编码")
  private String linkCode;

  /** 关联的事物名称 */
  @ApiModelProperty("关联的事物名称")
  private String linkName;

  /**
   * 图片路径
   */
  @ApiModelProperty("图片路径")
  private String relativePath;

  /**
   * 图片名称
   */
  @ApiModelProperty("图片名称")
  private String fileName;

  /**
   * 租户编码
   */
  @ApiModelProperty("租户编码")
  private String tenantCode;

  /**
   * 排序权重（值越大越考前）
   */
  @ApiModelProperty("排序（值越大越考前）")
  private Integer sortIndex;

  public Integer getSortIndex() {
    return sortIndex;
  }

  public void setSortIndex(Integer sortIndex) {
    this.sortIndex = sortIndex;
  }

  @Override
  public String getTenantCode() {
    return tenantCode;
  }

  @Override
  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }

  public Long getHitNum() {
    return hitNum;
  }

  public void setHitNum(Long hitNum) {
    this.hitNum = hitNum;
  }

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public Integer getTstatus() {
    return tstatus;
  }

  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }

  public Integer getShelfStatus() {
    return shelfStatus;
  }

  public void setShelfStatus(Integer shelfStatus) {
    this.shelfStatus = shelfStatus;
  }

  public String getContent() {
    return content;
  }

  public void setContent(String content) {
    this.content = content;
  }

  public Date getEffectiveDate() {
    return effectiveDate;
  }

  public void setEffectiveDate(Date effectiveDate) {
    this.effectiveDate = effectiveDate;
  }

  public Date getInvalidDate() {
    return invalidDate;
  }

  public void setInvalidDate(Date invalidDate) {
    this.invalidDate = invalidDate;
  }

  public Integer getRelationType() {
    return relationType;
  }

  public void setRelationType(Integer relationType) {
    this.relationType = relationType;
  }

  public String getLinkCode() {
    return linkCode;
  }

  public void setLinkCode(String linkCode) {
    this.linkCode = linkCode;
  }

  public String getRelativePath() {
    return relativePath;
  }

  public void setRelativePath(String relativePath) {
    this.relativePath = relativePath;
  }

  public String getFileName() {
    return fileName;
  }

  public void setFileName(String fileName) {
    this.fileName = fileName;
  }

  public String getLinkName() {
    return linkName;
  }

  public void setLinkName(String linkName) {
    this.linkName = linkName;
  }
}
