package com.bizunited.empower.business.decoration.vo;

import com.bizunited.platform.common.vo.TenantOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(value = "DecorationProductGroupVo", description = "目前这个VO专门用于装修商品组查询结果的显示")
public class ProductGroupVo extends TenantOpVo {
  /**
   * 
   */
  private static final long serialVersionUID = 6854544259973875711L;

  /**
   * 已选商品数量
   */
  @ApiModelProperty("已选商品数量")
  private Integer selectNum;

  /** 商品组编号 */
  @ApiModelProperty("商品组编号")
  private String code;

  /** 商品组标题名称 */
  @ApiModelProperty("商品组标题名称")
  private String title;

  /**
   * 排序权重(值越大越靠前)
   */
  @ApiModelProperty("排序权重")
  private Integer sortIndex;

  /**
   * 商品组状态：1(生效中) 2(已下架)
   */
  @ApiModelProperty("商品组状态：1(生效中) 2(已下架)")
  private Integer tstatus;

  /**
   * 上下架状态：1(上架) 2(下架)
   */
  @ApiModelProperty("上下架状态：1(上架) 2(下架)")
  private Integer shelfStatus;

  /**
   * 展示数量
   */
  @ApiModelProperty("展示数量")
  private Integer displayNum;

  /**
   * 展示类型：1(全部商品) 2(按分类展示)
   */
  @ApiModelProperty("展示类型：1(全部商品) 2(按分类展示)")
  private Integer displayType;

  /**
   * 展示顺序：1(新品优先) 2(销量优先) 3(价格优先) 4(价格降序)
   */
  @ApiModelProperty("展示顺序：1(新品优先) 2(销量优先) 3(价格优先) 4(价格降序)")
  private Integer displayOrder;

  /** 商品分类编码 */
  @ApiModelProperty("商品分类编码")
  private String productCategoryCode;

  /** 商品分类编码 */
  @ApiModelProperty("商品分类名称")
  private String productCategoryName;


  public Integer getSelectNum() {
    return selectNum;
  }

  public void setSelectNum(Integer selectNum) {
    this.selectNum = selectNum;
  }

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public Integer getSortIndex() {
    return sortIndex;
  }

  public void setSortIndex(Integer sortIndex) {
    this.sortIndex = sortIndex;
  }

  public Integer getTstatus() {
    return tstatus;
  }

  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }

  public Integer getShelfStatus() {
    return shelfStatus;
  }

  public void setShelfStatus(Integer shelfStatus) {
    this.shelfStatus = shelfStatus;
  }

  public Integer getDisplayNum() {
    return displayNum;
  }

  public void setDisplayNum(Integer displayNum) {
    this.displayNum = displayNum;
  }

  public Integer getDisplayType() {
    return displayType;
  }

  public void setDisplayType(Integer displayType) {
    this.displayType = displayType;
  }

  public Integer getDisplayOrder() {
    return displayOrder;
  }

  public void setDisplayOrder(Integer displayOrder) {
    this.displayOrder = displayOrder;
  }

  public String getProductCategoryCode() {
    return productCategoryCode;
  }

  public void setProductCategoryCode(String productCategoryCode) {
    this.productCategoryCode = productCategoryCode;
  }

  public String getProductCategoryName() {
    return productCategoryName;
  }

  public void setProductCategoryName(String productCategoryName) {
    this.productCategoryName = productCategoryName;
  }
}
