package com.bizunited.empower.business.decoration.controller;

import com.bizunited.empower.business.decoration.entity.UserInvitation;
import com.bizunited.empower.business.decoration.service.UserInvitationService;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Set;

/**
 * UserInvitation业务模型的MVC Controller层实现，基于HTTP Restful风格
 *
 * @author saturn
 */
@RestController
@RequestMapping("/v1/userInvitation")
public class UserInvitationController extends BaseController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(UserInvitationController.class);

  @Autowired
  private UserInvitationService userInvitationService;

  /**
   * 相关的创建过程，http接口。请注意该创建过程除了可以创建userInvitation中的基本信息以外，还可以对userInvitation中属于OneToMany关联的明细信息一同进行创建注意：基于（UserInvitation）模型的创建操作传入的userInvitationJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   */
  @ApiOperation(value = "相关的创建过程，http接口。请注意该创建过程除了可以创建userInvitation中的基本信息以外，还可以对userInvitation中属于OneToMany关联的明细信息一同进行创建注意：基于（UserInvitation）模型的创建操作传入的userInvitationJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）")
  @PostMapping(value = "")
  public ResponseModel create(@RequestBody @ApiParam(name = "userInvitation", value = "相关的创建过程，http接口。请注意该创建过程除了可以创建userInvitation中的基本信息以外，还可以对userInvitation中属于OneToMany关联的明细信息一同进行创建注意：基于（UserInvitation）模型的创建操作传入的userInvitationJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）") UserInvitation userInvitation) {
    try {
      UserInvitation current = this.userInvitationService.create(userInvitation);
      return this.buildHttpResultW(current, new String[]{});
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 查询指定业务员账户列表的邀请码
   *
   * @param userAccount 指定业务员账户列表
   */
  @ApiOperation(value = "按照指定业务员账户列表查询明细。")
  @RequestMapping(value = "/findByUserAccount", method = {RequestMethod.GET})
  public ResponseModel findByUserAccount(@RequestParam @ApiParam("业务员账户列表") Set<String> userAccount) {
    try {
      List<UserInvitation> userInvitations = this.userInvitationService.findByUserAccount(userAccount);
      return this.buildHttpResultW(userInvitations, new String[]{});
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 查询当前品牌商下，指定邀请码的经销商信息
   *
   * @param invitationCode 指定邀请码
   */
  @ApiOperation(value = "查询当前品牌商下，指定邀请码的经销商信息。")
  @RequestMapping(value = "/findByInvitationCode", method = {RequestMethod.GET})
  public ResponseModel findByInvitationCode(@RequestParam @ApiParam(name = "invitationCode", value = "指定邀请码") String invitationCode) {
    try {
      UserInvitation userInvitations = this.userInvitationService.findByInvitationCode(invitationCode);
      return this.buildHttpResultW(userInvitations, new String[]{});
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }
}
