package com.bizunited.empower.business.decoration.entity;

import com.bizunited.platform.common.entity.TenantOpEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 小程序端装修结构jsonSchema
 */
@ApiModel(value = "DecorationTerminalMiniSchema", description = "小程序端装修结构jsonSchema")
@Entity
@Table(name = "decoration_terminal_mini_schema",indexes = {@Index(columnList = "tenant_code", unique = true),
                                                           @Index(columnList = "relative_path,file_name", unique = true)})
@org.hibernate.annotations.Table(appliesTo = "decoration_terminal_mini_schema", comment = "小程序端装修结构jsonSchema")
public class DecorationTerminalMiniSchema extends TenantOpEntity {
  private static final long serialVersionUID = 12127769812399L;

  /** 小程序装修结构编码 */
  @Column(name = "code", nullable = false, length = 64,unique = true,columnDefinition = "VARCHAR(64) COMMENT ' 小程序装修结构编码 '")
  @SaturnColumn(description = "小程序装修结构编码")
  @ApiModelProperty("小程序装修结构编码")
  private String code;
  /**
   * 文件路径
   */
  @Column(name = "relative_path", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 文件路径 '")
  @SaturnColumn(description = "文件路径")
  @ApiModelProperty("文件路径")
  private String relativePath;
  /**
   * 文件名称
   */
  @Column(name = "file_name", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 文件名称 '")
  @SaturnColumn(description = "文件名称")
  @ApiModelProperty("文件名称")
  private String fileName;

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public String getRelativePath() {
    return relativePath;
  }

  public void setRelativePath(String relativePath) {
    this.relativePath = relativePath;
  }

  public String getFileName() {
    return fileName;
  }

  public void setFileName(String fileName) {
    this.fileName = fileName;
  }
}
