package com.bizunited.empower.business.decoration.entity;

import com.bizunited.platform.common.entity.TenantOpEntity;
import com.bizunited.platform.saturn.engine.annotation.BuildCustomRepository;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.Date;

@ApiModel(value = "PictureAdvertisement", description = "图片广告")
@Entity
@Table(name = "decoration_picture_advertisement",indexes = {@Index(columnList = "title , tenant_code" , unique = true),
                                                            @Index(columnList = "code , tenant_code" , unique = true)})
@org.hibernate.annotations.Table(appliesTo = "decoration_picture_advertisement", comment = "图片广告")
@BuildCustomRepository
public class PictureAdvertisement extends TenantOpEntity {
  private static final long serialVersionUID = 2021103985792347499L;

  /**
   * 点击数量
   */
  @Transient
  @ApiModelProperty("点击数量")
  private Long hitNum;

  /** 广告编号 */
  @Column(name = "code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 广告编号 '")
  @SaturnColumn(description = "广告编号")
  @ApiModelProperty("广告编号")
  private String code;

  /** 广告标题名称 */
  @Column(name = "title", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 广告标题名称 '")
  @SaturnColumn(description = "广告标题名称")
  @ApiModelProperty("广告标题名称")
  private String title;

  /**
   * 广告状态：0(待生效) 1(生效中) 2(已下架) 3(已失效) 4(永久生效)
   */
  @Column(name = "tstatus", nullable = false,columnDefinition = "INT(4) COMMENT '广告状态：0(待生效) 1(生效中) 2(已下架) 3(已失效) 4(永久生效)'")
  @SaturnColumn(description = "广告状态")
  @ApiModelProperty("广告状态：0(待生效) 1(生效中) 2(已下架) 3(已失效) 4(永久生效)")
  private Integer tstatus;

  /**
   * 上下架状态：1(上架) 2(下架)
   */
  @Column(name = "shelf_status", nullable = false,columnDefinition = "INT(4) COMMENT '上下架状态：1(上架) 2(下架)'")
  @SaturnColumn(description = "上下架状态")
  @ApiModelProperty("上下架状态：1(上架) 2(下架)")
  private Integer shelfStatus;

  /** 广告内容 */
  @Column(name = "content", nullable = true, columnDefinition = "VARCHAR(255) COMMENT ' 广告内容 '")
  @SaturnColumn(description = "广告内容")
  @ApiModelProperty("广告内容")
  private String content;

  /**
   * 生效时间
   * */
  @ApiModelProperty(name = "effectiveDate", value = "生效时间")
  @Column(name = "effective_date", nullable = true, columnDefinition = "datetime COMMENT '生效时间'")
  @SaturnColumn(description = "生效时间")
  private Date effectiveDate;

  /**
   * 失效时间
   * */
  @ApiModelProperty(name = "invalidDate", value = "失效时间")
  @Column(name = "invalid_date", nullable = true, columnDefinition = "datetime COMMENT '失效时间'")
  @SaturnColumn(description = "失效时间")
  private Date invalidDate;

  /**
   * 关联类型：1(商品) 2(无链接)
   */
  @Column(name = "relation_type", nullable = false,columnDefinition = "INT(4) COMMENT '关联类型：1(商品) 2(无链接)'")
  @SaturnColumn(description = "关联类型")
  @ApiModelProperty("关联类型：1(商品) 2(无链接)")
  private Integer relationType;

  /** 关联的事物编码 */
  @Column(name = "link_code", nullable = true, columnDefinition = "VARCHAR(255) COMMENT '关联的事物编码'")
  @SaturnColumn(description = "关联的事物编码")
  @ApiModelProperty("关联的事物编码")
  private String linkCode;

  /** 关联的事物名称 */
  @Column(name = "link_name", nullable = true, columnDefinition = "VARCHAR(255) COMMENT '关联的事物名称'")
  @SaturnColumn(description = "关联的事物名称")
  @ApiModelProperty("关联的事物名称")
  private String linkName;

  /**
   * 排序（值越大越考前）
   */
  @Column(name = "sort_index", nullable = false,columnDefinition = "INT(7) COMMENT '排序'")
  @SaturnColumn(description = "排序")
  @ApiModelProperty("排序（值越大越考前）")
  private Integer sortIndex;

  /**
   * 图片路径
   */
  @Column(name = "relative_path", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 图片路径 '")
  @SaturnColumn(description = "图片路径")
  @ApiModelProperty("图片路径")
  private String relativePath;

  /**
   * 图片名称
   */
  @Column(name = "file_name", nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 图片名称 '")
  @SaturnColumn(description = "图片名称")
  @ApiModelProperty("图片名称")
  private String fileName;

  public String getRelativePath() {
    return relativePath;
  }

  public void setRelativePath(String relativePath) {
    this.relativePath = relativePath;
  }

  public String getFileName() {
    return fileName;
  }

  public void setFileName(String fileName) {
    this.fileName = fileName;
  }

  public Integer getTstatus() {
    return tstatus;
  }

  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public Integer getShelfStatus() {
    return shelfStatus;
  }

  public void setShelfStatus(Integer shelfStatus) {
    this.shelfStatus = shelfStatus;
  }

  public String getContent() {
    return content;
  }

  public void setContent(String content) {
    this.content = content;
  }

  public Date getEffectiveDate() {
    return effectiveDate;
  }

  public void setEffectiveDate(Date effectiveDate) {
    this.effectiveDate = effectiveDate;
  }

  public Date getInvalidDate() {
    return invalidDate;
  }

  public void setInvalidDate(Date invalidDate) {
    this.invalidDate = invalidDate;
  }

  public Integer getRelationType() {
    return relationType;
  }

  public void setRelationType(Integer relationType) {
    this.relationType = relationType;
  }

  public String getLinkCode() {
    return linkCode;
  }

  public void setLinkCode(String linkCode) {
    this.linkCode = linkCode;
  }

  public Long getHitNum() {
    return hitNum;
  }

  public void setHitNum(Long hitNum) {
    this.hitNum = hitNum;
  }

  public Integer getSortIndex() {
    return sortIndex;
  }

  public void setSortIndex(Integer sortIndex) {
    this.sortIndex = sortIndex;
  }

  public String getLinkName() {
    return linkName;
  }

  public void setLinkName(String linkName) {
    this.linkName = linkName;
  }
}
