package com.bizunited.empower.business.decoration.event.handle;

import com.bizunited.empower.business.decoration.entity.UserInvitation;
import com.bizunited.empower.business.decoration.service.UserInvitationService;
import com.bizunited.platform.user2.sdk.event.UserEventListener;
import com.bizunited.platform.user2.sdk.vo.UserVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 员工业务员邀请码相关监听器处理类
 */
@Component
public class UserInvitationEventHandler implements UserEventListener {
  @Autowired
  private UserInvitationService userInvitationService;

  @Override
  public void onCreated(UserVo user) {
    UserInvitation userInvitation = new UserInvitation();
    userInvitation.setUserAccount(user.getAccount());
    userInvitationService.create(userInvitation);
  }

  @Override
  public void onUpgraded(UserVo user) {

  }

  @Override
  public void onDeleted(UserVo user) {
    userInvitationService.deleteByUserAccount(user.getAccount());
  }
}
