package com.bizunited.empower.business.decoration.repository;

import com.bizunited.empower.business.decoration.entity.DecorationTerminalMiniSchema;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface DecorationTerminalMiniRepository extends
        JpaRepository<DecorationTerminalMiniSchema, String>
        , JpaSpecificationExecutor<DecorationTerminalMiniSchema>{

  /**
   * 查询指定租户的装修结构jsonSchema
   */
  @Query("from DecorationTerminalMiniSchema e where e.tenantCode = :tenantCode")
  DecorationTerminalMiniSchema findByTenantCode(@Param("tenantCode") String tenantCode);
}
