package com.bizunited.empower.business.decoration.repository;

import com.bizunited.empower.business.decoration.entity.PictureAdvertisement;
import com.bizunited.empower.business.decoration.repository.internal.PictureAdvertisementRepositoryCustom;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Set;

/**
 * DecorationPictureAdvertisement业务模型的数据库方法支持
 * @author hc
 */
@Repository("_DecorationPictureAdvertisementRepository")
public interface PictureAdvertisementRepository
    extends
      JpaRepository<PictureAdvertisement, String>
      ,JpaSpecificationExecutor<PictureAdvertisement>
      , PictureAdvertisementRepositoryCustom
  {

  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   * */
  @Query("select distinct decorationPictureAdvertisement from PictureAdvertisement decorationPictureAdvertisement "
      + " where decorationPictureAdvertisement.id=:id ")
  PictureAdvertisement findDetailsById(@Param("id") String id);
  /**
   * 按照广告编号进行查询
   * @param code 广告编号
   * @param tenantCode 租户编码
   * */
  @Query(" from PictureAdvertisement f where f.code = :code and f.tenantCode = :tenantCode")
  PictureAdvertisement findByCodeAndTenantCode(@Param("code") String code,@Param("tenantCode") String tenantCode);


  /**
   * 根据广告状态查询
   * @param status 广告状态
   * 注：该查询主要针对定时任务，获取所有的图片广告数据
   */
  @Query("from PictureAdvertisement where tstatus in (:status)")
  Set<PictureAdvertisement> findByTstatus(@Param("status") Set<Integer> status);

  /**
   * 根据图片广告标题名称和租户编码，查询相应租户的广告信息
   * @param title 广告标题名称
   * @param tenantCode 租户编码
   */
  @Query("from PictureAdvertisement where title = :title and tenantCode = :tenantCode")
  PictureAdvertisement findByTitleAndTenantCode(@Param("title") String title , @Param("tenantCode") String tenantCode);

  /**
   * 根据租户编码，查询图片广告
   * @param tenantCode 租户编码
   */
  @Query("from PictureAdvertisement where tenantCode = :tenantCode order by sortIndex desc")
  List<PictureAdvertisement> findByTenantCode(@Param("tenantCode") String tenantCode);
}