package com.bizunited.empower.business.decoration.service;

import com.bizunited.empower.business.product.vo.ProductVo;

import java.util.List;

/**
 * 店铺装修--商品分组展示商品的Service
 */
public interface DecorationProductVoService {
  /**
   * 根据装修商品组条件，查询数据，只查询已上架数据
   * @param productCategoryFlatCode 快速商品分类编码（可以为空，为空时查询全部商品）
   * @param displayOrder 展示排序（目前只支持销售价的升序何降序，3表示升序，4表示降序）
   * @param displayNum 展示数量（不超过20个）
   * @param customerCode 客户编码
   */
  List<ProductVo> findByDecorationCondition(String productCategoryFlatCode, Integer displayOrder, Integer displayNum, String customerCode);
}
