package com.bizunited.empower.business.decoration.service;

import com.alibaba.fastjson.JSONArray;
import com.bizunited.empower.business.decoration.entity.DecorationTerminalMiniSchema;

public interface DecorationTerminalMiniService {
  /**
   * 保存装修jsonSchema
   * @param json 结构体
   */
  DecorationTerminalMiniSchema save(JSONArray json);

  /**
   * 查询租户的装修结构体
   * @param tenantCode 租户编码
   */
  DecorationTerminalMiniSchema findByTenantCode(String tenantCode);

  /**
   * pc端 查询租户的装修结构体(json格式)
   * @param tenantCode 租户编码
   */
  JSONArray findSchemaByTenantCode(String tenantCode);

  /**
   * 小程序端 查询租户的装修结构体(json格式)
   */
  JSONArray findSchema();
}
