package com.bizunited.empower.business.decoration.service;

import com.bizunited.empower.business.decoration.entity.UserInvitation;

import java.util.List;
import java.util.Set;

/**
 * UserInvitation业务模型的服务层接口定义
 * @author saturn
 */
public interface UserInvitationService { 
  /**
   * 创建一个新的UserInvitation模型对象（包括了可能的第三方系统调用、复杂逻辑处理等）
   */
  UserInvitation create(UserInvitation userInvitation);
  /**
   * 创建一个新的StudentEntity模型对象
   * 该代码由satrun骨架生成，默认不包括任何可能第三方系统调用、任何复杂逻辑处理等，主要应用场景为前端表单数据的暂存功能</br>
   * 该方法与本接口中的updateFrom方法呼应
   */
  UserInvitation createForm(UserInvitation userInvitation);

  /**
   * 查询指定业务员账户列表的邀请码
   * @param userAccount 指定业务员账户列表
   */
  List<UserInvitation> findByUserAccount(Set<String> userAccount);

  /**
   * 查询指定进销商，业务员邀请码的邀请信息
   * @param tenantCode 指定进销商
   * @param invitationCode 业务员邀请码
   */
  void validateInvitationCode(String tenantCode, String userAccount, String invitationCode);

  /**
   *  按照业务员账户进行信息的真删除
   * @param userAccount 业务员账户
   */
  void deleteByUserAccount(String userAccount);

  /**
   * 查询当前品牌商下，指定邀请码的经销商信息
   * @param invitationCode 指定邀请码
   * @return 当前品牌商下，指定邀请码列表
   */
  UserInvitation findByInvitationCode(String invitationCode);
}