/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.distribution.controller;

import com.bizunited.empower.business.distribution.dto.DeliverGoodDto;
import com.bizunited.empower.business.distribution.dto.DeliverGoodLogisticsDto;
import com.bizunited.empower.business.distribution.service.DeliverGoodVoService;
import com.bizunited.empower.business.distribution.vo.DeliverGoodVo;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/deliverGoodVo"})
public class DeliverGoodVoController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeliverGoodVoController.class);
    @Autowired
    private DeliverGoodVoService deliverGoodVoService;

    @ApiOperation(value="\u6309\u7167deliverGoodVo\u5b9e\u4f53\u4e2d\u7684\uff08id\uff09\u4e3b\u952e\u8fdb\u884c\u67e5\u8be2\u660e\u7ec6\u67e5\u8be2\uff0c\u67e5\u8be2\u7684\u660e\u7ec6\u5305\u62ec\u5f53\u524d\u4e1a\u52a1\u8868\u5355\u6240\u6709\u7684\u5173\u8054\u5c5e\u6027\u3002")
    @RequestMapping(value={"/findDetailsById"}, method={RequestMethod.GET})
    public ResponseModel findDetailsById(@RequestParam(value="id") @ApiParam(value="\u4e3b\u952e") String id) {
        try {
            DeliverGoodVo result = this.deliverGoodVoService.findDetailsById(id);
            return this.buildHttpResultW((Object)result, new String[]{"products", "deliverAttachments"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByConditions"})
    @ApiOperation(value="\u591a\u6761\u4ef6\u5206\u9875\u67e5\u8be2", notes="\u5206\u9875\u53c2\u6570\u4e3apage\u548csize\uff0cpage\u4ece0\u5f00\u59cb\uff0csize\u9ed8\u8ba450")
    public ResponseModel findByConditions(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u53d1\u8d27\u5355dto\u7ed3\u6784\u4f53") DeliverGoodDto dto) {
        try {
            Page<DeliverGoodVo> deliverGoodVoPage = this.deliverGoodVoService.findByConditions(pageable, dto);
            return this.buildHttpResultW(deliverGoodVoPage, new String[]{"products", "deliverAttachments"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByOrderCode"})
    @ApiOperation(value="\u6839\u636e\u8ba2\u5355\u7f16\u53f7\u67e5\u8be2\u53d1\u8d27\u5355\u96c6\u5408")
    public ResponseModel findByOrderCode(@RequestParam(value="orderCode") @ApiParam(value="\u8ba2\u5355\u7f16\u53f7") String orderCode) {
        try {
            List<DeliverGoodVo> list = this.deliverGoodVoService.findByOrderCode(orderCode);
            return this.buildHttpResultW(list, new String[]{"products", "deliverAttachments"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u53d1\u8d27\u5355\u7f16\u53f7\u53d1\u8d27")
    @PostMapping(value={"deliverGoodByDeliverGoodCode"})
    public ResponseModel deliverGoodByDeliverGoodCode(@RequestBody @ApiParam(name="dto", value="\u53d1\u8d27\u5355\u7269\u6d41\u4fe1\u606fdto\u7ed3\u6784\u4f53") DeliverGoodLogisticsDto dto) {
        try {
            this.deliverGoodVoService.deliverGoodByDeliverGoodCode(dto);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u53d1\u8d27\u5355\u7f16\u53f7\u7f16\u8f91\u7269\u6d41\u4fe1\u606f")
    @PostMapping(value={"updateLogisticsByDeliverGoodCode"})
    public ResponseModel updateLogisticsByDeliverGoodCode(@RequestBody @ApiParam(name="dto", value="\u53d1\u8d27\u5355\u7269\u6d41\u4fe1\u606fdto\u7ed3\u6784\u4f53") DeliverGoodLogisticsDto dto) {
        try {
            this.deliverGoodVoService.updateLogisticsByDeliverGoodCode(dto);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

