/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.distribution.repository.internal;

import com.bizunited.empower.business.distribution.dto.DeliverGoodDto;
import com.bizunited.empower.business.distribution.entity.DeliverGood;
import com.bizunited.empower.business.distribution.repository.internal.DeliverGoodRepositoryCustom;
import com.bizunited.platform.common.repository.PageRepositoryImpl;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository(value="_DeliverGoodRepositoryImpl")
public class DeliverGoodRepositoryImpl
implements DeliverGoodRepositoryCustom,
PageRepositoryImpl {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Page<DeliverGood> findByConditions(Pageable pageable, DeliverGoodDto dto) {
        StringBuilder hql = new StringBuilder("select d from DeliverGood d where 1=1");
        StringBuilder countHql = new StringBuilder("select count(*) FROM DeliverGood d where 1=1");
        StringBuilder condition = new StringBuilder();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (dto != null) {
            Date date;
            String deliverGoodCode = dto.getDeliverGoodCode();
            String createAccount = dto.getCreateAccount();
            String customerName = dto.getCustomerName();
            Integer deliverStatus = dto.getDeliverStatus();
            String tenantCode = dto.getTenantCode();
            List<String> orderCodes = dto.getOrderCodes();
            String warehouseCode = dto.getWarehouseCode();
            Integer deliverWay = dto.getDeliverWay();
            Integer notDeliverWay = dto.getNotDeliverWay();
            String startTime = dto.getStartTime();
            String endTime = dto.getEndTime();
            Boolean plan = dto.getPlan();
            Boolean approval = dto.getApproval();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (StringUtils.isNotBlank((CharSequence)tenantCode)) {
                condition.append(" and d.tenantCode = :tenantCode ");
                parameters.put("tenantCode", tenantCode);
            }
            if (StringUtils.isNotBlank((CharSequence)deliverGoodCode)) {
                condition.append(" and d.deliverGoodCode = :deliverGoodCode ");
                parameters.put("deliverGoodCode", deliverGoodCode);
            }
            if (StringUtils.isNotBlank((CharSequence)customerName)) {
                condition.append(" and d.customerName like concat('%',:customerName,'%') ");
                parameters.put("customerName", customerName);
            }
            if (StringUtils.isNotBlank((CharSequence)createAccount)) {
                condition.append(" and d.createAccount = :createAccount ");
                parameters.put("createAccount", createAccount);
            }
            if (null != deliverStatus) {
                condition.append(" and d.deliverStatus = :deliverStatus ");
                parameters.put("deliverStatus", deliverStatus);
            }
            if (null != deliverWay) {
                condition.append(" and d.deliverWay = :deliverWay ");
                parameters.put("deliverWay", deliverWay);
            }
            if (null != notDeliverWay) {
                condition.append(" and d.deliverWay != :notDeliverWay ");
                parameters.put("notDeliverWay", notDeliverWay);
            }
            if (StringUtils.isNotBlank((CharSequence)warehouseCode)) {
                condition.append(" and d.warehouseCode = :warehouseCode ");
                parameters.put("warehouseCode", warehouseCode);
            }
            if (!CollectionUtils.isEmpty(orderCodes)) {
                condition.append(" and d.orderCode in :orderCodes ");
                parameters.put("orderCodes", orderCodes);
            }
            if (null != plan) {
                condition.append(" and d.plan = :plan ");
                parameters.put("plan", plan);
            }
            if (null != approval) {
                if (approval == Boolean.FALSE) {
                    condition.append(" and d.approval is null ");
                } else {
                    condition.append(" and d.approval = :approval ");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)startTime)) {
                try {
                    date = simpleDateFormat.parse(startTime);
                    condition.append(" and d.createTime >= :startTime ");
                    parameters.put("startTime", date);
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)endTime)) {
                try {
                    date = simpleDateFormat.parse(endTime);
                    condition.append(" and d.createTime < :endTime ");
                    parameters.put("endTime", date);
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        hql.append((CharSequence)condition).append(" order by d.createTime desc");
        countHql.append((CharSequence)condition);
        return this.queryByConditions(this.entityManager, hql.toString(), countHql.toString(), parameters, pageable, false, DeliverGood.class);
    }
}

