/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.distribution.service.internal;

import com.bizunited.empower.business.common.util.SecurityUtils;
import com.bizunited.empower.business.distribution.entity.DeliverAttachment;
import com.bizunited.empower.business.distribution.repository.DeliverAttachmentRepository;
import com.bizunited.empower.business.distribution.service.DeliverAttachmentService;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="DeliverAttachmentServiceImpl")
public class DeliverAttachmentServiceImpl
implements DeliverAttachmentService {
    @Autowired
    private DeliverAttachmentRepository deliverAttachmentRepository;

    @Override
    @Transactional
    public DeliverAttachment create(DeliverAttachment deliverAttachment) {
        DeliverAttachment current = this.createForm(deliverAttachment);
        return current;
    }

    @Override
    @Transactional
    public DeliverAttachment createForm(DeliverAttachment deliverAttachment) {
        Date now = new Date();
        deliverAttachment.setCreateAccount(SecurityUtils.getUserAccount());
        deliverAttachment.setCreateTime(now);
        deliverAttachment.setModifyAccount(SecurityUtils.getUserAccount());
        deliverAttachment.setModifyTime(now);
        this.createValidation(deliverAttachment);
        this.deliverAttachmentRepository.save((Object)deliverAttachment);
        return deliverAttachment;
    }

    private void createValidation(DeliverAttachment deliverAttachment) {
        Validate.notNull((Object)((Object)deliverAttachment), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)deliverAttachment.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        deliverAttachment.setId(null);
        Validate.notBlank((CharSequence)deliverAttachment.getRelativePath(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u76f8\u5bf9\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)deliverAttachment.getFileName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((deliverAttachment.getExtend1() == null || deliverAttachment.getExtend1().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb51,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverAttachment.getExtend2() == null || deliverAttachment.getExtend2().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb52,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverAttachment.getExtend3() == null || deliverAttachment.getExtend3().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb53,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverAttachment.getExtend4() == null || deliverAttachment.getExtend4().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb54,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverAttachment.getExtend5() == null || deliverAttachment.getExtend5().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb55,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverAttachment.getExtend6() == null || deliverAttachment.getExtend6().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb56,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverAttachment.getExtend7() == null || deliverAttachment.getExtend7().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb57,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverAttachment.getRelativePath() == null || deliverAttachment.getRelativePath().length() < 255 ? 1 : 0) != 0, (String)"\u76f8\u5bf9\u8def\u5f84,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverAttachment.getFileName() == null || deliverAttachment.getFileName().length() < 128 ? 1 : 0) != 0, (String)"\u6587\u4ef6\u540d,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public DeliverAttachment update(DeliverAttachment deliverAttachment) {
        DeliverAttachment current = this.updateForm(deliverAttachment);
        return current;
    }

    @Override
    @Transactional
    public DeliverAttachment updateForm(DeliverAttachment deliverAttachment) {
        this.updateValidation(deliverAttachment);
        String currentId = deliverAttachment.getId();
        Optional op_currentDeliverAttachment = this.deliverAttachmentRepository.findById(currentId);
        DeliverAttachment currentDeliverAttachment = op_currentDeliverAttachment.orElse(null);
        currentDeliverAttachment = (DeliverAttachment)((Object)Validate.notNull((Object)((Object)currentDeliverAttachment), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]));
        Date now = new Date();
        currentDeliverAttachment.setModifyAccount(SecurityUtils.getUserAccount());
        currentDeliverAttachment.setModifyTime(now);
        currentDeliverAttachment.setExtend1(deliverAttachment.getExtend1());
        currentDeliverAttachment.setExtend2(deliverAttachment.getExtend2());
        currentDeliverAttachment.setExtend3(deliverAttachment.getExtend3());
        currentDeliverAttachment.setExtend4(deliverAttachment.getExtend4());
        currentDeliverAttachment.setExtend5(deliverAttachment.getExtend5());
        currentDeliverAttachment.setExtend6(deliverAttachment.getExtend6());
        currentDeliverAttachment.setExtend7(deliverAttachment.getExtend7());
        currentDeliverAttachment.setExtend8(deliverAttachment.getExtend8());
        currentDeliverAttachment.setExtend9(deliverAttachment.getExtend9());
        currentDeliverAttachment.setExtend10(deliverAttachment.getExtend10());
        currentDeliverAttachment.setExtend11(deliverAttachment.getExtend11());
        currentDeliverAttachment.setRelativePath(deliverAttachment.getRelativePath());
        currentDeliverAttachment.setFileName(deliverAttachment.getFileName());
        currentDeliverAttachment.setDeliverGood(deliverAttachment.getDeliverGood());
        this.deliverAttachmentRepository.saveAndFlush((Object)currentDeliverAttachment);
        return currentDeliverAttachment;
    }

    private void updateValidation(DeliverAttachment deliverAttachment) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)deliverAttachment.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)deliverAttachment.getRelativePath(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u76f8\u5bf9\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)deliverAttachment.getFileName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((deliverAttachment.getExtend1() == null || deliverAttachment.getExtend1().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb51,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverAttachment.getExtend2() == null || deliverAttachment.getExtend2().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb52,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverAttachment.getExtend3() == null || deliverAttachment.getExtend3().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb53,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverAttachment.getExtend4() == null || deliverAttachment.getExtend4().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb54,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverAttachment.getExtend5() == null || deliverAttachment.getExtend5().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb55,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverAttachment.getExtend6() == null || deliverAttachment.getExtend6().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb56,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverAttachment.getExtend7() == null || deliverAttachment.getExtend7().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb57,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverAttachment.getRelativePath() == null || deliverAttachment.getRelativePath().length() < 255 ? 1 : 0) != 0, (String)"\u76f8\u5bf9\u8def\u5f84,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverAttachment.getFileName() == null || deliverAttachment.getFileName().length() < 128 ? 1 : 0) != 0, (String)"\u6587\u4ef6\u540d,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    public Set<DeliverAttachment> findDetailsByDeliverGood(String deliverGood) {
        if (StringUtils.isBlank((CharSequence)deliverGood)) {
            return Sets.newHashSet();
        }
        return this.deliverAttachmentRepository.findDetailsByDeliverGood(deliverGood);
    }

    @Override
    public DeliverAttachment findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.deliverAttachmentRepository.findDetailsById(id);
    }

    @Override
    public DeliverAttachment findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.deliverAttachmentRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        DeliverAttachment current = this.findById(id);
        if (current != null) {
            this.deliverAttachmentRepository.delete((Object)current);
        }
    }
}

