/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.distribution.service.internal;

import com.bizunited.empower.business.common.util.SecurityUtils;
import com.bizunited.empower.business.distribution.entity.DeliverGood;
import com.bizunited.empower.business.distribution.enums.DeliverStatus;
import com.bizunited.empower.business.distribution.enums.DeliverWay;
import com.bizunited.empower.business.distribution.repository.DeliverGoodRepository;
import com.bizunited.empower.business.distribution.service.DeliverGoodService;
import com.bizunited.empower.business.distribution.service.listener.DeliverGoodListener;
import com.bizunited.empower.business.distribution.vo.DeliverUpdateVo;
import com.bizunited.platform.common.service.redis.RedisMutexService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="DeliverGoodServiceImpl")
public class DeliverGoodServiceImpl
implements DeliverGoodService {
    @Autowired
    private DeliverGoodRepository deliverGoodRepository;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private List<DeliverGoodListener> deliverGoodListenerList;

    @Override
    @Transactional
    public DeliverGood create(DeliverGood deliverGood) {
        DeliverGood current = this.createForm(deliverGood);
        return current;
    }

    @Override
    @Transactional
    public DeliverGood createForm(DeliverGood deliverGood) {
        Date now = new Date();
        deliverGood.setCreateAccount(SecurityUtils.getUserAccount());
        deliverGood.setCreateTime(now);
        deliverGood.setModifyAccount(SecurityUtils.getUserAccount());
        deliverGood.setModifyTime(now);
        deliverGood.setTenantCode(TenantUtils.getTenantCode());
        deliverGood.setDeliverGoodCode(this.generateCode(TenantUtils.getTenantCode()));
        if (DeliverWay.DISTRIBUTION.getType().equals(deliverGood.getDeliverWay())) {
            deliverGood.setPlan(false);
        }
        this.createValidation(deliverGood);
        this.deliverGoodRepository.save((Object)deliverGood);
        if (!CollectionUtils.isEmpty(this.deliverGoodListenerList)) {
            for (DeliverGoodListener listener : this.deliverGoodListenerList) {
                if (!DeliverWay.DISTRIBUTION.getType().equals(deliverGood.getDeliverWay())) continue;
                listener.onCreate(deliverGood);
            }
        }
        return deliverGood;
    }

    private void createValidation(DeliverGood deliverGood) {
        Validate.notNull((Object)((Object)deliverGood), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)deliverGood.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        deliverGood.setId(null);
        Validate.notBlank((CharSequence)deliverGood.getTenantCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)deliverGood.getDeliverGoodCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u53d1\u8d27\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)deliverGood.getDeliverStatus(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u53d1\u8d27\u5355\u72b6\u6001 1\u5f85\u89c4\u5212 2\u5f85\u53d1\u8d27 3\u5df2\u6536\u8d27\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)deliverGood.getDeliverWay(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u53d1\u8d27\u65b9\u5f0f 1\u88c5\u8f66 2\u81ea\u63d0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)deliverGood.getWarehouseCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)deliverGood.getWarehouseName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4ed3\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)deliverGood.getCustomerCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)deliverGood.getCustomerName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)deliverGood.getPhone(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8054\u7cfb\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)deliverGood.getAddress(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getExtend1() == null || deliverGood.getExtend1().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb51,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getExtend2() == null || deliverGood.getExtend2().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb52,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getExtend3() == null || deliverGood.getExtend3().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb53,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getExtend4() == null || deliverGood.getExtend4().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb54,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getExtend5() == null || deliverGood.getExtend5().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb55,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getExtend6() == null || deliverGood.getExtend6().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb56,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getExtend7() == null || deliverGood.getExtend7().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb57,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getTenantCode() == null || deliverGood.getTenantCode().length() < 255 ? 1 : 0) != 0, (String)"\u79df\u6237\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getDeliverGoodCode() == null || deliverGood.getDeliverGoodCode().length() < 64 ? 1 : 0) != 0, (String)"\u53d1\u8d27\u5355\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getRelevanceCode() == null || deliverGood.getRelevanceCode().length() < 64 ? 1 : 0) != 0, (String)"\u5173\u8054\u5355\u636e,\u4e1a\u52a1\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getOrderCode() == null || deliverGood.getOrderCode().length() < 64 ? 1 : 0) != 0, (String)"\u5173\u8054\u8ba2\u5355\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getWarehouseCode() == null || deliverGood.getWarehouseCode().length() < 64 ? 1 : 0) != 0, (String)"\u4ed3\u5e93\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getWarehouseName() == null || deliverGood.getWarehouseName().length() < 255 ? 1 : 0) != 0, (String)"\u4ed3\u5e93\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getCustomerCode() == null || deliverGood.getCustomerCode().length() < 64 ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getCustomerName() == null || deliverGood.getCustomerName().length() < 64 ? 1 : 0) != 0, (String)"\u5ba2\u6237\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getPhone() == null || deliverGood.getPhone().length() < 64 ? 1 : 0) != 0, (String)"\u8054\u7cfb\u7535\u8bdd,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getAddress() == null || deliverGood.getAddress().length() < 255 ? 1 : 0) != 0, (String)"\u5730\u5740,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getRouteCode() == null || deliverGood.getRouteCode().length() < 64 ? 1 : 0) != 0, (String)"\u914d\u9001\u8def\u7ebf\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getRouteName() == null || deliverGood.getRouteName().length() < 64 ? 1 : 0) != 0, (String)"\u914d\u9001\u8def\u7ebf\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getRemark() == null || deliverGood.getRemark().length() < 255 ? 1 : 0) != 0, (String)"\u5907\u6ce8,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public DeliverGood update(DeliverGood deliverGood) {
        DeliverGood current = this.updateForm(deliverGood);
        return current;
    }

    @Override
    @Transactional
    public DeliverGood updateForm(DeliverGood deliverGood) {
        this.updateValidation(deliverGood);
        String currentId = deliverGood.getId();
        Optional op_currentDeliverGood = this.deliverGoodRepository.findById(currentId);
        DeliverGood currentDeliverGood = op_currentDeliverGood.orElse(null);
        currentDeliverGood = (DeliverGood)((Object)Validate.notNull((Object)((Object)currentDeliverGood), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]));
        Date now = new Date();
        currentDeliverGood.setModifyAccount(SecurityUtils.getUserAccount());
        currentDeliverGood.setModifyTime(now);
        currentDeliverGood.setExtend1(deliverGood.getExtend1());
        currentDeliverGood.setExtend2(deliverGood.getExtend2());
        currentDeliverGood.setExtend3(deliverGood.getExtend3());
        currentDeliverGood.setExtend4(deliverGood.getExtend4());
        currentDeliverGood.setExtend5(deliverGood.getExtend5());
        currentDeliverGood.setExtend6(deliverGood.getExtend6());
        currentDeliverGood.setExtend7(deliverGood.getExtend7());
        currentDeliverGood.setExtend8(deliverGood.getExtend8());
        currentDeliverGood.setExtend9(deliverGood.getExtend9());
        currentDeliverGood.setExtend10(deliverGood.getExtend10());
        currentDeliverGood.setExtend11(deliverGood.getExtend11());
        currentDeliverGood.setTenantCode(deliverGood.getTenantCode());
        currentDeliverGood.setDeliverGoodCode(deliverGood.getDeliverGoodCode());
        currentDeliverGood.setRelevanceCode(deliverGood.getRelevanceCode());
        currentDeliverGood.setOrderCode(deliverGood.getOrderCode());
        currentDeliverGood.setDeliverStatus(deliverGood.getDeliverStatus());
        currentDeliverGood.setDeliverWay(deliverGood.getDeliverWay());
        currentDeliverGood.setWarehouseCode(deliverGood.getWarehouseCode());
        currentDeliverGood.setWarehouseName(deliverGood.getWarehouseName());
        currentDeliverGood.setCustomerCode(deliverGood.getCustomerCode());
        currentDeliverGood.setCustomerName(deliverGood.getCustomerName());
        currentDeliverGood.setPhone(deliverGood.getPhone());
        currentDeliverGood.setAddress(deliverGood.getAddress());
        currentDeliverGood.setRouteCode(deliverGood.getRouteCode());
        currentDeliverGood.setRouteName(deliverGood.getRouteName());
        currentDeliverGood.setExpenseTime(deliverGood.getExpenseTime());
        currentDeliverGood.setDeliverTime(deliverGood.getDeliverTime());
        currentDeliverGood.setDeliveryTime(deliverGood.getDeliveryTime());
        currentDeliverGood.setRemark(deliverGood.getRemark());
        this.deliverGoodRepository.saveAndFlush((Object)currentDeliverGood);
        return currentDeliverGood;
    }

    private void updateValidation(DeliverGood deliverGood) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)deliverGood.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)deliverGood.getTenantCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)deliverGood.getDeliverGoodCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u53d1\u8d27\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)deliverGood.getDeliverStatus(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u53d1\u8d27\u5355\u72b6\u6001 1\u5f85\u89c4\u5212 2\u5f85\u53d1\u8d27 3\u5df2\u6536\u8d27\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)deliverGood.getDeliverWay(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u53d1\u8d27\u65b9\u5f0f 1\u88c5\u8f66 2\u81ea\u63d0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)deliverGood.getWarehouseCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)deliverGood.getWarehouseName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u4ed3\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)deliverGood.getCustomerCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)deliverGood.getCustomerName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)deliverGood.getPhone(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u8054\u7cfb\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)deliverGood.getAddress(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getExtend1() == null || deliverGood.getExtend1().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb51,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getExtend2() == null || deliverGood.getExtend2().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb52,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getExtend3() == null || deliverGood.getExtend3().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb53,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getExtend4() == null || deliverGood.getExtend4().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb54,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getExtend5() == null || deliverGood.getExtend5().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb55,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getExtend6() == null || deliverGood.getExtend6().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb56,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getExtend7() == null || deliverGood.getExtend7().length() < 255 ? 1 : 0) != 0, (String)"\u6269\u5c55\u5b57\u6bb57,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getTenantCode() == null || deliverGood.getTenantCode().length() < 255 ? 1 : 0) != 0, (String)"\u79df\u6237\u7f16\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getDeliverGoodCode() == null || deliverGood.getDeliverGoodCode().length() < 64 ? 1 : 0) != 0, (String)"\u53d1\u8d27\u5355\u7f16\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getRelevanceCode() == null || deliverGood.getRelevanceCode().length() < 64 ? 1 : 0) != 0, (String)"\u5173\u8054\u5355\u636e,\u4e1a\u52a1\u7f16\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getOrderCode() == null || deliverGood.getOrderCode().length() < 64 ? 1 : 0) != 0, (String)"\u5173\u8054\u8ba2\u5355\u7f16\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getWarehouseCode() == null || deliverGood.getWarehouseCode().length() < 64 ? 1 : 0) != 0, (String)"\u4ed3\u5e93\u7f16\u7801,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getWarehouseName() == null || deliverGood.getWarehouseName().length() < 255 ? 1 : 0) != 0, (String)"\u4ed3\u5e93\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getCustomerCode() == null || deliverGood.getCustomerCode().length() < 64 ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7f16\u7801,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getCustomerName() == null || deliverGood.getCustomerName().length() < 64 ? 1 : 0) != 0, (String)"\u5ba2\u6237\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getPhone() == null || deliverGood.getPhone().length() < 64 ? 1 : 0) != 0, (String)"\u8054\u7cfb\u7535\u8bdd,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getAddress() == null || deliverGood.getAddress().length() < 255 ? 1 : 0) != 0, (String)"\u5730\u5740,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getRouteCode() == null || deliverGood.getRouteCode().length() < 64 ? 1 : 0) != 0, (String)"\u914d\u9001\u8def\u7ebf\u7f16\u7801,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getRouteName() == null || deliverGood.getRouteName().length() < 64 ? 1 : 0) != 0, (String)"\u914d\u9001\u8def\u7ebf\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverGood.getRemark() == null || deliverGood.getRemark().length() < 255 ? 1 : 0) != 0, (String)"\u5907\u6ce8,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    private String generateCode(String tenantCode) {
        String redisKey = String.format("deliver:good:code:index:%s", tenantCode);
        String index = this.redisMutexService.getAndIncrement(redisKey, 1L, Integer.valueOf(6));
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return StringUtils.join((Object[])new String[]{"FH", format.format(new Date()), index});
    }

    @Override
    public DeliverGood findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.deliverGoodRepository.findDetailsById(id);
    }

    @Override
    public DeliverGood findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.deliverGoodRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        DeliverGood current = this.findById(id);
        if (current != null) {
            this.deliverGoodRepository.delete((Object)current);
        }
    }

    @Override
    @Transactional
    public void cancelByExpenseCode(String expenseCode) {
        Validate.notBlank((CharSequence)expenseCode, (String)"\u53d6\u6d88\u53d1\u8d27\u5355\u65f6\uff0c\u51fa\u5e93\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DeliverGood deliverGood = this.deliverGoodRepository.findByRelevanceCodeAndTenantCode(expenseCode, TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)deliverGood), (String)"\u53d6\u6d88\u53d1\u8d27\u5355\u65f6\uff0c\u67e5\u8be2\u5230\u7684\u53d1\u8d27\u5355\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)DeliverStatus.WAIT_DELIVER.getType().equals(deliverGood.getDeliverStatus()), (String)"\u53d6\u6d88\u53d1\u8d27\u5355\u65f6,\u53d1\u8d27\u5355\u72b6\u6001\u5fc5\u987b\u4e3a\u5f85\u53d1\u8d27", (Object[])new Object[0]);
        deliverGood.setDeliverStatus(DeliverStatus.CANCEL.getType());
        this.deliverGoodRepository.saveAndFlush((Object)deliverGood);
        this.triggerDeliverGoodListener(deliverGood);
    }

    @Override
    @Transactional
    public void deliverByExpenseCode(String expenseCode) {
        Validate.notBlank((CharSequence)expenseCode, (String)"\u53d1\u8d27\u5355\u53d1\u8d27\u65f6\uff0c\u51fa\u5e93\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DeliverGood deliverGood = this.deliverGoodRepository.findByRelevanceCodeAndTenantCode(expenseCode, TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)deliverGood), (String)"\u53d1\u8d27\u5355\u53d1\u8d27\u65f6\uff0c\u67e5\u8be2\u5230\u7684\u53d1\u8d27\u5355\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)DeliverStatus.WAIT_DELIVER.getType().equals(deliverGood.getDeliverStatus()), (String)"\u53d1\u8d27\u5355\u53d1\u8d27\u65f6,\u53d1\u8d27\u5355\u72b6\u6001\u5fc5\u987b\u4e3a\u5f85\u53d1\u8d27", (Object[])new Object[0]);
        Validate.isTrue((!DeliverWay.DISTRIBUTION.getType().equals(deliverGood.getDeliverWay()) ? 1 : 0) != 0, (String)"\u53d1\u8d27\u65f6,\u53d1\u8d27\u5355\u53d1\u8d27\u7c7b\u578b\u4e0d\u80fd\u4e3a\u51fa\u8f66\u914d\u9001", (Object[])new Object[0]);
        deliverGood.setDeliverStatus(DeliverStatus.ALREADY_DELIVER.getType());
        this.deliverGoodRepository.saveAndFlush((Object)deliverGood);
        this.triggerDeliverGoodListener(deliverGood);
    }

    @Override
    @Transactional
    public void batchUpdateStatusByDeliverGoodCodeAndTenantCode(DeliverUpdateVo deliverUpdateVo) {
        Validate.notNull((Object)deliverUpdateVo, (String)"\u6279\u91cf\u66f4\u6539\u53d1\u8d27\u5355\u72b6\u6001\u65f6\uff0c\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty(deliverUpdateVo.getDeliverGoodCodes(), (String)"\u6279\u91cf\u66f4\u6539\u53d1\u8d27\u5355\u72b6\u6001\u65f6\uff0c\u53d1\u8d27\u5355\u53f7\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)deliverUpdateVo.getOldDeliverStatus(), (String)"\u6279\u91cf\u66f4\u6539\u53d1\u8d27\u5355\u72b6\u6001\u65f6\uff0c\u65e7\u53d1\u8d27\u5355\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)deliverUpdateVo.getDeliverStatus(), (String)"\u6279\u91cf\u66f4\u6539\u53d1\u8d27\u5355\u72b6\u6001\u65f6\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)deliverUpdateVo.getTenantCode(), (String)"\u6279\u91cf\u66f4\u6539\u53d1\u8d27\u5355\u72b6\u6001\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (String deliverGoodCode : deliverUpdateVo.getDeliverGoodCodes()) {
            DeliverGood deliverGood = this.deliverGoodRepository.findByDeliverGoodCodeAndTenantCode(deliverGoodCode, deliverUpdateVo.getTenantCode());
            Validate.notNull((Object)((Object)deliverGood), (String)"\u6279\u91cf\u66f4\u6539\u53d1\u8d27\u5355\u72b6\u6001\u65f6\uff0c\u67e5\u8be2\u5230\u7684\u53d1\u8d27\u5355\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)deliverUpdateVo.getOldDeliverStatus().equals(deliverGood.getDeliverStatus()), (String)("\u6279\u91cf\u66f4\u6539\u53d1\u8d27\u5355\u72b6\u6001\u65f6\uff0c\u53d1\u8d27\u5355" + deliverGoodCode + "\u72b6\u6001\u4e0d\u7edf\u4e00"), (Object[])new Object[0]);
            this.judgingState(deliverUpdateVo, deliverGood);
            deliverGood.setDeliverStatus(deliverUpdateVo.getDeliverStatus());
            this.deliverGoodRepository.saveAndFlush((Object)deliverGood);
            deliverGood.setVehicleTaskCode(deliverUpdateVo.getVehicleTaskCode());
            this.triggerDeliverGoodListener(deliverGood);
        }
    }

    @Override
    @Transactional
    public void updateStatusByDeliverGoodCodeAndTenantCode(DeliverUpdateVo deliverUpdateVo) {
        Validate.notEmpty((CharSequence)deliverUpdateVo.getDeliverGoodCode(), (String)"\u66f4\u6539\u53d1\u8d27\u5355\u72b6\u6001\u65f6\uff0c\u53d1\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)deliverUpdateVo.getOldDeliverStatus(), (String)"\u66f4\u6539\u53d1\u8d27\u5355\u72b6\u6001\u65f6\uff0c\u65e7\u53d1\u8d27\u5355\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)deliverUpdateVo.getDeliverStatus(), (String)"\u66f4\u6539\u53d1\u8d27\u5355\u72b6\u6001\u65f6\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)deliverUpdateVo.getTenantCode(), (String)"\u66f4\u6539\u53d1\u8d27\u5355\u72b6\u6001\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DeliverGood deliverGood = this.deliverGoodRepository.findByDeliverGoodCodeAndTenantCode(deliverUpdateVo.getDeliverGoodCode(), deliverUpdateVo.getTenantCode());
        Validate.notNull((Object)((Object)deliverGood), (String)"\u6279\u91cf\u66f4\u6539\u53d1\u8d27\u5355\u72b6\u6001\u65f6\uff0c\u67e5\u8be2\u5230\u7684\u53d1\u8d27\u5355\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)deliverUpdateVo.getOldDeliverStatus().equals(deliverGood.getDeliverStatus()), (String)("\u66f4\u6539\u53d1\u8d27\u5355\u72b6\u6001\u65f6\uff0c\u53d1\u8d27\u5355" + deliverGood.getDeliverGoodCode() + "\u4e0e\u9884\u8ba1\u72b6\u6001\u4e0d\u7b26"), (Object[])new Object[0]);
        this.judgingState(deliverUpdateVo, deliverGood);
        deliverGood.setDeliverStatus(deliverUpdateVo.getDeliverStatus());
        this.deliverGoodRepository.saveAndFlush((Object)deliverGood);
        this.triggerDeliverGoodListener(deliverGood);
    }

    @Override
    @Transactional
    public void receivingGood(String deliverGoodCode) {
        Validate.notEmpty((CharSequence)deliverGoodCode, (String)"\u53d1\u8d27\u5355\u6536\u8d27\u65f6\uff0c\u53d1\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DeliverGood deliverGood = this.deliverGoodRepository.findByDeliverGoodCodeAndTenantCode(deliverGoodCode, TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)deliverGood), (String)"\u53d1\u8d27\u5355\u6536\u8d27\u65f6\uff0c\u67e5\u8be2\u5230\u7684\u53d1\u8d27\u5355\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)DeliverStatus.ALREADY_DELIVER.getType().equals(deliverGood.getDeliverStatus()), (String)"\u53d1\u8d27\u5355\u6536\u8d27\u65f6,\u53d1\u8d27\u5355\u72b6\u6001\u5fc5\u987b\u4e3a\u5f85\u6536\u8d27", (Object[])new Object[0]);
        if (null == deliverGood.getDeliveryTime()) {
            deliverGood.setDeliveryTime(new Date());
        }
        deliverGood.setDeliverStatus(DeliverStatus.ALREADY_RECEIVE.getType());
        this.deliverGoodRepository.saveAndFlush((Object)deliverGood);
        this.triggerDeliverGoodListener(deliverGood);
    }

    @Override
    @Transactional
    public void updateDeliveryTimeByDeliverGoodCodeAndTenantCode(String deliverGoodCode, Date date, String tenantCode) {
        Validate.isTrue((StringUtils.isNotEmpty((CharSequence)deliverGoodCode) && null != date && StringUtils.isNotEmpty((CharSequence)tenantCode) ? 1 : 0) != 0, (String)"\u66f4\u6539\u53d1\u8d27\u5355\u4ea4\u8d27\u65f6\u95f4\u65f6\u53c2\u6570\u4e0d\u6b63\u786e", (Object[])new Object[0]);
        DeliverGood deliverGood = this.deliverGoodRepository.findByDeliverGoodCodeAndTenantCode(deliverGoodCode, tenantCode);
        Validate.notNull((Object)((Object)deliverGood), (String)"\u66f4\u6539\u53d1\u8d27\u5355\u4ea4\u8d27\u65f6\u95f4\u65f6\u672a\u67e5\u8be2\u5230\u53d1\u8d27\u5355", (Object[])new Object[0]);
        deliverGood.setDeliveryTime(date);
        this.deliverGoodRepository.saveAndFlush((Object)deliverGood);
    }

    @Override
    @Transactional
    public void updatePlanByDeliverGoodCodeAndTenantCode(DeliverUpdateVo deliverUpdateVo) {
        Validate.notEmpty((CharSequence)deliverUpdateVo.getDeliverGoodCode(), (String)"\u66f4\u6539\u53d1\u8d27\u5355\u89c4\u5212\u72b6\u6001\u65f6\uff0c\u53d1\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)deliverUpdateVo.getPlan(), (String)"\u66f4\u6539\u53d1\u8d27\u5355\u89c4\u5212\u72b6\u6001\u65f6\uff0c\u662f\u5426\u89c4\u5212\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)deliverUpdateVo.getTenantCode(), (String)"\u66f4\u6539\u53d1\u8d27\u5355\u89c4\u5212\u72b6\u6001\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DeliverGood deliverGood = this.deliverGoodRepository.findByDeliverGoodCodeAndTenantCode(deliverUpdateVo.getDeliverGoodCode(), deliverUpdateVo.getTenantCode());
        Validate.notNull((Object)((Object)deliverGood), (String)"\u66f4\u6539\u53d1\u8d27\u5355\u89c4\u5212\u72b6\u6001\u65f6\u672a\u67e5\u8be2\u5230\u53d1\u8d27\u5355", (Object[])new Object[0]);
        Validate.isTrue((boolean)DeliverStatus.WAIT_DELIVER.getType().equals(deliverGood.getDeliverStatus()), (String)"\u66f4\u6539\u53d1\u8d27\u5355\u89c4\u5212\u72b6\u6001\u65f6,\u53d1\u8d27\u5355\u72b6\u6001\u5fc5\u987b\u4e3a\u5f85\u53d1\u8d27", (Object[])new Object[0]);
        Validate.isTrue((boolean)DeliverWay.DISTRIBUTION.getType().equals(deliverGood.getDeliverWay()), (String)"\u66f4\u6539\u53d1\u8d27\u5355\u89c4\u5212\u72b6\u6001\u65f6,\u53d1\u8d27\u5355\u53d1\u8d27\u7c7b\u578b\u5fc5\u987b\u4e3a\u88c5\u8f66", (Object[])new Object[0]);
        this.judgingPlan(deliverUpdateVo, deliverGood);
        this.deliverGoodRepository.saveAndFlush((Object)deliverGood);
    }

    @Override
    @Transactional
    public void batchUpdatePlanByDeliverGoodCodeAndTenantCode(DeliverUpdateVo deliverUpdateVo) {
        Validate.notEmpty(deliverUpdateVo.getDeliverGoodCodes(), (String)"\u66f4\u6539\u53d1\u8d27\u5355\u89c4\u5212\u72b6\u6001\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (String deliverGoodCode : deliverUpdateVo.getDeliverGoodCodes()) {
            deliverUpdateVo.setDeliverGoodCode(deliverGoodCode);
            this.updatePlanByDeliverGoodCodeAndTenantCode(deliverUpdateVo);
        }
    }

    @Override
    @Transactional
    public void revokeGood(String deliverGoodCode) {
        Validate.notEmpty((CharSequence)deliverGoodCode, (String)"\u64a4\u9500\u53d1\u8d27\u5355\u65f6\uff0c\u53d1\u8d27\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DeliverGood deliverGood = this.deliverGoodRepository.findByDeliverGoodCodeAndTenantCode(deliverGoodCode, TenantUtils.getTenantCode());
        Validate.isTrue((boolean)DeliverStatus.ALREADY_DELIVER.getType().equals(deliverGood.getDeliverStatus()), (String)"\u64a4\u9500\u53d1\u8d27\u5355\u65f6,\u53d1\u8d27\u5355\u72b6\u6001\u5fc5\u987b\u4e3a\u5f85\u6536\u8d27", (Object[])new Object[0]);
        deliverGood.setDeliverStatus(DeliverStatus.WAIT_DELIVER.getType());
        if (!CollectionUtils.isEmpty(this.deliverGoodListenerList)) {
            for (DeliverGoodListener listener : this.deliverGoodListenerList) {
                listener.onRevoke(deliverGood);
            }
        }
        DeliverUpdateVo deliverUpdateVo = new DeliverUpdateVo();
        deliverUpdateVo.setPlan(false);
        this.judgingPlan(deliverUpdateVo, deliverGood);
        this.deliverGoodRepository.saveAndFlush((Object)deliverGood);
    }

    @Override
    @Transactional
    public void approvalByDeliverGoodCode(String deliverGoodCode) {
        Validate.notEmpty((CharSequence)deliverGoodCode, (String)"\u53d1\u8d27\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DeliverGood deliverGood = this.deliverGoodRepository.findByDeliverGoodCodeAndTenantCode(deliverGoodCode, TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)deliverGood), (String)"\u672a\u67e5\u8be2\u5230\u53d1\u8d27\u5355", (Object[])new Object[0]);
        deliverGood.setApproval(true);
        deliverGood.setDeliveryTime(new Date());
        deliverGood.setDeliverStatus(DeliverStatus.ALREADY_RECEIVE.getType());
        this.deliverGoodRepository.saveAndFlush((Object)deliverGood);
        this.triggerDeliverGoodListener(deliverGood);
    }

    private void judgingState(DeliverUpdateVo deliverUpdateVo, DeliverGood deliverGood) {
        deliverGood.setNoticeVehicleTask(deliverUpdateVo.getNoticeVehicleTask());
        switch (deliverUpdateVo.getDeliverStatus()) {
            case 1: {
                if (!deliverUpdateVo.getPlan().booleanValue()) {
                    deliverGood.setRouteCode(null);
                    deliverGood.setRouteName(null);
                    deliverGood.setCarNumber(null);
                    deliverGood.setSaleManAccount(null);
                    deliverGood.setSaleManName(null);
                    deliverGood.setVehicleTaskCode(null);
                    deliverGood.setDeliverTime(null);
                }
                deliverGood.setPlan(deliverUpdateVo.getPlan());
                break;
            }
            case 2: {
                deliverGood.setRouteCode(deliverUpdateVo.getRouteCode());
                deliverGood.setRouteName(deliverUpdateVo.getRouteName());
                deliverGood.setCarNumber(deliverUpdateVo.getCarNumber());
                deliverGood.setSaleManAccount(deliverUpdateVo.getSaleManAccount());
                deliverGood.setSaleManName(deliverUpdateVo.getSaleManName());
                deliverGood.setVehicleTaskCode(deliverUpdateVo.getVehicleTaskCode());
                deliverGood.setDeliverTime(deliverUpdateVo.getDeliverTime());
                break;
            }
            case 3: {
                deliverGood.setDeliveryTime(deliverUpdateVo.getDeliveryTime());
                break;
            }
        }
    }

    private void judgingPlan(DeliverUpdateVo deliverUpdateVo, DeliverGood deliverGood) {
        if (deliverUpdateVo.getPlan().booleanValue()) {
            deliverGood.setPlan(true);
            deliverGood.setRouteCode(deliverUpdateVo.getRouteCode());
            deliverGood.setRouteName(deliverUpdateVo.getRouteName());
            deliverGood.setCarNumber(deliverUpdateVo.getCarNumber());
            deliverGood.setSaleManAccount(deliverUpdateVo.getSaleManAccount());
            deliverGood.setSaleManName(deliverUpdateVo.getSaleManName());
            deliverGood.setVehicleTaskCode(deliverUpdateVo.getVehicleTaskCode());
        } else {
            deliverGood.setPlan(false);
            deliverGood.setRouteCode(null);
            deliverGood.setRouteName(null);
            deliverGood.setCarNumber(null);
            deliverGood.setSaleManAccount(null);
            deliverGood.setSaleManName(null);
            deliverGood.setVehicleTaskCode(null);
            if (DeliverWay.LOGISTIC.getType().equals(deliverGood.getDeliverWay())) {
                deliverGood.setLogisticsDate(null);
                deliverGood.setLogisticsRemark(null);
                deliverGood.setLogisticsCompanyCode(null);
                deliverGood.setLogisticsCompanyName(null);
                deliverGood.setLogisticsOrderCode(null);
            }
        }
    }

    private void triggerDeliverGoodListener(DeliverGood deliverGood) {
        if (!CollectionUtils.isEmpty(this.deliverGoodListenerList)) {
            switch (deliverGood.getDeliverStatus()) {
                case 1: {
                    for (DeliverGoodListener listener : this.deliverGoodListenerList) {
                        listener.onRevoke(deliverGood);
                    }
                    break;
                }
                case 2: {
                    for (DeliverGoodListener listener : this.deliverGoodListenerList) {
                        listener.deliverGood(deliverGood);
                    }
                    break;
                }
                case 3: {
                    for (DeliverGoodListener listener : this.deliverGoodListenerList) {
                        listener.onReceiving(deliverGood);
                    }
                    break;
                }
                case 4: {
                    for (DeliverGoodListener listener : this.deliverGoodListenerList) {
                        listener.onCancel(deliverGood);
                    }
                    break;
                }
            }
        }
    }
}

