/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.distribution.service.internal;

import com.bizunited.empower.business.distribution.dto.DeliverGoodDto;
import com.bizunited.empower.business.distribution.dto.DeliverGoodLogisticsDto;
import com.bizunited.empower.business.distribution.entity.DeliverGood;
import com.bizunited.empower.business.distribution.enums.DeliverStatus;
import com.bizunited.empower.business.distribution.enums.DeliverWay;
import com.bizunited.empower.business.distribution.repository.DeliverGoodRepository;
import com.bizunited.empower.business.distribution.repository.internal.DeliverGoodRepositoryCustom;
import com.bizunited.empower.business.distribution.service.DeliverGoodVoService;
import com.bizunited.empower.business.distribution.service.listener.DeliverGoodListener;
import com.bizunited.empower.business.distribution.vo.DeliverGoodVo;
import com.bizunited.empower.business.distribution.vo.DeliverProductVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="DeliverGoodVoServiceImpl")
public class DeliverGoodVoServiceImpl
implements DeliverGoodVoService {
    @Autowired
    @Qualifier(value="_DeliverGoodRepositoryImpl")
    private DeliverGoodRepositoryCustom deliverGoodRepositoryCustom;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private DeliverGoodRepository deliverGoodRepository;
    @Autowired(required=false)
    private List<DeliverGoodListener> deliverGoodListenerList;

    @Override
    public DeliverGoodVo findDetailsById(String id) {
        if (StringUtils.isEmpty((Object)id)) {
            return new DeliverGoodVo();
        }
        DeliverGood deliverGood = this.deliverGoodRepository.findDetailsById(id);
        DeliverGoodVo deliverGoodVo = (DeliverGoodVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)deliverGood, DeliverGoodVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"products", "deliverAttachments"}));
        return deliverGoodVo;
    }

    @Override
    public Page<DeliverGoodVo> findByConditions(Pageable pageable, DeliverGoodDto dto) {
        PageImpl visitPlanPageVoPage;
        if (null == dto) {
            return new PageImpl((List)Lists.newArrayList(), pageable, 0L);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<DeliverGood> page = this.deliverGoodRepositoryCustom.findByConditions(pageable, dto);
        List content = page.getContent();
        if (!content.isEmpty()) {
            Collection visitPlanPageVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)content, DeliverGood.class, DeliverGoodVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"products", "deliverAttachments"});
            visitPlanPageVoPage = new PageImpl(new ArrayList(visitPlanPageVos), pageable, page.getTotalElements());
        } else {
            visitPlanPageVoPage = new PageImpl((List)Lists.newArrayList(), pageable, 0L);
        }
        return visitPlanPageVoPage;
    }

    @Override
    public List<DeliverGoodVo> findByDeliverGoodCodes(List<String> deliverGoodCodes) {
        if (CollectionUtils.isEmpty(deliverGoodCodes)) {
            return new ArrayList<DeliverGoodVo>();
        }
        List<DeliverGood> deliverGoodList = this.deliverGoodRepository.findByDeliverGoodCodesAndTenantCode(deliverGoodCodes, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(deliverGoodList)) {
            return new ArrayList<DeliverGoodVo>();
        }
        return this.deliverGoodListToDeliverGoodVoList(deliverGoodList);
    }

    private List<DeliverGoodVo> deliverGoodListToDeliverGoodVoList(List<DeliverGood> deliverGoodList) {
        Collection deliverGoodVoCollection = this.nebulaToolkitService.copyCollectionByWhiteList(deliverGoodList, DeliverGood.class, DeliverGoodVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"products", "deliverAttachments"});
        for (DeliverGoodVo deliverGoodVo : deliverGoodVoCollection) {
            BigDecimal productTotalPrice = deliverGoodVo.getProducts().stream().map(DeliverProductVo::getSubtotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            deliverGoodVo.setProductTotalPrice(productTotalPrice);
            BigDecimal productTotalQuantity = deliverGoodVo.getProducts().stream().map(DeliverProductVo::getDeliverQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            deliverGoodVo.setProductTotalQuantity(productTotalQuantity);
        }
        return new ArrayList<DeliverGoodVo>(deliverGoodVoCollection);
    }

    @Override
    public DeliverGoodVo findByDeliverGoodCode(String deliverGoodCode) {
        if (StringUtils.isEmpty((Object)deliverGoodCode)) {
            return null;
        }
        DeliverGood deliverGood = this.deliverGoodRepository.findByDeliverGoodCodeAndTenantCode(deliverGoodCode, TenantUtils.getTenantCode());
        DeliverGoodVo deliverGoodVo = (DeliverGoodVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)deliverGood, DeliverGoodVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"products", "deliverAttachments"}));
        return deliverGoodVo;
    }

    @Override
    @Transactional
    public void deliverGoodByDeliverGoodCode(DeliverGoodLogisticsDto dto) {
        Validate.notNull((Object)dto, (String)"\u53d1\u8d27\u65f6,\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DeliverGood deliverGood = this.deliverGoodRepository.findByDeliverGoodCodeAndTenantCode(dto.getDeliverGoodCode(), TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)deliverGood), (String)"\u53d1\u8d27\u65f6,\u67e5\u8be2\u5230\u7684\u53d1\u8d27\u5355\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)DeliverStatus.WAIT_DELIVER.getType().equals(deliverGood.getDeliverStatus()), (String)"\u53d1\u8d27\u65f6,\u53d1\u8d27\u5355\u72b6\u6001\u5fc5\u987b\u4e3a\u5f85\u53d1\u8d27", (Object[])new Object[0]);
        Validate.isTrue((!DeliverWay.DISTRIBUTION.getType().equals(deliverGood.getDeliverWay()) ? 1 : 0) != 0, (String)"\u53d1\u8d27\u65f6,\u53d1\u8d27\u5355\u53d1\u8d27\u7c7b\u578b\u4e0d\u80fd\u4e3a\u51fa\u8f66\u914d\u9001", (Object[])new Object[0]);
        deliverGood.setLogisticsOrderCode(dto.getLogisticsOrderCode());
        deliverGood.setLogisticsCompanyCode(dto.getLogisticsCompanyCode());
        deliverGood.setLogisticsCompanyName(dto.getLogisticsCompanyName());
        deliverGood.setLogisticsDate(dto.getLogisticsDate());
        deliverGood.setLogisticsRemark(dto.getLogisticsRemark());
        deliverGood.setDeliverTime(new Date());
        deliverGood.setDeliverStatus(DeliverStatus.ALREADY_DELIVER.getType());
        this.deliverGoodRepository.saveAndFlush((Object)deliverGood);
        if (!CollectionUtils.isEmpty(this.deliverGoodListenerList)) {
            for (DeliverGoodListener listener : this.deliverGoodListenerList) {
                listener.deliverGood(deliverGood);
            }
        }
    }

    @Override
    public List<DeliverGoodVo> findByOrderCode(String orderCode) {
        if (StringUtils.isEmpty((Object)orderCode)) {
            return new ArrayList<DeliverGoodVo>();
        }
        List<DeliverGood> deliverGoods = this.deliverGoodRepository.findByOrderCodeAndTenantCode(orderCode, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(deliverGoods)) {
            return new ArrayList<DeliverGoodVo>();
        }
        Collection deliverGoodVoCollection = this.nebulaToolkitService.copyCollectionByWhiteList(deliverGoods, DeliverGood.class, DeliverGoodVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"products", "deliverAttachments"});
        for (DeliverGoodVo deliverGoodVo : deliverGoodVoCollection) {
            BigDecimal productTotalPrice = deliverGoodVo.getProducts().stream().map(DeliverProductVo::getSubtotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            deliverGoodVo.setProductTotalPrice(productTotalPrice);
            BigDecimal productTotalQuantity = deliverGoodVo.getProducts().stream().map(DeliverProductVo::getDeliverQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            deliverGoodVo.setProductTotalQuantity(productTotalQuantity);
        }
        return new ArrayList<DeliverGoodVo>(deliverGoodVoCollection);
    }

    @Override
    @Transactional
    public void updateLogisticsByDeliverGoodCode(DeliverGoodLogisticsDto dto) {
        Validate.notNull((Object)dto, (String)"\u7f16\u8f91\u7269\u6d41\u4fe1\u606f\u65f6,\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DeliverGood deliverGood = this.deliverGoodRepository.findByDeliverGoodCodeAndTenantCode(dto.getDeliverGoodCode(), TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)deliverGood), (String)"\u7f16\u8f91\u7269\u6d41\u4fe1\u606f\u65f6,\u67e5\u8be2\u5230\u7684\u53d1\u8d27\u5355\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)DeliverStatus.ALREADY_DELIVER.getType().equals(deliverGood.getDeliverStatus()), (String)"\u7f16\u8f91\u7269\u6d41\u4fe1\u606f\u65f6,\u53d1\u8d27\u5355\u72b6\u6001\u5fc5\u987b\u4e3a\u5f85\u6536\u8d27", (Object[])new Object[0]);
        Validate.isTrue((boolean)DeliverWay.LOGISTIC.getType().equals(deliverGood.getDeliverWay()), (String)"\u7f16\u8f91\u7269\u6d41\u4fe1\u606f\u65f6,\u53d1\u8d27\u5355\u53d1\u8d27\u7c7b\u578b\u5fc5\u987b\u4e3a\u7b2c\u4e09\u65b9\u7269\u6d41", (Object[])new Object[0]);
        deliverGood.setLogisticsOrderCode(dto.getLogisticsOrderCode());
        deliverGood.setLogisticsCompanyCode(dto.getLogisticsCompanyCode());
        deliverGood.setLogisticsCompanyName(dto.getLogisticsCompanyName());
        deliverGood.setLogisticsDate(dto.getLogisticsDate());
        deliverGood.setLogisticsRemark(dto.getLogisticsRemark());
        deliverGood.setDeliverTime(new Date());
        this.deliverGoodRepository.saveAndFlush((Object)deliverGood);
    }

    @Override
    public List<DeliverGoodVo> findByCustomerCodesAndDeliverTimeAndTenantCode(List<String> customerCodes, Date taskTime, String tenantCode) {
        if (CollectionUtils.isEmpty(customerCodes) || null == taskTime) {
            return new ArrayList<DeliverGoodVo>();
        }
        List<DeliverGood> deliverGoodList = this.deliverGoodRepository.findByCustomerCodesAndDeliverTimeAndTenantCode(customerCodes, taskTime, tenantCode);
        if (CollectionUtils.isEmpty(deliverGoodList)) {
            return new ArrayList<DeliverGoodVo>();
        }
        return this.deliverGoodListToDeliverGoodVoList(deliverGoodList);
    }
}

