/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.distribution.service.internal;

import com.bizunited.empower.business.distribution.entity.DeliverProduct;
import com.bizunited.empower.business.distribution.repository.DeliverProductRepository;
import com.bizunited.empower.business.distribution.service.DeliverProductService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="DeliverProductServiceImpl")
public class DeliverProductServiceImpl
implements DeliverProductService {
    @Autowired
    private DeliverProductRepository deliverProductRepository;

    @Override
    @Transactional
    public DeliverProduct create(DeliverProduct deliverProduct) {
        DeliverProduct current = this.createForm(deliverProduct);
        return current;
    }

    @Override
    @Transactional
    public DeliverProduct createForm(DeliverProduct deliverProduct) {
        deliverProduct.setTenantCode(TenantUtils.getTenantCode());
        this.createValidation(deliverProduct);
        this.deliverProductRepository.save((Object)deliverProduct);
        return deliverProduct;
    }

    private void createValidation(DeliverProduct deliverProduct) {
        Validate.notNull((Object)((Object)deliverProduct), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)deliverProduct.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        deliverProduct.setId(null);
        Validate.notBlank((CharSequence)deliverProduct.getTenantCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)deliverProduct.getProductCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)deliverProduct.getProductName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)deliverProduct.getProductSpecificationCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u89c4\u683c\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)deliverProduct.getProductSpecificationName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u89c4\u683c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)deliverProduct.getUnitCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5355\u4f4d\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)deliverProduct.getUnitName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)deliverProduct.getOrderQuantity(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8ba2\u8d27\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((deliverProduct.getTenantCode() == null || deliverProduct.getTenantCode().length() < 255 ? 1 : 0) != 0, (String)"\u79df\u6237\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverProduct.getProductCode() == null || deliverProduct.getProductCode().length() < 255 ? 1 : 0) != 0, (String)"\u5546\u54c1\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverProduct.getProductName() == null || deliverProduct.getProductName().length() < 255 ? 1 : 0) != 0, (String)"\u5546\u54c1\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverProduct.getRelativePath() == null || deliverProduct.getRelativePath().length() < 255 ? 1 : 0) != 0, (String)"\u76f8\u5bf9\u8def\u5f84,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverProduct.getFileName() == null || deliverProduct.getFileName().length() < 255 ? 1 : 0) != 0, (String)"\u6587\u4ef6\u540d,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverProduct.getProductSpecificationCode() == null || deliverProduct.getProductSpecificationCode().length() < 64 ? 1 : 0) != 0, (String)"\u89c4\u683c\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverProduct.getProductSpecificationName() == null || deliverProduct.getProductSpecificationName().length() < 128 ? 1 : 0) != 0, (String)"\u89c4\u683c\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverProduct.getUnitCode() == null || deliverProduct.getUnitCode().length() < 64 ? 1 : 0) != 0, (String)"\u5355\u4f4d\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverProduct.getUnitName() == null || deliverProduct.getUnitName().length() < 128 ? 1 : 0) != 0, (String)"\u5355\u4f4d\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverProduct.getRemark() == null || deliverProduct.getRemark().length() < 255 ? 1 : 0) != 0, (String)"\u5907\u6ce8,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public DeliverProduct update(DeliverProduct deliverProduct) {
        DeliverProduct current = this.updateForm(deliverProduct);
        return current;
    }

    @Override
    @Transactional
    public DeliverProduct updateForm(DeliverProduct deliverProduct) {
        this.updateValidation(deliverProduct);
        String currentId = deliverProduct.getId();
        Optional op_currentDeliverProduct = this.deliverProductRepository.findById(currentId);
        DeliverProduct currentDeliverProduct = op_currentDeliverProduct.orElse(null);
        currentDeliverProduct = (DeliverProduct)((Object)Validate.notNull((Object)((Object)currentDeliverProduct), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]));
        currentDeliverProduct.setTenantCode(deliverProduct.getTenantCode());
        currentDeliverProduct.setProductCode(deliverProduct.getProductCode());
        currentDeliverProduct.setProductName(deliverProduct.getProductName());
        currentDeliverProduct.setRelativePath(deliverProduct.getRelativePath());
        currentDeliverProduct.setFileName(deliverProduct.getFileName());
        currentDeliverProduct.setProductSpecificationCode(deliverProduct.getProductSpecificationCode());
        currentDeliverProduct.setProductSpecificationName(deliverProduct.getProductSpecificationName());
        currentDeliverProduct.setUnitCode(deliverProduct.getUnitCode());
        currentDeliverProduct.setUnitName(deliverProduct.getUnitName());
        currentDeliverProduct.setOrderQuantity(deliverProduct.getOrderQuantity());
        currentDeliverProduct.setDeliverQuantity(deliverProduct.getDeliverQuantity());
        currentDeliverProduct.setUnitPrice(deliverProduct.getUnitPrice());
        currentDeliverProduct.setSubtotalAmount(deliverProduct.getSubtotalAmount());
        currentDeliverProduct.setRemark(deliverProduct.getRemark());
        currentDeliverProduct.setDeliverGood(deliverProduct.getDeliverGood());
        this.deliverProductRepository.saveAndFlush((Object)currentDeliverProduct);
        return currentDeliverProduct;
    }

    private void updateValidation(DeliverProduct deliverProduct) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)deliverProduct.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)deliverProduct.getTenantCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)deliverProduct.getProductCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)deliverProduct.getProductName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)deliverProduct.getProductSpecificationCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u89c4\u683c\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)deliverProduct.getProductSpecificationName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u89c4\u683c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)deliverProduct.getUnitCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5355\u4f4d\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)deliverProduct.getUnitName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)deliverProduct.getOrderQuantity(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u8ba2\u8d27\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((deliverProduct.getTenantCode() == null || deliverProduct.getTenantCode().length() < 255 ? 1 : 0) != 0, (String)"\u79df\u6237\u7f16\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverProduct.getProductCode() == null || deliverProduct.getProductCode().length() < 255 ? 1 : 0) != 0, (String)"\u5546\u54c1\u7f16\u7801,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverProduct.getProductName() == null || deliverProduct.getProductName().length() < 255 ? 1 : 0) != 0, (String)"\u5546\u54c1\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverProduct.getRelativePath() == null || deliverProduct.getRelativePath().length() < 255 ? 1 : 0) != 0, (String)"\u76f8\u5bf9\u8def\u5f84,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverProduct.getFileName() == null || deliverProduct.getFileName().length() < 255 ? 1 : 0) != 0, (String)"\u6587\u4ef6\u540d,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverProduct.getProductSpecificationCode() == null || deliverProduct.getProductSpecificationCode().length() < 64 ? 1 : 0) != 0, (String)"\u89c4\u683c\u7f16\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverProduct.getProductSpecificationName() == null || deliverProduct.getProductSpecificationName().length() < 128 ? 1 : 0) != 0, (String)"\u89c4\u683c\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverProduct.getUnitCode() == null || deliverProduct.getUnitCode().length() < 64 ? 1 : 0) != 0, (String)"\u5355\u4f4d\u7f16\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverProduct.getUnitName() == null || deliverProduct.getUnitName().length() < 128 ? 1 : 0) != 0, (String)"\u5355\u4f4d\u540d\u79f0,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((deliverProduct.getRemark() == null || deliverProduct.getRemark().length() < 255 ? 1 : 0) != 0, (String)"\u5907\u6ce8,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    public Set<DeliverProduct> findDetailsByDeliverGood(String deliverGood) {
        if (StringUtils.isBlank((CharSequence)deliverGood)) {
            return Sets.newHashSet();
        }
        return this.deliverProductRepository.findDetailsByDeliverGood(deliverGood);
    }

    @Override
    public DeliverProduct findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.deliverProductRepository.findDetailsById(id);
    }

    @Override
    public DeliverProduct findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.deliverProductRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        DeliverProduct current = this.findById(id);
        if (current != null) {
            this.deliverProductRepository.delete((Object)current);
        }
    }

    @Override
    @Transactional
    public void batchSave(List<DeliverProduct> products) {
        Validate.notEmpty(products, (String)"\u6279\u91cf\u4fdd\u5b58\u53d1\u8d27\u5546\u54c1\u65f6,\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (DeliverProduct product : products) {
            this.create(product);
        }
    }
}

