/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.controller;

import com.bizunited.empower.business.order.entity.OrderInfo;
import com.bizunited.empower.business.order.service.OrderInfoService;
import com.bizunited.empower.business.order.service.strategy.OrderStrategyEvent;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/orderInfo"})
public class OrderInfoController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrderInfoController.class);
    @Autowired
    private OrderInfoService orderInfoService;

    @ApiOperation(value="\u7531\u4e8e\u8ba2\u5355\u4f7f\u7528\u521b\u5efa/\u4fee\u6539\u6388\u6743\u6807\u7b7e\u6765\u907f\u514d\u91cd\u590d\u63d0\u4ea4\u7684\u95ee\u9898\u3002\u6240\u4ee5\u5728\u521b\u5efa\u8ba2\u5355\u524d\uff0c\u9700\u8981\u4f7f\u7528\u8be5\u65b9\u6cd5\u83b7\u5f97\u9884\u6388\u6743\u3002\u9884\u6388\u6743\u6210\u529f\u540e\uff0c\u624d\u80fd\u901a\u8fc7\u9884\u6388\u6743\u4fe1\u606f\u8fdb\u884c\u6dfb\u52a0")
    @PostMapping(value={"/preModify"})
    public ResponseModel preModify() {
        try {
            String prefix = this.orderInfoService.preModify();
            return this.buildHttpResultW(prefix, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u76f8\u5173\u7684\u521b\u5efa\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u8bf7\u6ce8\u610f\u8be5\u521b\u5efa\u8fc7\u7a0b\u9664\u4e86\u53ef\u4ee5\u521b\u5efaorderInfo\u4e2d\u7684\u57fa\u672c\u4fe1\u606f\u4ee5\u5916\uff0c\u8fd8\u53ef\u4ee5\u5bf9orderInfo\u4e2d\u5c5e\u4e8eOneToMany\u5173\u8054\u7684\u660e\u7ec6\u4fe1\u606f\u4e00\u540c\u8fdb\u884c\u521b\u5efa\u6ce8\u610f\uff1a\u57fa\u4e8e\uff08OrderInfo\uff09\u6a21\u578b\u7684\u521b\u5efa\u64cd\u4f5c\u4f20\u5165\u7684orderInfoJSON\u5bf9\u8c61\uff0c\u5176\u4e3b\u952e\u4fe1\u606f\u4e0d\u80fd\u6709\u503c\uff0c\u670d\u52a1\u7aef\u5c06\u4f1a\u81ea\u52a8\u4e3a\u5176\u8d4b\u4e88\u76f8\u5173\u503c\u3002\u53e6\u5916\uff0c\u521b\u5efa\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u7cfb\u7edf\u5c06\u8fd4\u56de\u8be5\u5bf9\u8c61\u7684\u57fa\u672c\u4fe1\u606f\uff08\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f\uff09")
    @PostMapping(value={""})
    public ResponseModel create(@RequestBody @ApiParam(name="orderInfo", value="\u76f8\u5173\u7684\u521b\u5efa\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u8bf7\u6ce8\u610f\u8be5\u521b\u5efa\u8fc7\u7a0b\u9664\u4e86\u53ef\u4ee5\u521b\u5efaorderInfo\u4e2d\u7684\u57fa\u672c\u4fe1\u606f\u4ee5\u5916\uff0c\u8fd8\u53ef\u4ee5\u5bf9orderInfo\u4e2d\u5c5e\u4e8eOneToMany\u5173\u8054\u7684\u660e\u7ec6\u4fe1\u606f\u4e00\u540c\u8fdb\u884c\u521b\u5efa\u6ce8\u610f\uff1a\u57fa\u4e8e\uff08OrderInfo\uff09\u6a21\u578b\u7684\u521b\u5efa\u64cd\u4f5c\u4f20\u5165\u7684orderInfoJSON\u5bf9\u8c61\uff0c\u5176\u4e3b\u952e\u4fe1\u606f\u4e0d\u80fd\u6709\u503c\uff0c\u670d\u52a1\u7aef\u5c06\u4f1a\u81ea\u52a8\u4e3a\u5176\u8d4b\u4e88\u76f8\u5173\u503c\u3002\u53e6\u5916\uff0c\u521b\u5efa\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u7cfb\u7edf\u5c06\u8fd4\u56de\u8be5\u5bf9\u8c61\u7684\u57fa\u672c\u4fe1\u606f\uff08\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f\uff09") OrderInfo orderInfo) {
        try {
            OrderInfo current = this.orderInfoService.create(orderInfo);
            return this.buildHttpResultW((Object)current, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u76f8\u5173\u7684\u66f4\u65b0\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u8bf7\u6ce8\u610f\u8be5\u66f4\u65b0\u8fc7\u7a0b\u53ea\u4f1a\u66f4\u65b0\u5728\u6a21\u578b\u5c42\u88ab\u6807\u8bb0\u4e3a\u4e86updateable\u7684\u5c5e\u6027\uff0c\u5305\u62ec\u4e00\u822c\u5c5e\u6027\u3001ManyToOne\u548cOneToOne\u6027\u8d28\u7684\u5173\u8054\u5c5e\u6027\uff0c\u800cManyToMany\u3001OneToMany\u7684\u5173\u8054\u5c5e\u6027\uff0c\u867d\u7136\u4e5f\u4f1a\u4f20\u5165\uff0c\u4f46\u9700\u8981\u5f00\u53d1\u4eba\u5458\u81ea\u884c\u5728Service\u5c42\u5b8c\u5584\u5176\u66f4\u65b0\u8fc7\u7a0b\u6ce8\u610f\uff1a\u57fa\u4e8e\u6a21\u578b\uff08OrderInfo\uff09\u7684\u4fee\u6539\u64cd\u4f5c\u4f20\u5165\u7684orderInfoJSON\u5bf9\u8c61\uff0c\u5176\u4e3b\u952e\u4fe1\u606f\u5fc5\u987b\u6709\u503c\uff0c\u670d\u52a1\u7aef\u5c06\u9a8c\u8bc1\u8fd9\u4e2a\u4e3b\u952e\u503c\u662f\u5426\u5df2\u7ecf\u5b58\u5728\u3002\u53e6\u5916\uff0c\u521b\u5efa\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u7cfb\u7edf\u5c06\u8fd4\u56de\u8be5\u5bf9\u8c61\u7684\u57fa\u672c\u4fe1\u606f\uff08\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f\uff09")
    @PatchMapping(value={""})
    public ResponseModel update(@RequestBody @ApiParam(name="orderInfo", value="\u76f8\u5173\u7684\u66f4\u65b0\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u8bf7\u6ce8\u610f\u8be5\u66f4\u65b0\u8fc7\u7a0b\u53ea\u4f1a\u66f4\u65b0\u5728\u6a21\u578b\u5c42\u88ab\u6807\u8bb0\u4e3a\u4e86updateable\u7684\u5c5e\u6027\uff0c\u5305\u62ec\u4e00\u822c\u5c5e\u6027\u3001ManyToOne\u548cOneToOne\u6027\u8d28\u7684\u5173\u8054\u5c5e\u6027\uff0c\u800cManyToMany\u3001OneToMany\u7684\u5173\u8054\u5c5e\u6027\uff0c\u867d\u7136\u4e5f\u4f1a\u4f20\u5165\uff0c\u4f46\u9700\u8981\u5f00\u53d1\u4eba\u5458\u81ea\u884c\u5728Service\u5c42\u5b8c\u5584\u5176\u66f4\u65b0\u8fc7\u7a0b\u6ce8\u610f\uff1a\u57fa\u4e8e\u6a21\u578b\uff08OrderInfo\uff09\u7684\u4fee\u6539\u64cd\u4f5c\u4f20\u5165\u7684orderInfoJSON\u5bf9\u8c61\uff0c\u5176\u4e3b\u952e\u4fe1\u606f\u5fc5\u987b\u6709\u503c\uff0c\u670d\u52a1\u7aef\u5c06\u9a8c\u8bc1\u8fd9\u4e2a\u4e3b\u952e\u503c\u662f\u5426\u5df2\u7ecf\u5b58\u5728\u3002\u53e6\u5916\uff0c\u521b\u5efa\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u7cfb\u7edf\u5c06\u8fd4\u56de\u8be5\u5bf9\u8c61\u7684\u57fa\u672c\u4fe1\u606f\uff08\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f\uff09") OrderInfo orderInfo) {
        try {
            OrderInfo current = this.orderInfoService.update(orderInfo);
            return this.buildHttpResultW((Object)current, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u8ba2\u5355\u53d6\u6d88\uff1a\u8ba2\u5355\u72b6\u6001\u5904\u4e8e'\u5f85\u51fa\u5e93'\u6216\u4e4b\u524d\u72b6\u6001\uff0c\u90fd\u80fd\u53d6\u6d88\u8ba2\u5355\uff0c\u4e0d\u7ba1\u662f\u5426\u6709\u4ed8\u6b3e")
    @PostMapping(value={"/cancel"})
    public ResponseModel cancel(@ApiParam(name="orderCode", value="\u8ba2\u5355\u7f16\u7801") String orderCode) {
        try {
            this.orderInfoService.cancel(orderCode);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5c06\u6307\u5b9a\u8ba2\u5355\uff08\u8ba2\u5355\u4e1a\u52a1\u7f16\u53f7\uff09\uff0c\u5207\u6362\u5230\u6307\u5b9a\u7684\u8ba2\u5355\u72b6\u6001\uff0c\u5e76\u6309\u7167\u5404\u7b56\u7565\u63cf\u8ff0\u7684\u81ea\u52a8\u5207\u6362\u6807\u51c6\uff08\u8be6\u89c1OrderRoamStrategy.automaticValidate(orderInfo)\uff09,\u8ba9\u8ba2\u5355\u72b6\u6001\u5c3d\u53ef\u80fd\u81ea\u52a8\u7684\u5411\u540e\u6d41\u8f6c")
    @PostMapping(value={"/nextOrderStatus"})
    public ResponseModel nextOrderStatus(@RequestParam(value="orderCode") @ApiParam(value="\u6307\u5b9a\u8ba2\u5355\uff08\u8ba2\u5355\u4e1a\u52a1\u7f16\u53f7\uff09") String orderCode, @RequestParam(value="orderStatus") @ApiParam(value="\u8ba2\u5355\u72b6\u6001\uff1a\u5f85\u4ed8\u6b3e1\u3001\u5f85\u5ba1\u68382\u3001\u5f85\u53d1\u8d273\u3001\u5f85\u9000\u5355\uff08\u53d6\u6d88\uff09\u5ba1\u68384\u3001\u5df2\u9000\u5355\uff08\u53d6\u6d88\uff095\u3001\u5df2\u5b8c\u62106") Integer orderStatus) {
        try {
            OrderInfo current = this.orderInfoService.nextOrderStatus(orderCode, OrderStrategyEvent.getByEventValue(orderStatus));
            return this.buildHttpResultW((Object)current, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u76f8\u5173\u7684\u67e5\u8be2\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u901a\u8fc7\u4e3b\u952e\u8fdb\u884c\u6570\u636e\u7684\u67e5\u8be2")
    @GetMapping(value={"/{id}"})
    public ResponseModel findById(@PathVariable(value="id") @ApiParam(name="id", value="\u4e3b\u952e") String id) {
        try {
            OrderInfo current = this.orderInfoService.findById(id);
            return this.buildHttpResultW((Object)current, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

