/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.controller;

import com.bizunited.empower.business.order.dto.OrderInfoConditionDto;
import com.bizunited.empower.business.order.service.OrderInfoVoService;
import com.bizunited.empower.business.order.vo.OrderInfoVo;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/orderInfo"})
public class OrderInfoVoController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrderInfoVoController.class);
    @Autowired
    private OrderInfoVoService orderInfoVoService;

    @ApiOperation(value="\u6309\u7167\u8ba2\u5355\u67e5\u8be2\u6761\u4ef6\u8fdb\u884c\u8ba2\u5355\u7684\u5206\u9875\u67e5\u8be2")
    @RequestMapping(value={"/findByConditions"}, method={RequestMethod.GET})
    public ResponseModel findByConditions(@ApiParam(name="orderInfo", value="") OrderInfoConditionDto orderInfo, @PageableDefault(value=50) Pageable pageable) {
        try {
            Page<OrderInfoVo> result = this.orderInfoVoService.findByConditions(pageable, orderInfo);
            return this.buildHttpResultW(result, new String[]{"orderAuditSetting"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u8ba2\u5355\u4e1a\u52a1\u7f16\u53f7\u8fdb\u884c\u8be6\u60c5\u67e5\u8be2\uff08\u5305\u62ec\u5173\u8054\u4fe1\u606f\uff09")
    @RequestMapping(value={"/findDetailsByOrderCode"}, method={RequestMethod.GET})
    public ResponseModel findDetailsByOrderCode(@RequestParam(value="orderCode") @ApiParam(value="\u8ba2\u5355\u4e1a\u52a1\u7f16\u53f7") String orderCode) {
        try {
            OrderInfoVo result = this.orderInfoVoService.findDetailsByOrderCode(orderCode);
            return this.buildHttpResultW(result, new String[]{"orderProducts", "orderFiles", "logisticsInfo", "orderStatusLoggers", "orderAuditLogs", "orderAuditSetting"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

