/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.controller;

import com.bizunited.empower.business.order.entity.OrderProduct;
import com.bizunited.empower.business.order.service.OrderProductService;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/orderProduct"})
public class OrderProductController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrderProductController.class);
    @Autowired
    private OrderProductService orderProductService;

    @ApiOperation(value="\u76f8\u5173\u7684\u67e5\u8be2\u8fc7\u7a0b\uff0chttp\u63a5\u53e3\u3002\u901a\u8fc7\u4e3b\u952e\u8fdb\u884c\u6570\u636e\u7684\u67e5\u8be2")
    @GetMapping(value={"/{id}"})
    public ResponseModel findById(@PathVariable(value="id") @ApiParam(name="id", value="\u4e3b\u952e") String id) {
        try {
            OrderProduct current = this.orderProductService.findById(id);
            return this.buildHttpResultW((Object)current, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167OrderProduct\u5b9e\u4f53\u4e2d\u7684\uff08orderInfo\uff09\u5173\u8054\u7684 \u8ba2\u5355\u7f16\u53f7\u8fdb\u884c\u67e5\u8be2\u660e\u7ec6\u67e5\u8be2\uff0c\u67e5\u8be2\u7684\u660e\u7ec6\u5305\u62ec\u5f53\u524d\u4e1a\u52a1\u8868\u5355\u6240\u6709\u7684\u5173\u8054\u5c5e\u6027\u3002")
    @RequestMapping(value={"/findDetailsByOrderInfo"}, method={RequestMethod.GET})
    public ResponseModel findDetailsByOrderInfo(@RequestParam(value="orderInfo") @ApiParam(value="\u5173\u8054\u7684 \u8ba2\u5355\u7f16\u53f7") String orderInfo) {
        try {
            Set<OrderProduct> result = this.orderProductService.findDetailsByOrderInfo(orderInfo);
            return this.buildHttpResultW(result, new String[]{"orderInfo"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167OrderProduct\u5b9e\u4f53\u4e2d\u7684\uff08id\uff09\u4e3b\u952e\u8fdb\u884c\u67e5\u8be2\u660e\u7ec6\u67e5\u8be2\uff0c\u67e5\u8be2\u7684\u660e\u7ec6\u5305\u62ec\u5f53\u524d\u4e1a\u52a1\u8868\u5355\u6240\u6709\u7684\u5173\u8054\u5c5e\u6027\u3002")
    @RequestMapping(value={"/findDetailsById"}, method={RequestMethod.GET})
    public ResponseModel findDetailsById(@RequestParam(value="id") @ApiParam(value="\u4e3b\u952e") String id) {
        try {
            OrderProduct result = this.orderProductService.findDetailsById(id);
            return this.buildHttpResultW((Object)result, new String[]{"orderInfo"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

