/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.controller;

import com.bizunited.empower.business.order.dto.ReturnInfoDto;
import com.bizunited.empower.business.order.service.ReturnInfoVoService;
import com.bizunited.empower.business.order.vo.ReturnInfoVo;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/returnInfo"})
public class ReturnInfoVoController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReturnInfoVoController.class);
    @Autowired
    private ReturnInfoVoService returnInfoVoService;

    @ApiOperation(value="\u6309\u7167\u9000\u8d27\u5355\u67e5\u8be2\u6761\u4ef6\u8fdb\u884c\u9000\u8d27\u5355\u7684\u5206\u9875\u67e5\u8be2")
    @RequestMapping(value={"/findByConditions"}, method={RequestMethod.GET})
    public ResponseModel findByConditions(@ApiParam(name="returnInfo", value="") ReturnInfoDto returnInfo, @PageableDefault(value=50) Pageable pageable) {
        try {
            Page<ReturnInfoVo> result = this.returnInfoVoService.findByConditions(pageable, returnInfo);
            return this.buildHttpResultW(result, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167ReturnInfo\u5b9e\u4f53\u4e2d\u7684\uff08id\uff09\u4e3b\u952e\u8fdb\u884c\u67e5\u8be2\u660e\u7ec6\u67e5\u8be2\uff0c\u67e5\u8be2\u7684\u660e\u7ec6\u5305\u62ec\u5f53\u524d\u4e1a\u52a1\u8868\u5355\u6240\u6709\u7684\u5173\u8054\u5c5e\u6027\u3002")
    @RequestMapping(value={"/findDetailsById"}, method={RequestMethod.GET})
    public ResponseModel findDetailsById(@RequestParam(value="id") @ApiParam(value="\u4e3b\u952e") String id) {
        try {
            ReturnInfoVo result = this.returnInfoVoService.findDetailsById(id);
            return this.buildHttpResultW((Object)result, new String[]{"orderInfo", "returnProducts", "returnFiles", "returnStatusLoggers", "returnAuditLogs"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u9000\u8d27\u5355\u4e1a\u52a1\u7f16\u53f7\u8fdb\u884c\u8be6\u60c5\u67e5\u8be2\uff08\u5305\u62ec\u5173\u8054\u4fe1\u606f\uff09")
    @RequestMapping(value={"/findDetailsByReturnCode"}, method={RequestMethod.GET})
    public ResponseModel findDetailsByReturnCode(@RequestParam(value="returnCode") @ApiParam(value="\u9000\u8d27\u5355\u4e1a\u52a1\u7f16\u53f7") String returnCode) {
        try {
            ReturnInfoVo result = this.returnInfoVoService.findDetailsByReturnCode(returnCode);
            return this.buildHttpResultW((Object)result, new String[]{"orderInfo", "returnProducts", "returnFiles", "returnStatusLoggers", "returnAuditLogs"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

