/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.repository;

import com.bizunited.empower.business.order.entity.OrderInfo;
import com.bizunited.empower.business.order.repository.internal.OrderInfoRepositoryCustom;
import java.math.BigDecimal;
import java.util.Date;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository(value="_OrderInfoRepository")
public interface OrderInfoRepository
extends JpaRepository<OrderInfo, String>,
JpaSpecificationExecutor<OrderInfo>,
OrderInfoRepositoryCustom {
    @Query(value="select distinct orderInfo from OrderInfo orderInfo  left join fetch orderInfo.logisticsInfo orderInfo_logisticsInfo  left join fetch orderInfo.orderProducts op  left join fetch orderInfo.orderFiles ofs  left join fetch orderInfo.orderStatusLoggers osl  where orderInfo.id = :id order by osl.loggerTime desc , op.id  ")
    public OrderInfo findDetailsById(@Param(value="id") String var1);

    @Query(value="select distinct orderInfo from OrderInfo orderInfo  left join fetch orderInfo.logisticsInfo orderInfo_logisticsInfo  left join fetch orderInfo.orderProducts op  left join fetch orderInfo.orderFiles ofs  left join fetch orderInfo.orderStatusLoggers osl  where orderInfo.orderCode = :orderCode AND orderInfo.tenantCode =:tenantCode order by osl.loggerTime desc , op.id ")
    public OrderInfo findDetailsByOrderCodeAndTenantCode(@Param(value="orderCode") String var1, @Param(value="tenantCode") String var2);

    public OrderInfo findByOrderTypeAndRelevanceCodeAndTenantCode(Integer var1, String var2, String var3);

    public OrderInfo findByOrderCodeAndTenantCode(String var1, String var2);

    @Query(value="select count(*) from OrderInfo o where o.tenantCode = :tenantCode and o.createTime >= :start and o.createTime <= :end and o.orderType = :orderType and o.createAccount = :createAccount and o.orderStatus <> 5")
    public long countByTenantCodeAndOrderTypeAndCreateTimeBetween(@Param(value="tenantCode") String var1, @Param(value="orderType") Integer var2, @Param(value="createAccount") String var3, @Param(value="start") Date var4, @Param(value="end") Date var5);

    @Query(value="select count(*) from OrderInfo o where o.tenantCode = :tenantCode and o.createTime >= :start and o.createTime <= :end and o.orderStatus <> 5")
    public long countByTenantCodeAndCreateTimeBetween(@Param(value="tenantCode") String var1, @Param(value="start") Date var2, @Param(value="end") Date var3);

    @Query(value="select sum(o.orderTotalPrice) from OrderInfo o where o.tenantCode = :tenantCode and o.createTime >= :start and o.createTime <= :end and o.orderType = :orderType and o.createAccount = :createAccount and o.orderStatus <> 5")
    public BigDecimal sumOrderTotalPriceByTenantCodeAndOrderTypeAndCreateTimeBetween(@Param(value="tenantCode") String var1, @Param(value="orderType") Integer var2, @Param(value="createAccount") String var3, @Param(value="start") Date var4, @Param(value="end") Date var5);

    @Query(value="select sum(o.orderTotalPrice) from OrderInfo o where o.tenantCode = :tenantCode and o.createTime >= :start and o.createTime <= :end and o.orderStatus <> 5")
    public BigDecimal sumOrderTotalPriceByTenantCodeAndCreateTimeBetween(@Param(value="tenantCode") String var1, @Param(value="start") Date var2, @Param(value="end") Date var3);

    @Query(value="select count(distinct o.customerCode) from OrderInfo o where o.tenantCode = :tenantCode and o.createTime >= :start and o.createTime <= :end and o.orderStatus <> 5")
    public long countCustomerByTenantCodeAndCreateTimeBetween(@Param(value="tenantCode") String var1, @Param(value="start") Date var2, @Param(value="end") Date var3);

    @Query(value="select count(*) from OrderInfo o where o.tenantCode = :tenantCode and o.orderStatus = :orderStatus and o.createTime >= :start and o.createTime <= :end and o.orderStatus <> 5")
    public long countByTenantCodeAndOrderStatusAndCreateTimeBetween(@Param(value="tenantCode") String var1, @Param(value="orderStatus") Integer var2, @Param(value="start") Date var3, @Param(value="end") Date var4);

    @Query(value="select count(*) from OrderInfo o where o.tenantCode = :tenantCode and o.orderStatus = :orderStatus ")
    public long countByTenantCodeAndOrderStatus(@Param(value="tenantCode") String var1, @Param(value="orderStatus") Integer var2);

    @Query(value="select count(*) from OrderInfo o where o.tenantCode = :tenantCode and o.deliveryStatus = :deliveryStatus and o.orderStatus <> 5")
    public long countByTenantCodeAndDeliveryStatus(@Param(value="tenantCode") String var1, @Param(value="deliveryStatus") Integer var2);

    @Query(value="select count(*) from OrderInfo o where o.tenantCode = :tenantCode and o.receivableStatus <> 3 and o.orderStatus <> 5 ")
    public long countReceivableUndoneByTenantCode(@Param(value="tenantCode") String var1);

    @Query(value="select count(*) from OrderInfo o where o.tenantCode = :tenantCode and o.orderStatus <> 5 ")
    public long countEffectiveOrderByTenantCode(@Param(value="tenantCode") String var1);

    @Query(value="select count(*) from OrderInfo o where o.tenantCode = :tenantCode and o.receivableStatus = :receivableStatus and o.orderStatus <> 5 ")
    public long countByTenantCodeAndReceivableStatus(@Param(value="tenantCode") String var1, @Param(value="receivableStatus") Integer var2);

    @Modifying
    @Query(value="update OrderInfo e set e.returnAllCompleted = true where e.id = :orderId")
    public void updateReturnAllCompleted(@Param(value="orderId") String var1);
}

