/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.repository;

import com.bizunited.empower.business.order.entity.OrderProduct;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository(value="_OrderProductRepository")
public interface OrderProductRepository
extends JpaRepository<OrderProduct, String>,
JpaSpecificationExecutor<OrderProduct> {
    @Query(value="select distinct orderProduct from OrderProduct orderProduct  left join fetch orderProduct.orderInfo orderProduct_orderInfo  where orderProduct_orderInfo.id = :orderInfoId")
    public Set<OrderProduct> findDetailsByOrderInfo(@Param(value="orderInfoId") String var1);

    @Query(value="select distinct orderProduct from OrderProduct orderProduct  left join fetch orderProduct.orderInfo orderProduct_orderInfo  where orderProduct.id=:id ")
    public OrderProduct findDetailsById(@Param(value="id") String var1);

    @Modifying
    @Query(value="delete from order_product where id in (:ids)", nativeQuery=true)
    public void deleteByIds(@Param(value="ids") String[] var1);

    @Query(value="select count(e.id) from OrderProduct e where e.productSpecificationCode = :specificationCode and e.tenantCode = :tenantCode")
    public long countByTenantCodeAndSpecificationCode(@Param(value="tenantCode") String var1, @Param(value="specificationCode") String var2);

    @Query(value="select count(e.id) from OrderProduct e where e.productSpecificationCode in (:specificationCodes) and e.tenantCode = :tenantCode")
    public long countByTenantCodeAndSpecificationCodes(@Param(value="tenantCode") String var1, @Param(value="specificationCodes") Set<String> var2);

    @Query(value="select count(e.id) from OrderProduct e where e.productSpecificationCode = :specificationCode and e.productSpecificationName = :specificationName and e.tenantCode = :tenantCode")
    public long countByTenantCodeAndSpecificationCodeAndSpecificationName(@Param(value="tenantCode") String var1, @Param(value="specificationCode") String var2, @Param(value="specificationName") String var3);

    @Query(value="select count(e.id) from OrderProduct e where e.unitCode = :unitCode and e.tenantCode = :tenantCode")
    public long existByUnitCodeAndTenantCode(@Param(value="unitCode") String var1, @Param(value="tenantCode") String var2);

    @Query(value="select count(e.id) from OrderProduct e where e.unitCode in (:unitCodes) and e.tenantCode = :tenantCode")
    public long existByUnitCodesAndTenantCode(@Param(value="unitCodes") Set<String> var1, @Param(value="tenantCode") String var2);

    @Query(value="select count(e.id) from OrderProduct e where e.unitCode = :unitCode and e.unitName = :unitName and e.tenantCode = :tenantCode")
    public long existByUnitCodeAndUnitNameAndTenantCode(@Param(value="unitCode") String var1, @Param(value="unitName") String var2, @Param(value="tenantCode") String var3);
}

