/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.repository;

import com.bizunited.empower.business.order.entity.ReturnInfo;
import com.bizunited.empower.business.order.repository.internal.ReturnInfoRepositoryCustom;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository(value="_ReturnInfoRepository")
public interface ReturnInfoRepository
extends JpaRepository<ReturnInfo, String>,
JpaSpecificationExecutor<ReturnInfo>,
ReturnInfoRepositoryCustom {
    @Query(value="from ReturnInfo returnInfo  left join fetch returnInfo.returnProducts op  left join fetch returnInfo.returnFiles ofs  left join fetch returnInfo.returnStatusLoggers rsl  left join fetch returnInfo.orderInfo oi  left join fetch returnInfo.returnAuditLogs logs  where returnInfo.id = :id order by rsl.loggerTime desc")
    public ReturnInfo findDetailsById(@Param(value="id") String var1);

    @Query(value="from ReturnInfo returnInfo  left join fetch returnInfo.returnProducts op  left join fetch returnInfo.returnFiles ofs  left join fetch returnInfo.returnStatusLoggers rsl  left join fetch returnInfo.orderInfo oi  left join fetch returnInfo.returnAuditLogs logs  where returnInfo.returnCode = :returnCode and returnInfo.tenantCode = :tenantCode order by rsl.loggerTime desc")
    public ReturnInfo findDetailsByReturnCodeAndTenantCode(@Param(value="returnCode") String var1, @Param(value="tenantCode") String var2);

    @Query(value="from ReturnInfo r where r.orderInfo.id = :orderId")
    public Set<ReturnInfo> findByOrderId(@Param(value="orderId") String var1);

    public ReturnInfo findByReturnCodeAndTenantCode(String var1, String var2);

    @Query(value="select count(*) from ReturnInfo r where r.tenantCode = :tenantCode and r.returnStatus = :returnStatus")
    public long countByTenantCodeAndReturnStatus(@Param(value="tenantCode") String var1, @Param(value="returnStatus") Integer var2);

    @Query(value="from ReturnInfo e left join fetch e.returnProducts products where e.orderInfo.id = :orderId")
    public Set<ReturnInfo> findDetailsByOrderId(@Param(value="orderId") String var1);
}

