/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.repository.internal;

import com.bizunited.empower.business.order.dto.OrderInfoConditionDto;
import com.bizunited.empower.business.order.repository.internal.OrderInfoRepositoryCustom;
import com.bizunited.platform.common.repository.PageRepositoryImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.CollectionUtils;

public class OrderInfoRepositoryImpl
implements OrderInfoRepositoryCustom,
PageRepositoryImpl {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;
    private static final String QUERY_FIELDS = "t.id,t.order_code,c.customer_name,c.customer_code,t.order_status , t.order_source, t.delivery_status , l.delivery_method , l.delivery_date , t.receivable_status , t.create_account , t.sale_account , t.sale_name , t.create_time , t.modify_account , t.modify_time , t.remark , t.tenant_code , t.order_total_price , c.relevance_user_account , t.order_type , t.relevance_code , c.phone ,t.products_number , t.gifts_number , t.product_total_price , t.order_fare_price , t.order_special_price , t.order_discount_price , t.order_discount_pool_price , t.order_point_price , t.pay_type , setting.id settingId , setting.audit_node_settings , setting.audit_version settingAuditVersion ";

    @Override
    public Page<Object[]> findByCondition(Pageable pageable, OrderInfoConditionDto orderInfo) {
        StringBuilder sql = new StringBuilder("select t.id,t.order_code,c.customer_name,c.customer_code,t.order_status , t.order_source, t.delivery_status , l.delivery_method , l.delivery_date , t.receivable_status , t.create_account , t.sale_account , t.sale_name , t.create_time , t.modify_account , t.modify_time , t.remark , t.tenant_code , t.order_total_price , c.relevance_user_account , t.order_type , t.relevance_code , c.phone ,t.products_number , t.gifts_number , t.product_total_price , t.order_fare_price , t.order_special_price , t.order_discount_price , t.order_discount_pool_price , t.order_point_price , t.pay_type , setting.id settingId , setting.audit_node_settings , setting.audit_version settingAuditVersion  from order_info t left join customer c on t.customer_code = c.customer_code left join order_logistics_info l on t.id = l.order_id left join order_audit_setting setting on setting.order_id = t.id where 1=1 ");
        StringBuilder countSql = new StringBuilder("select count(*) from order_info t left join customer c on t.customer_code = c.customer_code where 1=1 ");
        StringBuilder condition = new StringBuilder();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        this.buildConditionsAndParameter(orderInfo, condition, parameters);
        sql.append((CharSequence)condition).append(" order by t.create_time desc ");
        countSql.append((CharSequence)condition);
        Query query = this.entityManager.createNativeQuery(sql.toString());
        Query countQuery = this.entityManager.createNativeQuery(countSql.toString());
        parameters.forEach((k, v) -> {
            query.setParameter(k, v);
            countQuery.setParameter(k, v);
        });
        query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
        query.setMaxResults(pageable.getPageSize());
        List resutls = query.getResultList();
        Number count = (Number)countQuery.getResultList().get(0);
        return new PageImpl(resutls, pageable, count == null ? 0L : count.longValue());
    }

    private void buildConditionsAndParameter(OrderInfoConditionDto orderInfo, StringBuilder condition, Map<String, Object> parameter) {
        if (orderInfo == null) {
            return;
        }
        if (orderInfo.getTenantCode() != null) {
            condition.append(" AND t.tenant_code = :tenantCode AND c.tenant_code = :tenantCode ");
            parameter.put("tenantCode", orderInfo.getTenantCode());
        }
        if (orderInfo.getOrderStatus() != null) {
            condition.append(" AND t.order_status = :orderStatus ");
            parameter.put("orderStatus", orderInfo.getOrderStatus());
        }
        if (StringUtils.isNotEmpty((CharSequence)orderInfo.getCustomerCode())) {
            condition.append(" AND c.customer_code = :customerCode ");
            parameter.put("customerCode", orderInfo.getCustomerCode());
        }
        if (!CollectionUtils.isEmpty(orderInfo.getCustomerCodes())) {
            condition.append(" AND c.customer_code in (:customerCodes)");
            parameter.put("customerCodes", orderInfo.getCustomerCodes());
        }
        if (orderInfo.getReceivableStatus() != null) {
            condition.append(" AND t.receivable_status = :receivableStatus ");
            parameter.put("receivableStatus", orderInfo.getReceivableStatus());
        }
        if (!CollectionUtils.isEmpty(orderInfo.getDeliveryStatus())) {
            condition.append(" AND t.delivery_status in (:deliveryStatus) ");
            parameter.put("deliveryStatus", orderInfo.getDeliveryStatus());
        }
        if (orderInfo.getCreateTimeStart() != null) {
            condition.append(" AND t.create_time >= :createTimeStart ");
            parameter.put("createTimeStart", orderInfo.getCreateTimeStart());
        }
        if (orderInfo.getCreateTimeEnd() != null) {
            condition.append(" AND t.create_time <= :createTimeEnd ");
            parameter.put("createTimeEnd", orderInfo.getCreateTimeEnd());
        }
        if (orderInfo.getOrderType() != null) {
            condition.append(" AND t.order_type = :orderType ");
            parameter.put("orderType", orderInfo.getOrderType());
        }
        if (!CollectionUtils.isEmpty(orderInfo.getOrderCodes())) {
            condition.append(" AND t.order_code in (:orderCodes) ");
            parameter.put("orderCodes", orderInfo.getOrderCodes());
        }
        if (StringUtils.isNotBlank((CharSequence)orderInfo.getOrderCode())) {
            condition.append(" AND t.order_code like CONCAT('%',:orderCode,'%') ");
            parameter.put("orderCode", orderInfo.getOrderCode());
        }
        if (StringUtils.isNotBlank((CharSequence)orderInfo.getCustomerName())) {
            condition.append(" AND c.customer_name like CONCAT('%',:customerName,'%') ");
            parameter.put("customerName", orderInfo.getCustomerName());
        }
        if (StringUtils.isNotBlank((CharSequence)orderInfo.getCreateAccount())) {
            condition.append(" AND t.create_account = :createAccount ");
            parameter.put("createAccount", orderInfo.getCreateAccount());
        }
        if (!CollectionUtils.isEmpty(orderInfo.getHasOrderStatus())) {
            condition.append(" AND t.order_status in (:hasOrderStatus) ");
            parameter.put("hasOrderStatus", orderInfo.getHasOrderStatus());
        }
        if (orderInfo.getReturnAllCompleted() != null) {
            condition.append(" AND t.return_all_completed is null ");
        }
    }
}

