/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.repository.internal;

import com.bizunited.empower.business.order.dto.ReturnInfoDto;
import com.bizunited.empower.business.order.repository.internal.ReturnInfoRepositoryCustom;
import com.bizunited.platform.common.repository.PageRepositoryImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class ReturnInfoRepositoryImpl
implements ReturnInfoRepositoryCustom,
PageRepositoryImpl {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;
    private static final String QUERY_FIELDS = "r.id, r.order_id , o.order_code , r.return_code , r.customer_code , c.customer_name , r.sale_man , u.user_account , r.return_total_price , r.return_status , r.return_source , r.create_time , r.create_account , r.modify_time , r.modify_account , r.return_time , r.remark , r.payment_status , r.tenant_code , c.relevance_user_account ";

    @Override
    public Page<Object[]> findByCondition(Pageable pageable, ReturnInfoDto returnInfo) {
        StringBuilder sql = new StringBuilder("select r.id, r.order_id , o.order_code , r.return_code , r.customer_code , c.customer_name , r.sale_man , u.user_account , r.return_total_price , r.return_status , r.return_source , r.create_time , r.create_account , r.modify_time , r.modify_account , r.return_time , r.remark , r.payment_status , r.tenant_code , c.relevance_user_account  from return_info r left join customer c on r.customer_code = c.customer_code left join engine_user u on r.sale_man = u.user_account left join order_info o on o.id = r.order_id where 1=1 ");
        StringBuilder countSql = new StringBuilder("select count(*) from return_info r left join customer c on r.customer_code = c.customer_code left join engine_user u on r.sale_man = u.user_account left join order_info o on o.id = r.order_id where 1=1 ");
        StringBuilder condition = new StringBuilder();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        this.buildConditionsAndParameter(returnInfo, condition, parameters);
        sql.append((CharSequence)condition).append(" order by r.create_time desc ");
        countSql.append((CharSequence)condition);
        Query query = this.entityManager.createNativeQuery(sql.toString());
        Query countQuery = this.entityManager.createNativeQuery(countSql.toString());
        parameters.forEach((k, v) -> {
            query.setParameter(k, v);
            countQuery.setParameter(k, v);
        });
        query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
        query.setMaxResults(pageable.getPageSize());
        List resutls = query.getResultList();
        Number count = (Number)countQuery.getResultList().get(0);
        return new PageImpl(resutls, pageable, count == null ? 0L : count.longValue());
    }

    private void buildConditionsAndParameter(ReturnInfoDto returnInfo, StringBuilder condition, Map<String, Object> parameter) {
        if (returnInfo == null) {
            return;
        }
        if (returnInfo.getCustomerCode() != null) {
            condition.append(" AND r.customer_code = :customerCode ");
            parameter.put("customerCode", returnInfo.getCustomerCode());
        }
        if (returnInfo.getTenantCode() != null) {
            condition.append(" AND r.tenant_code = :tenantCode AND ( o.tenant_code is null or o.tenant_code = :tenantCode) AND (c.tenant_code is null or c.tenant_code = :tenantCode) ");
            parameter.put("tenantCode", returnInfo.getTenantCode());
        }
        if (returnInfo.getReturnStatus() != null) {
            condition.append(" AND r.return_status = :returnStatus ");
            parameter.put("returnStatus", returnInfo.getReturnStatus());
        }
        if (returnInfo.getPaymentStatus() != null) {
            condition.append(" AND r.payment_status = :paymentStatus ");
            parameter.put("paymentStatus", returnInfo.getPaymentStatus());
        }
        if (returnInfo.getCreateTimeStart() != null) {
            condition.append(" AND r.create_time >= :createTimeStart ");
            parameter.put("createTimeStart", returnInfo.getCreateTimeStart());
        }
        if (returnInfo.getCreateTimeEnd() != null) {
            condition.append(" AND r.create_time <= :createTimeEnd ");
            parameter.put("createTimeEnd", returnInfo.getCreateTimeEnd());
        }
        if (StringUtils.isNotBlank((CharSequence)returnInfo.getReturnCode())) {
            condition.append(" AND r.return_code like CONCAT('%',:returnCode,'%') ");
            parameter.put("returnCode", returnInfo.getReturnCode());
        }
        if (StringUtils.isNotBlank((CharSequence)returnInfo.getCustomerName())) {
            condition.append(" AND c.customer_name like CONCAT('%',:customerName,'%') ");
            parameter.put("customerName", returnInfo.getCustomerName());
        }
    }
}

