/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.service.analysis;

import com.bizunited.empower.business.order.entity.OrderInfo;
import com.bizunited.empower.business.order.entity.OrderProduct;
import com.bizunited.empower.business.order.repository.OrderInfoRepository;
import com.bizunited.empower.business.warehouse.entity.WarehouseProductsExpense;
import com.bizunited.empower.business.warehouse.service.WarehouseProductsExpenseService;
import com.bizunited.empower.business.warehouse.service.WarehouseProductsExpenseVoService;
import com.bizunited.empower.business.warehouse.vo.WarehouseProductsExpenseProductVo;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class WarehouseExpenseAnalysis {
    @Autowired
    private OrderInfoRepository orderInfoRepository;
    @Autowired
    private WarehouseProductsExpenseVoService warehouseProductsExpenseVoService;
    @Autowired
    private WarehouseProductsExpenseService warehouseProductsExpenseService;

    public void analysisWarehouseProductsExpense(OrderInfo orderInfo, WarehouseProductsExpense warehouseProductsExpense, Map<String, BigDecimal> productSpecificationMapping, Map<String, BigDecimal> productOrderMapping) {
        String relevanceCode = (orderInfo = this.validatePrefix(orderInfo, warehouseProductsExpense)).getOrderCode();
        List preemptExpenses = this.warehouseProductsExpenseVoService.findPreemptQuantityByRelevanceCode(relevanceCode);
        if (!CollectionUtils.isEmpty((Collection)preemptExpenses)) {
            for (WarehouseProductsExpenseProductVo currentExpenseProductItem : preemptExpenses) {
                String productSpecificationCode = currentExpenseProductItem.getProductSpecificationCode();
                Validate.notBlank((CharSequence)productSpecificationCode, (String)"\u4ece\u51fa\u5e93\u5355\u67e5\u8be2\u5230\u5546\u54c1\u89c4\u683c\u7f16\u53f7\u4e3a\u7a7a\u7684\u51fa\u5e93\u660e\u7ec6\uff0c\u8bf7\u68c0\u67e5\u8ba2\u5355[%s]\u5bf9\u5e94\u7684\u51fa\u5e93\u5355", (Object[])new Object[]{relevanceCode});
                BigDecimal quantity = currentExpenseProductItem.getQuantity();
                if (productSpecificationMapping.get(productSpecificationCode) != null) {
                    productSpecificationMapping.put(productSpecificationCode, productSpecificationMapping.get(productSpecificationCode).add(quantity));
                } else {
                    productSpecificationMapping.put(productSpecificationCode, quantity);
                }
                String orderProductId = currentExpenseProductItem.getOrderProductId();
                Validate.notBlank((CharSequence)orderProductId, (String)"\u4ece\u51fa\u5e93\u5355\u67e5\u8be2\u5230\u5173\u8054\u8ba2\u5355\u660e\u7ec6\u7f16\u53f7\u4e3a\u7a7a\u7684\u51fa\u5e93\u660e\u7ec6\uff0c\u8bf7\u68c0\u67e5\u8ba2\u5355[%s]\u5bf9\u5e94\u7684\u51fa\u5e93\u5355", (Object[])new Object[]{relevanceCode});
                quantity = currentExpenseProductItem.getQuantity();
                if (productOrderMapping.get(orderProductId) != null) {
                    productOrderMapping.put(orderProductId, productOrderMapping.get(orderProductId).add(quantity));
                    continue;
                }
                productOrderMapping.put(orderProductId, quantity);
            }
        }
    }

    public OrderInfo analysisWarehouseProductsExpense(OrderInfo orderInfo, WarehouseProductsExpense warehouseProductsExpense, Map<String, BigDecimal> doneOroductOrderMapping) {
        orderInfo = this.validatePrefix(orderInfo, warehouseProductsExpense);
        if (doneOroductOrderMapping == null) {
            return orderInfo;
        }
        String relevanceCode = orderInfo.getOrderCode();
        List doneExpenses = this.warehouseProductsExpenseVoService.findCompletedQuantityByRelevanceCode(relevanceCode);
        if (!CollectionUtils.isEmpty((Collection)doneExpenses)) {
            for (WarehouseProductsExpenseProductVo doneExpenseItem : doneExpenses) {
                String orderProductId = doneExpenseItem.getOrderProductId();
                Validate.notBlank((CharSequence)orderProductId, (String)"\u4ece\u51fa\u5e93\u5355\u67e5\u8be2\u5230\u5173\u8054\u8ba2\u5355\u660e\u7ec6\u7f16\u53f7\u4e3a\u7a7a\u7684\u51fa\u5e93\u660e\u7ec6\uff0c\u8bf7\u68c0\u67e5\u8ba2\u5355[%s]\u5bf9\u5e94\u7684\u51fa\u5e93\u5355", (Object[])new Object[]{relevanceCode});
                BigDecimal quantity = doneExpenseItem.getQuantity();
                if (doneOroductOrderMapping.get(orderProductId) != null) {
                    doneOroductOrderMapping.put(orderProductId, doneOroductOrderMapping.get(orderProductId).add(quantity));
                    continue;
                }
                doneOroductOrderMapping.put(orderProductId, quantity);
            }
        }
        return orderInfo;
    }

    private OrderInfo validatePrefix(OrderInfo orderInfo, WarehouseProductsExpense warehouseProductsExpense) {
        Validate.isTrue((orderInfo != null || warehouseProductsExpense != null ? 1 : 0) != 0, (String)"\u4f20\u5165\u7684\u8ba2\u5355\u6216\u51fa\u5e93\u5355\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        String relevanceCode = null;
        if (orderInfo == null) {
            Validate.isTrue((warehouseProductsExpense.getType() == 1 ? 1 : 0) != 0, (String)"\u4f20\u5165\u7684\u51fa\u5e93\u5355\u7c7b\u578b\u4e0d\u5339\u914d", (Object[])new Object[0]);
            relevanceCode = warehouseProductsExpense.getRelevanceCode();
            Validate.notBlank((CharSequence)relevanceCode, (String)"\u5728\u5b8c\u6210\u51fa\u5e93\u5355\u4e1a\u52a1\u65f6\uff0c\u672a\u53d1\u73b0\u51fa\u5e93\u5355\u5bf9\u5e94\u7684\u8ba2\u5355\u4e1a\u52a1\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            orderInfo = this.orderInfoRepository.findByOrderCodeAndTenantCode(relevanceCode, tenantCode);
            Validate.notNull((Object)((Object)orderInfo), (String)"\u672a\u53d1\u73b0\u7f16\u53f7\u4e3a\u3010%s\u3011\u7684\u8ba2\u5355\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{relevanceCode});
        }
        if (warehouseProductsExpense == null) {
            String orderCode = orderInfo.getOrderCode();
            List warehouseProductsExpenses = this.warehouseProductsExpenseService.findByRelevanceCode(orderCode);
            Validate.notEmpty((Collection)warehouseProductsExpenses, (String)"\u4f20\u5165\u7684\u8ba2\u5355\u672a\u5173\u8054\u4efb\u4f55\u7684\u51fa\u5e93\u5355\u4fe1\u606f", (Object[])new Object[0]);
            warehouseProductsExpense = (WarehouseProductsExpense)warehouseProductsExpenses.get(0);
            Validate.isTrue((warehouseProductsExpense.getType() == 1 ? 1 : 0) != 0, (String)"\u4f20\u5165\u7684\u51fa\u5e93\u5355\u7c7b\u578b\u4e0d\u5339\u914d", (Object[])new Object[0]);
            relevanceCode = warehouseProductsExpense.getRelevanceCode();
            Validate.notBlank((CharSequence)relevanceCode, (String)"\u5728\u5b8c\u6210\u51fa\u5e93\u5355\u4e1a\u52a1\u65f6\uff0c\u672a\u53d1\u73b0\u51fa\u5e93\u5355\u5bf9\u5e94\u7684\u8ba2\u5355\u4e1a\u52a1\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        }
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)orderInfo.getOrderCode(), (CharSequence)warehouseProductsExpense.getRelevanceCode()), (String)"\u8ba2\u5355\u4e0e\u51fa\u5e93\u5355\u4e0d\u5339\u914d", (Object[])new Object[0]);
        return orderInfo;
    }

    public boolean validateAllDone(OrderInfo orderInfo, WarehouseProductsExpense warehouseProductsExpense) {
        HashMap doneOroductOrderMapping = Maps.newHashMap();
        orderInfo = this.analysisWarehouseProductsExpense(orderInfo, warehouseProductsExpense, doneOroductOrderMapping);
        boolean isDone = true;
        for (OrderProduct orderProductItem : orderInfo.getOrderProducts()) {
            BigDecimal doneExpenseTotalQuantity;
            String orderProductId = orderProductItem.getId();
            BigDecimal orderQuantity = orderProductItem.getOrderQuantity();
            BigDecimal bigDecimal = doneExpenseTotalQuantity = doneOroductOrderMapping.get(orderProductId) == null ? BigDecimal.valueOf(0L) : (BigDecimal)doneOroductOrderMapping.get(orderProductId);
            if (!(orderQuantity.floatValue() > doneExpenseTotalQuantity.floatValue())) continue;
            isDone = false;
            break;
        }
        return isDone;
    }

    public boolean validatePartialDone(OrderInfo orderInfo, WarehouseProductsExpense warehouseProductsExpense) {
        HashMap doneOroductOrderMapping = Maps.newHashMap();
        orderInfo = this.analysisWarehouseProductsExpense(orderInfo, warehouseProductsExpense, doneOroductOrderMapping);
        if (doneOroductOrderMapping.isEmpty()) {
            return false;
        }
        boolean isPartialDone = false;
        for (OrderProduct orderProductItem : orderInfo.getOrderProducts()) {
            BigDecimal doneExpenseTotalQuantity;
            String orderProductId = orderProductItem.getId();
            BigDecimal orderQuantity = orderProductItem.getOrderQuantity();
            BigDecimal bigDecimal = doneExpenseTotalQuantity = doneOroductOrderMapping.get(orderProductId) == null ? BigDecimal.valueOf(0L) : (BigDecimal)doneOroductOrderMapping.get(orderProductId);
            if (!(orderQuantity.floatValue() > doneExpenseTotalQuantity.floatValue())) continue;
            isPartialDone = true;
            break;
        }
        return isPartialDone;
    }
}

