/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.service.internal;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.empower.business.common.util.SecurityUtils;
import com.bizunited.empower.business.order.entity.OrderAuditLog;
import com.bizunited.empower.business.order.entity.OrderAuditSetting;
import com.bizunited.empower.business.order.entity.OrderInfo;
import com.bizunited.empower.business.order.enums.GoodsBeforePayStatus;
import com.bizunited.empower.business.order.enums.OrderAuditStatus;
import com.bizunited.empower.business.order.repository.OrderAuditLogRepository;
import com.bizunited.empower.business.order.repository.OrderAuditSettingRepository;
import com.bizunited.empower.business.order.service.OrderAuditLogService;
import com.bizunited.empower.business.order.service.OrderAuditSettingService;
import com.bizunited.empower.business.order.service.OrderInfoService;
import com.bizunited.empower.business.order.service.strategy.OrderStrategyEvent;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.bizunited.platform.rbac2.sdk.config.RbacCustomProperties;
import com.bizunited.platform.rbac2.sdk.service.RoleVoCacheService;
import com.bizunited.platform.rbac2.sdk.vo.RoleVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OrderAuditLogServiceImpl
implements OrderAuditLogService {
    @Autowired
    private OrderAuditLogRepository orderAuditLogRepository;
    @Autowired
    private OrderAuditSettingService orderAuditSettingService;
    @Autowired
    private OrderInfoService orderInfoService;
    @Autowired
    private RbacCustomProperties rbacCustomProperties;
    @Autowired
    private RoleVoCacheService roleVoCacheService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private OrderAuditSettingRepository orderAuditSettingRepository;

    @Override
    @Transactional
    public void create(OrderAuditLog auditLog) {
        List<OrderAuditLog> orderAuditLogs;
        this.validate(auditLog);
        OrderInfo orderInfo = this.orderInfoService.findById(auditLog.getOrderInfo().getId());
        Validate.notNull((Object)((Object)orderInfo), (String)"\u6307\u5b9a\u7684\u8ba2\u5355\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (Object[])new Object[0]);
        Validate.isTrue((boolean)OrderStrategyEvent.BeAudit.getEventTarget().equals(orderInfo.getOrderStatus()), (String)"\u5f53\u524d\u8ba2\u5355\u4e0d\u662f\u5f85\u5ba1\u6838\u72b6\u6001", (Object[])new Object[0]);
        OrderAuditSetting setting = this.orderAuditSettingService.findByOrderId(orderInfo.getId());
        Validate.notNull((Object)((Object)setting), (String)"\u8be5\u8ba2\u5355\u672a\u80fd\u83b7\u53d6\u5230\u8ba2\u5355\u5ba1\u6838\u914d\u7f6e\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((boolean)this.matchOperator(setting, auditLog), (String)"\u5f53\u524d\u64cd\u4f5c\u4eba\u65e0\u6b64\u6743\u9650", (Object[])new Object[0]);
        if (GoodsBeforePayStatus.BEFORE_PAY.getValue() == orderInfo.getPayType().intValue()) {
            Validate.isTrue((orderInfo.getReceivableStatus() == 3 ? 1 : 0) != 0, (String)"\u5f53\u524d\u8ba2\u5355\u662f\u3010\u5148\u4ed8\u6b3e\u3011\u914d\u7f6e\uff0c\u8bf7\u7ed3\u6e05\u6b3e\u9879\u518d\u64cd\u4f5c\u5ba1\u6838", (Object[])new Object[0]);
        }
        if (CollectionUtils.isEmpty(orderAuditLogs = this.findByOrderIdAndVersion(orderInfo.getId(), setting.getAuditVersion()))) {
            Validate.isTrue((!OrderAuditStatus.match(auditLog.getAuditStatus(), OrderAuditStatus.BACK) ? 1 : 0) != 0, (String)"\u7b2c\u4e00\u8282\u70b9\u5ba1\u6279\u4e0d\u80fd\u3010\u9000\u56de\u3011", (Object[])new Object[0]);
        } else {
            Validate.isTrue((!OrderAuditStatus.match(auditLog.getAuditStatus(), OrderAuditStatus.CANCEL) ? 1 : 0) != 0, (String)"\u5f53\u524d\u8282\u70b9\u5ba1\u6279\u4e0d\u80fd\u3010\u53d6\u6d88\u3011", (Object[])new Object[0]);
        }
        auditLog.setAuditVersion(setting.getAuditVersion());
        String account = SecurityUtils.getUserAccount();
        Date now = new Date();
        auditLog.setCreateAccount(account);
        auditLog.setCreateTime(now);
        auditLog.setModifyAccount(account);
        auditLog.setModifyTime(now);
        this.orderAuditLogRepository.saveAndFlush((Object)auditLog);
        if (OrderAuditStatus.match(auditLog.getAuditStatus(), OrderAuditStatus.BACK)) {
            Object[] versionValues = StringUtils.split((String)setting.getAuditVersion(), (String)".");
            Integer value = Integer.parseInt(versionValues[2]) + 1;
            versionValues[2] = value.toString();
            String newSmallVersion = StringUtils.join((Object[])versionValues, (String)".");
            setting.setAuditVersion(newSmallVersion);
            this.orderAuditSettingRepository.saveAndFlush((Object)setting);
            Collection copyLogCollection = this.nebulaToolkitService.copyCollectionByWhiteList(orderAuditLogs, OrderAuditLog.class, OrderAuditLog.class, HashSet.class, ArrayList.class, new String[]{"orderInfo"});
            if (copyLogCollection.size() >= 2) {
                LinkedList copyLogs = Lists.newLinkedList((Iterable)copyLogCollection);
                for (int index = 0; index < copyLogCollection.size() - 1; ++index) {
                    OrderAuditLog copyLog = (OrderAuditLog)((Object)copyLogs.get(index));
                    copyLog.setId(null);
                    copyLog.setAuditVersion(newSmallVersion);
                    this.orderAuditLogRepository.saveAndFlush((Object)copyLog);
                }
            }
            return;
        }
        if (CollectionUtils.isEmpty(orderAuditLogs) && OrderAuditStatus.match(auditLog.getAuditStatus(), OrderAuditStatus.CANCEL)) {
            this.orderInfoService.nextOrderStatusById(orderInfo.getId(), OrderStrategyEvent.BeCancel);
            return;
        }
        this.orderInfoService.nextOrderStatusById(orderInfo.getId(), OrderStrategyEvent.BeDelivered);
    }

    @Override
    public List<OrderAuditLog> findByOrderId(String orderId) {
        if (StringUtils.isBlank((CharSequence)orderId)) {
            return Lists.newArrayList();
        }
        OrderAuditSetting setting = this.orderAuditSettingService.findByOrderId(orderId);
        if (setting == null) {
            return Lists.newArrayList();
        }
        return this.orderAuditLogRepository.findByOrderId(orderId);
    }

    @Override
    public List<OrderAuditLog> findByOrderIdAndVersion(String orderId, String version) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{orderId, version})) {
            return Lists.newArrayList();
        }
        return this.orderAuditLogRepository.findByOrderIdAndVersion(orderId, version);
    }

    private void validate(OrderAuditLog auditLog) {
        Validate.notNull((Object)((Object)auditLog), (String)"\u8ba2\u5355\u5ba1\u6838\u65e5\u5fd7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((auditLog.getOrderInfo() != null && StringUtils.isNotBlank((CharSequence)auditLog.getOrderInfo().getId()) ? 1 : 0) != 0, (String)"\u8ba2\u5355\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditLog.getAuditStatus(), (String)"\u8ba2\u5355\u5ba1\u6838\u72b6\u6001\u5fc5\u987b\u6709\u503c", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditLog.getNode(), (String)"\u6240\u5c5e\u8282\u70b9\u5fc5\u987b\u6709\u503c", (Object[])new Object[0]);
        Validate.isTrue((boolean)OrderAuditStatus.match(auditLog.getAuditStatus()), (String)"\u8ba2\u5355\u5ba1\u6838\u72b6\u6001\u4e0d\u5339\u914d", (Object[])new Object[0]);
        if (OrderAuditStatus.match(auditLog.getAuditStatus(), OrderAuditStatus.BACK)) {
            Validate.notBlank((CharSequence)auditLog.getRejectReason(), (String)"\u9000\u56de\u65f6\uff0c\u62d2\u7edd\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }

    private boolean matchOperator(OrderAuditSetting setting, OrderAuditLog log) {
        if (setting == null || StringUtils.isBlank((CharSequence)setting.getAuditNodeSettings())) {
            return true;
        }
        JSONArray array = JSONArray.parseArray((String)setting.getAuditNodeSettings());
        if (array.isEmpty()) {
            return true;
        }
        JSONObject matchedNode = null;
        for (int index = 0; index < array.size(); ++index) {
            JSONObject json = array.getJSONObject(index);
            if (!StringUtils.equals((CharSequence)json.getString("node"), (CharSequence)log.getNode())) continue;
            matchedNode = json;
            break;
        }
        Validate.notNull(matchedNode, (String)"\u672a\u80fd\u5339\u914d\u5230\u5ba1\u6838\u8282\u70b9\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (Object[])new Object[0]);
        String account = SecurityUtils.getUserAccount();
        Set currentUserRoles = this.roleVoCacheService.findByTenantCodeAndUserAccount(TenantUtils.getTenantCode(), account);
        Set<String> roleCodes = currentUserRoles.stream().map(RoleVo::getRoleCode).collect(Collectors.toSet());
        boolean isAdmin = this.comfirmAdmin(roleCodes);
        JSONArray roles = matchedNode.getJSONArray("roleCodes");
        if (isAdmin || roles == null || roles.isEmpty()) {
            return true;
        }
        return !CollectionUtils.isEmpty((Collection)Sets.intersection(roleCodes, (Set)Sets.newHashSet((Iterable)Arrays.stream(roles.toArray(new Object[0])).collect(Collectors.toSet()))));
    }

    private boolean comfirmAdmin(Set<String> roleCodes) {
        boolean isAdmin = false;
        if (!CollectionUtils.isEmpty(roleCodes)) {
            Sets.SetView intersections = Sets.intersection((Set)Sets.newHashSet((Object[])this.rbacCustomProperties.getIgnoreMethodCheckRoles()), (Set)Sets.newHashSet(roleCodes));
            isAdmin = !CollectionUtils.isEmpty((Collection)intersections);
        }
        return isAdmin;
    }
}

