/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.service.internal;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.empower.business.common.util.SecurityUtils;
import com.bizunited.empower.business.order.entity.OrderAuditSetting;
import com.bizunited.empower.business.order.repository.OrderAuditSettingRepository;
import com.bizunited.empower.business.order.service.OrderAuditSettingService;
import java.util.Date;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderAuditSettingServiceImpl
implements OrderAuditSettingService {
    private static final String DEAULT_VERSION = "1.0.0";
    @Autowired
    private OrderAuditSettingRepository orderAuditSettingRepository;

    @Override
    @Transactional
    public void create(OrderAuditSetting setting) {
        this.validate(setting);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)setting.getId()), (String)"\u5ba1\u6838\u914d\u7f6e\u4fe1\u606f\u65b0\u589e\u65f6\uff0cid\u5c5e\u6027\u4e0d\u80fd\u6709\u503c", (Object[])new Object[0]);
        Date now = new Date();
        String account = SecurityUtils.getUserAccount();
        setting.setCreateTime(now);
        setting.setModifyTime(now);
        setting.setCreateAccount(account);
        setting.setModifyAccount(account);
        if (StringUtils.isBlank((CharSequence)setting.getAuditVersion())) {
            setting.setAuditVersion(DEAULT_VERSION);
        }
        this.orderAuditSettingRepository.saveAndFlush((Object)setting);
    }

    @Override
    @Transactional
    public void update(OrderAuditSetting setting) {
        this.validate(setting);
        Validate.notBlank((CharSequence)setting.getId(), (String)"\u5ba1\u6838\u914d\u7f6e\u4fe1\u606f\u53d8\u66f4\u65f6\uff0cid\u5c5e\u6027\u5fc5\u987b\u6709\u503c", (Object[])new Object[0]);
        OrderAuditSetting dbSetting = this.orderAuditSettingRepository.findById(setting.getId()).orElse(null);
        Validate.notNull((Object)((Object)dbSetting), (String)"\u6839\u636e\u4f20\u5165\u7684\u8ba2\u5355\u5ba1\u6838\u914d\u7f6e\u4fe1\u606f\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u4fe1\u606f", (Object[])new Object[0]);
        Date now = new Date();
        dbSetting.setModifyTime(now);
        dbSetting.setModifyAccount(SecurityUtils.getUserAccount());
        dbSetting.setAuditVersion(this.generateAuditVersion(dbSetting.getAuditVersion()));
        dbSetting.setAuditNodeSettings(setting.getAuditNodeSettings());
        this.orderAuditSettingRepository.saveAndFlush((Object)dbSetting);
    }

    @Override
    public OrderAuditSetting findByOrderId(String orderId) {
        if (StringUtils.isBlank((CharSequence)orderId)) {
            return null;
        }
        return this.orderAuditSettingRepository.findByOrderId(orderId);
    }

    private void validate(OrderAuditSetting setting) {
        Validate.notNull((Object)((Object)setting), (String)"\u8ba2\u5355\u5ba1\u6838\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)setting.getOrderInfo()), (String)"\u5173\u8054\u7684\u8ba2\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)setting.getAuditNodeSettings())) {
            JSONArray array = JSONArray.parseArray((String)setting.getAuditNodeSettings());
            for (int index = 0; index < array.size(); ++index) {
                JSONObject json = array.getJSONObject(index);
                Validate.isTrue((json.containsKey((Object)"node") && json.containsKey((Object)"roleCodes") && json.containsKey((Object)"sorts") ? 1 : 0) != 0, (String)"\u8ba2\u5355\u5ba1\u6838\u914d\u7f6e\u4fe1\u606f\u683c\u5f0f\u5f02\u5e38", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)json.getString("node"), (String)"\u8ba2\u5355\u5ba1\u6838node\u8282\u70b9\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notNull((Object)json.getInteger("sorts"), (String)"\u8ba2\u5355\u5ba1\u6838node\u8282\u70b9\u987a\u5e8f\u8bbe\u7f6e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            }
        }
    }

    @Override
    public String generateAuditVersion(String version) {
        if (StringUtils.isBlank((CharSequence)version)) {
            return DEAULT_VERSION;
        }
        String[] values = StringUtils.split((String)version, (String)",");
        Validate.isTrue((values != null && values.length > 0 && StringUtils.isNumericSpace((CharSequence)values[0]) ? 1 : 0) != 0, (String)"\u8ba2\u5355\u5ba1\u6838\u7248\u672c\u503c\u4fe1\u606f\u6709\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (Object[])new Object[0]);
        return String.format("%d.0.0", Integer.parseInt(values[0]) + 1);
    }
}

