/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.service.internal;

import com.bizunited.empower.business.common.util.SecurityUtils;
import com.bizunited.empower.business.order.entity.OrderFile;
import com.bizunited.empower.business.order.repository.OrderFileRepository;
import com.bizunited.empower.business.order.service.OrderFileService;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="OrderFileServiceImpl")
public class OrderFileServiceImpl
implements OrderFileService {
    @Autowired
    private OrderFileRepository orderFileRepository;

    @Override
    @Transactional
    public OrderFile create(OrderFile orderFile) {
        OrderFile current = this.createForm(orderFile);
        return current;
    }

    @Override
    @Transactional
    public OrderFile createForm(OrderFile orderFile) {
        Date now = new Date();
        orderFile.setCreateAccount(SecurityUtils.getUserAccount());
        orderFile.setCreateTime(now);
        orderFile.setModifyAccount(SecurityUtils.getUserAccount());
        orderFile.setModifyTime(now);
        this.createValidation(orderFile);
        this.orderFileRepository.save((Object)orderFile);
        return orderFile;
    }

    private void createValidation(OrderFile orderFile) {
        Validate.notNull((Object)((Object)orderFile), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)orderFile.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        orderFile.setId(null);
        Validate.notBlank((CharSequence)orderFile.getRelativePath(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u76f8\u5bf9\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderFile.getFileName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u539f\u59cb\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderFile.getReFileName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u91cd\u547d\u540d\u540e\u7684\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((orderFile.getRelativePath() == null || orderFile.getRelativePath().length() < 255 ? 1 : 0) != 0, (String)"\u76f8\u5bf9\u8def\u5f84,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((orderFile.getFileName() == null || orderFile.getFileName().length() < 128 ? 1 : 0) != 0, (String)"\u539f\u59cb\u6587\u4ef6\u540d,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((orderFile.getReFileName() == null || orderFile.getReFileName().length() < 128 ? 1 : 0) != 0, (String)"\u91cd\u547d\u540d\u540e\u7684\u6587\u4ef6\u540d,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    public Set<OrderFile> findDetailsByOrderInfo(String orderInfo) {
        if (StringUtils.isBlank((CharSequence)orderInfo)) {
            return Sets.newHashSet();
        }
        return this.orderFileRepository.findDetailsByOrderInfo(orderInfo);
    }

    @Override
    public OrderFile findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.orderFileRepository.findDetailsById(id);
    }

    @Override
    public OrderFile findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.orderFileRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    @Transactional
    public void deleteByIds(String[] ids) {
        if (ids == null || ids.length <= 0) {
            return;
        }
        this.orderFileRepository.deleteByIds(ids);
    }
}

