/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.service.internal;

import com.alibaba.fastjson.JSONArray;
import com.bizunited.empower.business.allowable.service.CustomerBuyableProductService;
import com.bizunited.empower.business.common.util.SecurityUtils;
import com.bizunited.empower.business.order.dto.OrderInfoDto;
import com.bizunited.empower.business.order.entity.OrderAuditSetting;
import com.bizunited.empower.business.order.entity.OrderFile;
import com.bizunited.empower.business.order.entity.OrderInfo;
import com.bizunited.empower.business.order.entity.OrderInfoRebateProductsResult;
import com.bizunited.empower.business.order.entity.OrderInfoRebateResult;
import com.bizunited.empower.business.order.entity.OrderLogisticsInfo;
import com.bizunited.empower.business.order.entity.OrderProduct;
import com.bizunited.empower.business.order.enums.GoodsBeforePayStatus;
import com.bizunited.empower.business.order.repository.OrderInfoRepository;
import com.bizunited.empower.business.order.service.OrderAuditSettingService;
import com.bizunited.empower.business.order.service.OrderFileService;
import com.bizunited.empower.business.order.service.OrderInfoService;
import com.bizunited.empower.business.order.service.OrderLogisticsInfoService;
import com.bizunited.empower.business.order.service.OrderProductService;
import com.bizunited.empower.business.order.service.strategy.OrderRoamStrategy;
import com.bizunited.empower.business.order.service.strategy.OrderStrategyEvent;
import com.bizunited.empower.business.payment.common.enums.FundsChannelType;
import com.bizunited.empower.business.payment.entity.ReceivableInfo;
import com.bizunited.empower.business.payment.service.ReceiptInfoService;
import com.bizunited.empower.business.payment.service.ReceivableInfoService;
import com.bizunited.empower.business.policy.service.PolicyExecuteService;
import com.bizunited.empower.business.policy.service.RebatePolicyExecuteService;
import com.bizunited.empower.business.policy.service.rebatepolicy.RebatePolicyExecuteContext;
import com.bizunited.empower.business.policy.service.rebatepolicy.context.BillCon;
import com.bizunited.empower.business.policy.service.rebatepolicy.context.BillConProduct;
import com.bizunited.empower.business.policy.service.rebatepolicy.context.BillConProductResult;
import com.bizunited.empower.business.policy.service.rebatepolicy.context.BillConResult;
import com.bizunited.empower.business.policy.service.salepolicy.PolicyExecuteContext;
import com.bizunited.empower.business.policy.service.salepolicy.context.PolicyConProduct;
import com.bizunited.empower.business.policy.service.salepolicy.pojo.GiftInfo;
import com.bizunited.empower.business.product.dto.BrandAndUnitMapBarCodeDto;
import com.bizunited.empower.business.product.dto.ProductSpecificationOrderDto;
import com.bizunited.empower.business.product.service.ProductActionService;
import com.bizunited.empower.business.product.service.ProductSpecificationVoService;
import com.bizunited.empower.business.product.vo.ProductBarCodeInfoVo;
import com.bizunited.empower.business.product.vo.ProductSpecificationVo;
import com.bizunited.empower.business.tenant.utils.DealerTenantUtils;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.service.invoke.InvokeParams;
import com.bizunited.platform.common.service.redis.RedisMutexService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="OrderInfoServiceImpl")
public class OrderInfoServiceImpl
implements OrderInfoService {
    private static final String ORDER_GEN_PREFIX = "DH_ORDER_REPEAT";
    private static final String DEFAULT_AUDIT_VERSION = "1.0.0";
    @Autowired
    private OrderInfoRepository orderInfoRepository;
    @Autowired
    private OrderLogisticsInfoService orderLogisticsInfoService;
    @Autowired
    private OrderProductService orderProductService;
    @Autowired
    private OrderFileService orderFileService;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private ProductActionService productActionService;
    @Autowired
    private PolicyExecuteService policyExecuteService;
    @Autowired
    private RebatePolicyExecuteService rebatePolicyExecuteService;
    @Autowired
    private ReceivableInfoService receivableInfoService;
    @Autowired
    private ReceiptInfoService receiptInfoService;
    @Autowired
    private ProductSpecificationVoService productSpecificationVoService;
    @Autowired
    private CustomerBuyableProductService customerBuyableProductService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private OrderAuditSettingService orderAuditSettingService;
    @Autowired(required=false)
    private List<OrderRoamStrategy> orderRoamStrategys;

    @Override
    public String preModify() {
        String prefix = UUID.randomUUID().toString();
        this.redisMutexService.setMCode(ORDER_GEN_PREFIX, prefix, prefix, TimeUnit.MILLISECONDS.convert(7L, TimeUnit.DAYS));
        return prefix;
    }

    @Override
    @Transactional
    public OrderInfo create(OrderInfoDto orderInfo) {
        Validate.notNull((Object)orderInfo, (String)"\u8bf7\u4f20\u5165\u8ba2\u5355\u57fa\u672c\u4fe1\u606f\u548c\u8ba2\u5355\u660e\u7ec6\u4fe1\u606f!", (Object[])new Object[0]);
        Validate.notNull((Object)orderInfo.getOrderType(), (String)"\u5176\u5b83\u6a21\u5757\u8fdb\u884c\u8ba2\u5355\u4fe1\u606f\u521b\u5efa\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u8ba2\u5355\u7c7b\u578b\uff081\u3001\u666e\u901a\u8ba2\u5355\uff1b2\u3001\u8f66\u9500\u8ba2\u5355\uff09", (Object[])new Object[0]);
        OrderInfo currentOrderInfo = (OrderInfo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)orderInfo, OrderInfo.class, LinkedHashSet.class, ArrayList.class, new String[]{"orderProducts", "orderFiles", "logisticsInfo", "rebateResults", "rebateResults.productsResults"}));
        String prefix = this.preModify();
        currentOrderInfo.setPrefix(prefix);
        return this.create(currentOrderInfo);
    }

    @Override
    @Transactional
    public OrderInfo create(OrderInfo orderInfo) {
        this.validationPrefix(orderInfo);
        return this.createForm(orderInfo);
    }

    private OrderInfo createForm(OrderInfo orderInfo) {
        Set<OrderFile> set;
        Set<OrderProduct> orderProducts;
        Validate.notNull((Object)((Object)orderInfo), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Date now = new Date();
        orderInfo.setCreateAccount(SecurityUtils.getUserAccount());
        orderInfo.setCreateTime(now);
        orderInfo.setModifyAccount(SecurityUtils.getUserAccount());
        orderInfo.setModifyTime(now);
        String tenantCode = TenantUtils.getTenantCode();
        orderInfo.setTenantCode(tenantCode);
        orderInfo.setOrderStatus(null);
        orderInfo.setReceivableStatus(1);
        if (orderInfo.getOrderType() == null) {
            orderInfo.setOrderType(1);
        }
        if (orderInfo.getPayType() == null) {
            orderInfo.setPayType(GoodsBeforePayStatus.AFTER_PAY.getValue());
        }
        orderInfo.setOrderCode(UUID.randomUUID().toString());
        this.createValidation(orderInfo);
        long giftCount = orderInfo.getOrderProducts().stream().filter(item -> item.getGift() == 1).count();
        orderInfo.setGiftsNumber((int)giftCount);
        long productCount = orderInfo.getOrderProducts().stream().filter(item -> item.getGift() == 0).count();
        orderInfo.setProductsNumber((int)productCount);
        long rebateCount = orderInfo.getOrderProducts().stream().filter(item -> item.getGift() != 0 && item.getGift() != 1).count();
        Validate.isTrue((rebateCount == 0L ? 1 : 0) != 0, (String)"\u8ba2\u5355\u64cd\u4f5c\u65f6\uff0c\u4e0d\u5141\u8bb8\u4f20\u5165\u672c\u54c1\u548c\u8d60\u54c1\u4ee5\u5916\u7684\u5546\u54c1\u7c7b\u578b\uff08\u82e5\u4e3a\u8fd4\u5229\u5546\u54c1\uff0c\u8bf7\u6309\u7167\u8fd4\u5229\u5546\u54c1\u683c\u5f0f\u8981\u6c42\u8fdb\u884c\u4f20\u5165\uff09\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        BigDecimal fare = orderInfo.getFare() == null ? BigDecimal.valueOf(0L) : orderInfo.getFare();
        BigDecimal specialPrice = orderInfo.getOrderSpecialPrice() == null ? BigDecimal.valueOf(0L) : orderInfo.getOrderSpecialPrice();
        BigDecimal discountPrice = this.analysisDiscountPriceForSalePolicy(orderInfo, tenantCode);
        BigDecimal discountPoolPrice = this.analysisDiscountPriceForRebatePolicy(orderInfo, tenantCode);
        BigDecimal productTotalPrice = this.orderProductService.analysisProductsTotal(orderInfo.getOrderProducts());
        BigDecimal orderPointPrice = orderInfo.getOrderPointPrice() == null ? BigDecimal.ZERO : orderInfo.getOrderPointPrice();
        BigDecimal totalPrice = productTotalPrice.add(fare).subtract(specialPrice).subtract(discountPrice).subtract(discountPoolPrice).subtract(orderPointPrice);
        totalPrice = totalPrice.setScale(2, RoundingMode.UP);
        totalPrice = totalPrice.floatValue() <= 0.0f ? BigDecimal.ZERO : totalPrice;
        orderInfo.setProductTotalPrice(productTotalPrice);
        orderInfo.setFare(fare);
        orderInfo.setOrderSpecialPrice(specialPrice);
        orderInfo.setOrderDiscountPrice(discountPrice);
        orderInfo.setDiscountPoolPrice(discountPoolPrice);
        orderInfo.setOrderPointPrice(orderPointPrice);
        orderInfo.setOrderTotalPrice(totalPrice);
        this.orderInfoRepository.save((Object)orderInfo);
        Set<OrderLogisticsInfo> orderLogisticsInfos = orderInfo.getLogisticsInfo();
        if (orderLogisticsInfos != null) {
            for (OrderLogisticsInfo orderLogisticsInfo : orderLogisticsInfos) {
                orderLogisticsInfo.setOrderInfo(orderInfo);
                this.orderLogisticsInfoService.create(orderLogisticsInfo);
            }
        }
        if ((orderProducts = orderInfo.getOrderProducts()) != null) {
            for (OrderProduct orderProduct : orderProducts) {
                orderProduct.setOrderInfo(orderInfo);
                orderProduct.setTenantCode(TenantUtils.getTenantCode());
                this.orderProductService.create(orderProduct);
            }
        }
        if ((set = orderInfo.getOrderFiles()) != null) {
            for (OrderFile orderFile : set) {
                orderFile.setOrderInfo(orderInfo);
                this.orderFileService.create(orderFile);
            }
        }
        if (orderInfo.getOrderType() != 2) {
            this.processAuditSettingInfo(orderInfo);
        }
        this.nextOrderStatusById(orderInfo.getId(), OrderStrategyEvent.BeAudit);
        return orderInfo;
    }

    private void createValidation(OrderInfo orderInfo) {
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)orderInfo.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        orderInfo.setId(null);
        Validate.notBlank((CharSequence)orderInfo.getCustomerCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5ba2\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.inclusiveBetween((long)1L, (long)2L, (long)orderInfo.getOrderType().intValue(), (String)"\u9519\u8bef\u7684\u8ba2\u5355\u7c7b\u578b\uff0c\u8bf7\u586b\u5199(1\u3001\u666e\u901a\u8ba2\u5355\uff1b2\u3001\u8f66\u9500\u8ba2\u5355)");
        Validate.notEmpty(orderInfo.getLogisticsInfo(), (String)"\u5f53\u524d\u8ba2\u5355\u5fc5\u987b\u6709\u4e00\u6761\u914d\u9001\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.notNull((Object)orderInfo.getPayType(), (String)"\u4ed8\u6b3e\u5148\u540e\u72b6\u6001\u5fc5\u987b\u6709\u503c", (Object[])new Object[0]);
        Set<OrderProduct> orderProducts = orderInfo.getOrderProducts();
        Validate.notEmpty(orderProducts, (String)"\u8ba2\u5355\u81f3\u5c11\u9700\u8981\u4e00\u6761\u5546\u54c1\u4fe1\u606f!!", (Object[])new Object[0]);
        List productSpecificationCodes = orderProducts.stream().filter(item -> item.getGift() == 0).map(OrderProduct::getProductSpecificationCode).distinct().collect(Collectors.toList());
        boolean validateSpecificationExist = this.productActionService.validateSpecificationExist(productSpecificationCodes);
        Validate.isTrue((boolean)validateSpecificationExist, (String)"\u6dfb\u52a0\u8ba2\u5355\u65f6\uff0c\u81f3\u5c11\u6709\u4e00\u9879\u5546\u54c1\u660e\u7ec6\u5e76\u4e0d\u5b58\u5728\u4e8e\u7ecf\u9500\u5546\u7684\u9500\u552e\u5217\u8868\u4e2d\uff0c\u8bf7\u68c0\u67e5!!!", (Object[])new Object[0]);
        validateSpecificationExist = this.customerBuyableProductService.validProducts(orderInfo.getCustomerCode(), productSpecificationCodes);
        Validate.isTrue((boolean)validateSpecificationExist, (String)"\u6dfb\u52a0\u8ba2\u5355\u65f6\uff0c\u81f3\u5c11\u6709\u4e00\u9879\u5546\u54c1\u660e\u7ec6\u4e0d\u5b58\u5728\u4e8e\u5f53\u524d\u5ba2\u6237\u7684\u53ef\u8d2d\u6e05\u5355\u5185\uff0c\u8bf7\u68c0\u67e5!!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)orderProducts.stream().anyMatch(item -> item.getGift() == 0), (String)"\u8ba2\u5355\u521b\u5efa\u65f6\uff0c\u4e0d\u80fd\u6240\u6709\u7684\u5546\u54c1\u89c4\u683c\u660e\u7ec6\u90fd\u4e3a\u8d60\u54c1", (Object[])new Object[0]);
        Validate.notNull((Object)orderInfo.getReceivableStatus(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u6536\u6b3e\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ArrayList productSpecificationOrders = new ArrayList();
        orderProducts.stream().filter(item -> item.getGift() == 0).forEach(item -> {
            ProductSpecificationOrderDto productSpecificationOrder = new ProductSpecificationOrderDto();
            productSpecificationOrder.setOrderQuantity(item.getOrderQuantity());
            productSpecificationOrder.setProductSpecificationCode(item.getProductSpecificationCode());
            productSpecificationOrder.setUnitCode(item.getUnitCode());
            productSpecificationOrders.add(productSpecificationOrder);
        });
        this.productSpecificationVoService.validateOrderQuantity(productSpecificationOrders);
        Validate.notBlank((CharSequence)orderInfo.getOrderSource(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8ba2\u5355\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((orderInfo.getTenantCode() == null || orderInfo.getTenantCode().length() < 255 ? 1 : 0) != 0, (String)"\u79df\u6237\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((orderInfo.getOrderCode() == null || orderInfo.getOrderCode().length() < 64 ? 1 : 0) != 0, (String)"\u8ba2\u5355\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((orderInfo.getCustomerCode() == null || orderInfo.getCustomerCode().length() < 64 ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((orderInfo.getOrderSource() == null || orderInfo.getOrderSource().length() < 32 ? 1 : 0) != 0, (String)"\u8ba2\u5355\u6765\u6e90,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((orderInfo.getRemark() == null || orderInfo.getRemark().length() < 255 ? 1 : 0) != 0, (String)"\u5907\u6ce8\u4fe1\u606f,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    private BigDecimal analysisDiscountPriceForSalePolicy(OrderInfo orderInfo, String tenantCode) {
        BigDecimal discountPrice = BigDecimal.ZERO;
        Set<OrderProduct> orderProducts = orderInfo.getOrderProducts();
        if (!CollectionUtils.isEmpty(orderProducts)) {
            LinkedHashSet policyProducts = Sets.newLinkedHashSet();
            ArrayList giftInfos = Lists.newArrayList();
            orderProducts.stream().filter(item -> item.getGift() == 1).forEach(item -> {
                GiftInfo giftInfo = new GiftInfo();
                giftInfo.setSpecificationCode(item.getProductSpecificationCode());
                giftInfo.setUnitCode(item.getUnitCode());
                giftInfo.setQuantity(Integer.valueOf(item.getOrderQuantity().intValue()));
                giftInfos.add(giftInfo);
            });
            orderProducts.stream().filter(item -> item.getGift() == 0).forEach(item -> {
                PolicyConProduct policyConProduct = new PolicyConProduct();
                policyConProduct.setProductSpecificationCode(item.getProductSpecificationCode());
                policyConProduct.setUnitCode(item.getUnitCode());
                policyConProduct.setQuantity(item.getOrderQuantity());
                policyConProduct.setUnitPrice(item.getUnitPrice());
                policyConProduct.setSubtotalAmount(item.getOrderQuantity().multiply(item.getUnitPrice()));
                policyProducts.add(policyConProduct);
            });
            String customerCode = orderInfo.getCustomerCode();
            PolicyExecuteContext policyExecuteContext = this.policyExecuteService.executePolicy(orderInfo.getOrderCode(), (Set)policyProducts, (List)giftInfos, tenantCode, customerCode);
            if (policyExecuteContext != null) {
                discountPrice = policyExecuteContext.getTotalDiscountAmount();
                discountPrice.setScale(4, RoundingMode.HALF_UP);
            }
        }
        return discountPrice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validationPrefix(OrderInfo orderInfo) {
        block5: {
            String prefix = orderInfo.getPrefix();
            Validate.notBlank((CharSequence)prefix, (String)"\u9519\u8bef\u7684\u8ba2\u5355\u9884\u6dfb\u52a0\u6807\u8bb0\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.redisMutexService.getMCode(ORDER_GEN_PREFIX, prefix)), (String)"\u6ca1\u6709\u53d1\u73b0\u8ba2\u5355\u7684\u9884\u64cd\u4f5c\u6807\u8bb0\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u91cd\u590d\u64cd\u4f5c\u7684\u539f\u56e0!!", (Object[])new Object[0]);
            boolean isLock = false;
            try {
                isLock = this.redisMutexService.tryLock(prefix, TimeUnit.MILLISECONDS, 1);
                if (isLock) {
                    this.redisMutexService.setMCode(ORDER_GEN_PREFIX, prefix, prefix, 1L);
                    break block5;
                }
                throw new IllegalArgumentException("\u8bf7\u4e0d\u8981\u91cd\u590d\u8fdb\u884c\u8ba2\u5355\u6dfb\u52a0!!");
            }
            finally {
                if (isLock) {
                    this.redisMutexService.unlock(prefix);
                }
            }
        }
    }

    private BigDecimal analysisDiscountPriceForRebatePolicy(OrderInfo orderInfo, String tenantCode) {
        Set<OrderInfoRebateResult> rebateResults = orderInfo.getRebateResults();
        if (CollectionUtils.isEmpty(rebateResults)) {
            return BigDecimal.ZERO;
        }
        long distinctCodeSize = rebateResults.stream().map(OrderInfoRebateResult::getRebatePolicyCode).distinct().count();
        Validate.isTrue((rebateResults.size() == (int)distinctCodeSize ? 1 : 0) != 0, (String)"\u8fdb\u884c\u8ba2\u5355\u8fd4\u5229\u7ed3\u679c\u8ba1\u7b97\u65f6\uff0c\u53d1\u73b0\u6709\u91cd\u590d\u7684\u8bbe\u7f6e\u7684\u8fd4\u5229\u653f\u7b56\u4fe1\u606f!!", (Object[])new Object[0]);
        BillCon bill = new BillCon();
        bill.setCustomerCode(orderInfo.getCustomerCode());
        bill.setTotalAmount(orderInfo.getProductTotalPrice());
        bill.setPreferentialAmount(orderInfo.getProductTotalPrice());
        bill.setCode(orderInfo.getOrderCode());
        Set<OrderProduct> orderProducts = orderInfo.getOrderProducts();
        Set orderInitProducts = orderProducts.stream().filter(item -> item.getGift() == 0).collect(Collectors.toSet());
        List specificationCodes = orderProducts.stream().map(OrderProduct::getProductSpecificationCode).distinct().collect(Collectors.toList());
        ArrayList billConProducts = Lists.newArrayList();
        bill.setProducts((List)billConProducts);
        BrandAndUnitMapBarCodeDto brandAndUnitMapBarCodeMapping = this.productSpecificationVoService.findBrandAndUnitMapBarCodeBySpecCodes(specificationCodes);
        for (Object orderInitProduct : orderInitProducts) {
            BillConProduct billProduct = new BillConProduct();
            String productSpecificationCode = ((OrderProduct)((Object)orderInitProduct)).getProductSpecificationCode();
            String unitCode = ((OrderProduct)((Object)orderInitProduct)).getUnitCode();
            BrandAndUnitMapBarCodeDto brandAndUnitMapBarCode = brandAndUnitMapBarCodeMapping.getBrandAndUnitMapBarCodeDto(productSpecificationCode, unitCode);
            Validate.notNull((Object)brandAndUnitMapBarCode, (String)"\u672a\u627e\u5230\u5546\u54c1\u89c4\u683c[%s,%s]\u6240\u5c5e\u54c1\u724c\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{productSpecificationCode, unitCode});
            billProduct.setBrandCode(brandAndUnitMapBarCode.getBrandCode());
            billProduct.setProductSpecificationCode(productSpecificationCode);
            billProduct.setQuantity(((OrderProduct)((Object)orderInitProduct)).getOrderQuantity());
            billProduct.setSubtotalAmount(((OrderProduct)((Object)orderInitProduct)).getSubtotalAmount());
            billProduct.setUnitCode(unitCode);
            billConProducts.add(billProduct);
        }
        ArrayList billResults = Lists.newArrayList();
        bill.setBillResults((List)billResults);
        for (OrderInfoRebateResult rebateResult : rebateResults) {
            BillConResult billResult = new BillConResult();
            billResult.setDiscountAmount(rebateResult.getDiscountAmount());
            billResult.setRebatePolicyCode(rebateResult.getRebatePolicyCode());
            billResults.add(billResult);
            List<OrderInfoRebateProductsResult> rebateProductsResults = rebateResult.getProductsResults();
            if (CollectionUtils.isEmpty(rebateProductsResults)) continue;
            ArrayList billConProductResults = Lists.newArrayList();
            for (OrderInfoRebateProductsResult rebateProductsResultItem : rebateProductsResults) {
                BillConProductResult billConProductResult = new BillConProductResult();
                billConProductResult.setProductCode(rebateProductsResultItem.getProductCode());
                billConProductResult.setProductSpecificationCode(rebateProductsResultItem.getProductSpecificationCode());
                billConProductResult.setQuantity(rebateProductsResultItem.getQuantity());
                billConProductResult.setUnitCode(rebateProductsResultItem.getUnitCode());
                billConProductResults.add(billConProductResult);
            }
            billResult.setProductResutls((List)billConProductResults);
        }
        RebatePolicyExecuteContext executeContext = this.rebatePolicyExecuteService.executePolicy(bill, tenantCode);
        BigDecimal discountAmount = executeContext.getResultDiscountAmount();
        Set billConProductResults = executeContext.getResultProducts();
        if (CollectionUtils.isEmpty((Collection)billConProductResults)) {
            return discountAmount == null ? BigDecimal.ZERO : discountAmount.setScale(4, RoundingMode.HALF_UP);
        }
        Set<OrderProduct> currentOrderProducts = orderInfo.getOrderProducts();
        for (BillConProductResult billConProductResult : billConProductResults) {
            String productSpecificationCode = billConProductResult.getProductSpecificationCode();
            BigDecimal quantity = billConProductResult.getQuantity();
            String unitCode = billConProductResult.getUnitCode();
            ProductSpecificationVo productSpecification = this.productSpecificationVoService.findBySpecificationCode(billConProductResult.getProductSpecificationCode());
            Validate.notNull((Object)productSpecification, (String)"\u8fd4\u5229\u653f\u7b56\u4e2d\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u5546\u54c1\u54c1\u724c\u4fe1\u606f!", (Object[])new Object[0]);
            Set productBarCodeInfos = productSpecification.getProductBarCodeInfos();
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)productBarCodeInfos) ? 1 : 0) != 0, (String)"\u8fd4\u5229\u653f\u7b56\u4e2d\uff0c\u5546\u54c1\u89c4\u683c[%s,%s]\u672a\u53d1\u73b0\u4efb\u4f55\u6761\u7801\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u53c2\u4e0e\u8fd4\u5229\u5206\u6790\uff0c\u8bf7\u68c0\u67e5\u4ea7\u54c1\u6570\u636e!!", (Object[])new Object[]{productSpecification.getProductSpecificationCode(), productSpecification.getProductSpecificationName()});
            ProductBarCodeInfoVo productBarCodeInfo = null;
            for (ProductBarCodeInfoVo productBarCodeInfoItem : productBarCodeInfos) {
                if (!StringUtils.equals((CharSequence)productBarCodeInfoItem.getUnitCode(), (CharSequence)unitCode)) continue;
                productBarCodeInfo = productBarCodeInfoItem;
                break;
            }
            Validate.notNull(productBarCodeInfo, (String)"\u8fd4\u5229\u653f\u7b56\u4e2d\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u5546\u54c1\u89c4\u683c\u6761\u7801\u4fe1\u606f!", (Object[])new Object[0]);
            OrderProduct orderProduct = new OrderProduct();
            orderProduct.setGift(2);
            orderProduct.setInternationalBarcode(productBarCodeInfo.getBarCode());
            orderProduct.setOrderInfo(orderInfo);
            orderProduct.setOrderQuantity(quantity);
            orderProduct.setProductSource("\u5b9e\u7269\u8fd4\u5229");
            orderProduct.setProductSpecificationCode(productSpecificationCode);
            orderProduct.setProductSpecificationName(productSpecification.getProductSpecificationName());
            orderProduct.setRemark("\u5b9e\u7269\u8fd4\u5229");
            orderProduct.setSubtotalAmount(BigDecimal.ZERO);
            orderProduct.setUnitCode(unitCode);
            orderProduct.setUnitPrice(BigDecimal.ZERO);
            currentOrderProducts.add(orderProduct);
        }
        return discountAmount == null ? BigDecimal.ZERO : discountAmount.setScale(4, RoundingMode.HALF_UP);
    }

    @Override
    @Transactional
    public OrderInfo update(OrderInfo orderInfo) {
        Validate.notNull((Object)((Object)orderInfo), (String)"\u8bf7\u4f20\u5165\u8ba2\u5355\u57fa\u672c\u4fe1\u606f\u548c\u8ba2\u5355\u660e\u7ec6\u4fe1\u606f!", (Object[])new Object[0]);
        this.validationPrefix(orderInfo);
        return this.updateForm(orderInfo);
    }

    private OrderInfo updateForm(OrderInfo orderInfo) {
        Validate.notNull((Object)((Object)orderInfo), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u8ba2\u5355\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((orderInfo.getOrderType() != 2 ? 1 : 0) != 0, (String)"\u6682\u4e0d\u652f\u6301\u8f66\u9500\u8ba2\u5355\u7f16\u8f91", (Object[])new Object[0]);
        String currentId = orderInfo.getId();
        Validate.isTrue((!StringUtils.isBlank((CharSequence)currentId) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        OrderInfo oldOrderInfo = this.orderInfoRepository.findDetailsById(currentId);
        Validate.notNull((Object)((Object)oldOrderInfo), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u8ba2\u5355\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String oldOrderCode = oldOrderInfo.getOrderCode();
        Validate.isTrue((orderInfo.getOrderStatus() >= 1 && orderInfo.getOrderStatus() <= 2 ? 1 : 0) != 0, (String)"\u76ee\u524d\u53ea\u652f\u6301\u3010\u5f85\u5ba1\u6838\u3011\u3010\u5f85\u51fa\u5e93\u3011\u72b6\u6001\u7684\u7f16\u8f91\u64cd\u4f5c", (Object[])new Object[0]);
        ReceivableInfo receivableInfo = this.receivableInfoService.findByAssociatedCode(oldOrderCode);
        BigDecimal oldReceivedAmount = BigDecimal.ZERO;
        if (receivableInfo != null) {
            oldReceivedAmount = receivableInfo.getReceivedAmount();
        }
        this.orderInfoRepository.saveAndFlush((Object)oldOrderInfo);
        this.nextOrderStatus(oldOrderCode, OrderStrategyEvent.Cancelled);
        this.cleanOrderInfoIds(orderInfo);
        orderInfo.setReceivableStatus(1);
        this.createForm(orderInfo);
        if (oldReceivedAmount.floatValue() > 0.0f) {
            String newOrderCode = orderInfo.getOrderCode();
            BigDecimal newOrderTotalPrice = orderInfo.getOrderTotalPrice();
            InvokeParams params = new InvokeParams();
            params.putInvokeParam("_internal", (Object)true);
            if (newOrderTotalPrice.floatValue() >= oldReceivedAmount.floatValue()) {
                this.receiptInfoService.createByAssociatedCode(newOrderCode, oldReceivedAmount, FundsChannelType.BALANCE, params);
            } else {
                this.receiptInfoService.createByAssociatedCode(newOrderCode, newOrderTotalPrice, FundsChannelType.BALANCE, params);
            }
        }
        return orderInfo;
    }

    private void cleanOrderInfoIds(OrderInfo orderInfo) {
        Set<OrderFile> orderFiles;
        Set<OrderProduct> orderProducts;
        orderInfo.setId(null);
        orderInfo.setOrderCode(null);
        Set<OrderLogisticsInfo> orderLogisticsInfos = orderInfo.getLogisticsInfo();
        if (orderLogisticsInfos != null) {
            orderLogisticsInfos.forEach(e -> e.setId(null));
        }
        if ((orderProducts = orderInfo.getOrderProducts()) != null) {
            orderProducts.forEach(e -> e.setId(null));
        }
        if ((orderFiles = orderInfo.getOrderFiles()) != null) {
            orderFiles.forEach(e -> e.setId(null));
        }
    }

    @Override
    @Transactional
    public OrderInfo nextOrderStatus(String orderCode, OrderStrategyEvent event) {
        Validate.notBlank((CharSequence)orderCode, (String)"\u9519\u8bef\u7684\u8ba2\u5355\u7f16\u53f7\uff08\u8ba2\u5355\u4e1a\u52a1\u7f16\u53f7\uff09\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)event), (String)"\u9519\u8bef\u7684\u8ba2\u5355\u4e8b\u4ef6\u6807\u8bb0\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        this.validateStrategys();
        OrderInfo currentOrder = this.findByOrderCode(orderCode);
        Validate.notNull((Object)((Object)currentOrder), (String)"\u672a\u6839\u636e\u6307\u5b9a\u7684\u8ba2\u5355\u7f16\u53f7\uff08\u8ba2\u5355\u4e1a\u52a1\u7f16\u53f7\uff09\uff0c\u627e\u5230\u5bf9\u5e94\u7684\u8ba2\u5355\u57fa\u672c\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        return this.nextOrderStatusById(currentOrder.getId(), event);
    }

    @Override
    @Transactional
    public OrderInfo nextOrderStatusById(String id, OrderStrategyEvent event) {
        Validate.notBlank((CharSequence)id, (String)"\u9519\u8bef\u7684\u8ba2\u5355\u7f16\u53f7\uff08\u8ba2\u5355\u6280\u672f\u7f16\u53f7\uff09\uff0c\u8bf7\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)event), (String)"\u9519\u8bef\u7684\u76ee\u6807\u8ba2\u5355\u72b6\u6001\u6d41\u8f6c\u4e8b\u4ef6!!", (Object[])new Object[0]);
        this.validateStrategys();
        OrderInfo currentOrder = this.findById(id);
        Validate.notNull((Object)((Object)currentOrder), (String)"\u672a\u6839\u636e\u6307\u5b9a\u7684\u8ba2\u5355\u7f16\u53f7\uff08\u8ba2\u5355\u6280\u672f\u7f16\u53f7\uff09\uff0c\u627e\u5230\u5bf9\u5e94\u7684\u8ba2\u5355\u57fa\u672c\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        OrderRoamStrategy currentStrategy = null;
        if (this.orderRoamStrategys != null) {
            for (OrderRoamStrategy strategyItem : this.orderRoamStrategys) {
                OrderStrategyEvent strategyEvent = strategyItem.manualValidate();
                if (strategyEvent != event) continue;
                currentStrategy = strategyItem;
                break;
            }
        }
        Validate.notNull(currentStrategy, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u8ba2\u5355\u6d41\u8f6c\u7b56\u7565[%s]", (Object[])new Object[]{event.getEventName()});
        currentStrategy.action(currentOrder);
        return this.nextOrderStatus(currentOrder.getOrderCode());
    }

    @Override
    @Transactional
    public OrderInfo nextOrderStatus(String orderCode) {
        OrderInfo current = this.findByOrderCode(orderCode);
        Validate.notNull((Object)((Object)current), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u8ba2\u5355\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        this.validateStrategys();
        OrderRoamStrategy previousStrategy = null;
        while (true) {
            OrderRoamStrategy foundStrategy = null;
            for (int index = 0; this.orderRoamStrategys != null && index < this.orderRoamStrategys.size(); ++index) {
                OrderRoamStrategy orderRoamStrategy = this.orderRoamStrategys.get(index);
                if (!orderRoamStrategy.automaticValidate(current).booleanValue()) continue;
                foundStrategy = orderRoamStrategy;
                break;
            }
            if (foundStrategy == null || previousStrategy == foundStrategy) break;
            foundStrategy.action(current);
            previousStrategy = foundStrategy;
        }
        return current;
    }

    @Override
    public long countByCreateTimeBetween(Date start, Date end) {
        if (start == null || end == null) {
            return 0L;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return this.orderInfoRepository.countByTenantCodeAndCreateTimeBetween(tenantCode, start, end);
    }

    @Override
    public long countByOrderTypeAndCreateTimeBetween(Integer orderType, String createAccount, Date start, Date end) {
        if (start == null || end == null || orderType == null || StringUtils.isBlank((CharSequence)createAccount)) {
            return 0L;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return this.orderInfoRepository.countByTenantCodeAndOrderTypeAndCreateTimeBetween(tenantCode, orderType, createAccount, start, end);
    }

    @Override
    public BigDecimal sumOrderTotalPriceByCreateTimeBetween(Date start, Date end) {
        if (start == null || end == null) {
            return BigDecimal.valueOf(0L);
        }
        String tenantCode = TenantUtils.getTenantCode();
        BigDecimal bigDecimal = this.orderInfoRepository.sumOrderTotalPriceByTenantCodeAndCreateTimeBetween(tenantCode, start, end);
        return bigDecimal == null ? BigDecimal.ZERO : bigDecimal;
    }

    @Override
    public BigDecimal sumOrderTotalPriceByOrderTypeAndCreateTimeBetween(Integer orderType, String createAccount, Date start, Date end) {
        if (start == null || end == null || orderType == null || StringUtils.isBlank((CharSequence)createAccount)) {
            return BigDecimal.valueOf(0L);
        }
        String tenantCode = TenantUtils.getTenantCode();
        BigDecimal bigDecimal = this.orderInfoRepository.sumOrderTotalPriceByTenantCodeAndOrderTypeAndCreateTimeBetween(tenantCode, orderType, createAccount, start, end);
        return bigDecimal == null ? BigDecimal.ZERO : bigDecimal;
    }

    @Override
    public long countCustomerByCreateTimeBetween(Date start, Date end) {
        if (start == null || end == null) {
            return 0L;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return this.orderInfoRepository.countCustomerByTenantCodeAndCreateTimeBetween(tenantCode, start, end);
    }

    @Override
    public long countByOrderStatusAndCreateTimeBetween(Integer orderStatus, Date start, Date end) {
        if (orderStatus == null || start == null || end == null) {
            return 0L;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return this.orderInfoRepository.countByTenantCodeAndOrderStatusAndCreateTimeBetween(tenantCode, orderStatus, start, end);
    }

    @Override
    public long countByOrderStatus(Integer orderStatus) {
        if (orderStatus == null) {
            return 0L;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return this.orderInfoRepository.countByTenantCodeAndOrderStatus(tenantCode, orderStatus);
    }

    @Override
    public long countByDeliveryStatus(Integer deliveryStatus) {
        if (deliveryStatus == null) {
            return 0L;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return this.orderInfoRepository.countByTenantCodeAndDeliveryStatus(tenantCode, deliveryStatus);
    }

    @Override
    public long countReceivableUndone() {
        String tenantCode = TenantUtils.getTenantCode();
        return this.orderInfoRepository.countReceivableUndoneByTenantCode(tenantCode);
    }

    @Override
    public long countByReceivableStatus(Integer receivableStatus) {
        if (receivableStatus == null) {
            return 0L;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return this.orderInfoRepository.countByTenantCodeAndReceivableStatus(tenantCode, receivableStatus);
    }

    @Override
    public long countEffectiveOrder() {
        String tenantCode = TenantUtils.getTenantCode();
        return this.orderInfoRepository.countEffectiveOrderByTenantCode(tenantCode);
    }

    @Override
    @Transactional
    public void cancel(String orderCode) {
        Validate.notBlank((CharSequence)orderCode, (String)"\u53d6\u6d88\u8ba2\u5355\u65f6\uff0c\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        OrderInfo orderInfo = this.findByOrderCode(orderCode);
        Validate.notNull((Object)((Object)orderInfo), (String)"\u6839\u636e\u63d0\u4f9b\u7684\u8ba2\u5355\u7f16\u53f7\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u8ba2\u5355\u76f8\u5173\u4fe1\u606f", (Object[])new Object[0]);
        if (orderInfo.getOrderType() != 2) {
            Validate.isTrue((OrderStrategyEvent.BeAudit.getEventTarget().equals(orderInfo.getOrderStatus()) || OrderStrategyEvent.BeDelivered.getEventTarget().equals(orderInfo.getOrderStatus()) ? 1 : 0) != 0, (String)"\u76ee\u524d\u53ea\u652f\u6301\u3010\u5f85\u5ba1\u6838\u3011\u3010\u5f85\u51fa\u5e93\u3011\u72b6\u6001\u7684\u53d6\u6d88\u64cd\u4f5c", (Object[])new Object[0]);
        } else {
            Validate.isTrue((boolean)OrderStrategyEvent.BeReceived.getEventTarget().equals(orderInfo.getOrderStatus()), (String)"\u76ee\u524d\u53ea\u652f\u6301\u3010\u5f85\u6536\u8d27\u3011\u72b6\u6001\u7684\u53d6\u6d88\u64cd\u4f5c", (Object[])new Object[0]);
        }
        this.nextOrderStatus(orderCode, OrderStrategyEvent.BeCancel);
    }

    @Override
    public OrderInfo findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.orderInfoRepository.findDetailsById(id);
    }

    @Override
    public OrderInfo findDetailsByOrderCode(String orderCode) {
        if (StringUtils.isBlank((CharSequence)orderCode)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        if (StringUtils.isBlank((CharSequence)tenantCode)) {
            return null;
        }
        return this.orderInfoRepository.findDetailsByOrderCodeAndTenantCode(orderCode, tenantCode);
    }

    @Override
    public OrderInfo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.orderInfoRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    public OrderInfo findByOrderCode(String orderCode) {
        String tenantCode = TenantUtils.getTenantCode();
        if (StringUtils.isBlank((CharSequence)orderCode)) {
            return null;
        }
        return this.orderInfoRepository.findByOrderCodeAndTenantCode(orderCode, tenantCode);
    }

    private void validateStrategys() {
        Validate.isTrue((!CollectionUtils.isEmpty(this.orderRoamStrategys) ? 1 : 0) != 0, (String)"\u672a\u53d1\u73b0\u4efb\u4f55\u8ba2\u5355\u6d41\u8f6c\u7b56\u7565\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
    }

    private void processAuditSettingInfo(OrderInfo orderInfo) {
        JSONArray auditNodeSettings = DealerTenantUtils.getAuditNodeSettings();
        OrderAuditSetting auditSetting = new OrderAuditSetting();
        auditSetting.setOrderInfo(orderInfo);
        auditSetting.setAuditNodeSettings(CollectionUtils.isEmpty((Collection)auditNodeSettings) ? null : auditNodeSettings.toJSONString());
        auditSetting.setAuditVersion(DEFAULT_AUDIT_VERSION);
        this.orderAuditSettingService.create(auditSetting);
    }
}

