/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.service.internal;

import com.bizunited.empower.business.customer.entity.Customer;
import com.bizunited.empower.business.customer.service.CustomerService;
import com.bizunited.empower.business.order.dto.OrderInfoConditionDto;
import com.bizunited.empower.business.order.entity.OrderAuditLog;
import com.bizunited.empower.business.order.entity.OrderAuditSetting;
import com.bizunited.empower.business.order.entity.OrderInfo;
import com.bizunited.empower.business.order.entity.OrderProduct;
import com.bizunited.empower.business.order.enums.GoodsBeforePayStatus;
import com.bizunited.empower.business.order.repository.OrderInfoRepository;
import com.bizunited.empower.business.order.service.OrderAuditLogService;
import com.bizunited.empower.business.order.service.OrderAuditSettingService;
import com.bizunited.empower.business.order.service.OrderInfoVoService;
import com.bizunited.empower.business.order.vo.OrderAuditLogVo;
import com.bizunited.empower.business.order.vo.OrderAuditSettingVo;
import com.bizunited.empower.business.order.vo.OrderInfoVo;
import com.bizunited.empower.business.order.vo.OrderProductVo;
import com.bizunited.empower.business.product.service.ProductSpecificationVoService;
import com.bizunited.empower.business.product.vo.ProductBarCodeInfoVo;
import com.bizunited.empower.business.product.vo.ProductBrandVo;
import com.bizunited.empower.business.product.vo.ProductSpecificationVo;
import com.bizunited.empower.business.product.vo.ProductUnitSpecificationAndPriceVo;
import com.bizunited.empower.business.product.vo.ProductUnitVo;
import com.bizunited.empower.business.product.vo.ProductVo;
import com.bizunited.empower.business.warehouse.entity.WarehouseInfo;
import com.bizunited.empower.business.warehouse.entity.WarehouseProduct;
import com.bizunited.empower.business.warehouse.service.WarehouseInfoService;
import com.bizunited.empower.business.warehouse.service.WarehouseProductService;
import com.bizunited.empower.business.warehouse.service.WarehouseProductsExpenseVoService;
import com.bizunited.empower.business.warehouse.vo.WarehouseProductsExpenseProductVo;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="OrderInfoVoServiceImpl")
public class OrderInfoVoServiceImpl
implements OrderInfoVoService {
    @Autowired
    private OrderInfoRepository orderInfoRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ProductSpecificationVoService productSpecificationVoService;
    @Autowired
    private WarehouseProductsExpenseVoService warehouseProductsExpenseVoService;
    @Autowired
    private WarehouseProductService warehouseProductService;
    @Autowired
    private CustomerService customerService;
    @Autowired
    private OrderAuditSettingService orderAuditSettingService;
    @Autowired
    private OrderAuditLogService orderAuditLogService;
    @Autowired
    private WarehouseInfoService warehouseInfoService;

    @Override
    public Page<OrderInfoVo> findByConditions(Pageable pageable, OrderInfoConditionDto orderInfo) {
        String tenantCode = TenantUtils.getTenantCode();
        orderInfo.setTenantCode(tenantCode);
        Page result = this.orderInfoRepository.findByCondition(pageable, orderInfo);
        if (result == null) {
            return null;
        }
        ArrayList<OrderInfoVo> orderInfos = new ArrayList<OrderInfoVo>();
        for (Object[] item : result) {
            OrderInfoVo orderInfoItem = new OrderInfoVo();
            orderInfoItem.setId(item[0] == null ? null : item[0].toString());
            orderInfoItem.setOrderCode(item[1] == null ? null : item[1].toString());
            orderInfoItem.setCustomerName(item[2] == null ? null : item[2].toString());
            orderInfoItem.setCustomerCode(item[3] == null ? null : item[3].toString());
            orderInfoItem.setOrderStatus(item[4] == null ? null : (Integer)item[4]);
            orderInfoItem.setOrderSource(item[5] == null ? null : item[5].toString());
            orderInfoItem.setDeliveryStatus(item[6] == null ? null : (Integer)item[6]);
            orderInfoItem.setDeliveryMethod(item[7] == null ? null : item[7].toString());
            orderInfoItem.setDeliveryDate(item[8] == null ? null : (Date)item[8]);
            orderInfoItem.setReceivableStatus(item[9] == null ? null : (Integer)item[9]);
            orderInfoItem.setCreateAccount(item[10] == null ? null : item[10].toString());
            orderInfoItem.setSaleAccount(item[11] == null ? null : item[11].toString());
            orderInfoItem.setSaleName(item[12] == null ? null : item[12].toString());
            orderInfoItem.setCreateTime(item[13] == null ? null : (Date)item[13]);
            orderInfoItem.setModifyAccount(item[14] == null ? null : item[14].toString());
            orderInfoItem.setModifyTime(item[15] == null ? null : (Date)item[15]);
            orderInfoItem.setRemark(item[16] == null ? null : item[16].toString());
            orderInfoItem.setTenantCode(item[17] == null ? null : item[17].toString());
            orderInfoItem.setOrderTotalPrice(item[18] == null ? null : (BigDecimal)item[18]);
            orderInfoItem.setRelevanceUserAccount(item[19] == null ? null : item[19].toString());
            orderInfoItem.setOrderType(item[20] == null ? null : (Integer)item[20]);
            orderInfoItem.setRelevanceCode(item[21] == null ? null : item[21].toString());
            orderInfoItem.setCustomerPhone(item[22] == null ? null : item[22].toString());
            orderInfoItem.setProductsNumber(item[23] == null ? null : (Integer)item[23]);
            orderInfoItem.setGiftsNumber(item[24] == null ? null : (Integer)item[24]);
            orderInfoItem.setProductTotalPrice(item[25] == null ? null : (BigDecimal)item[25]);
            orderInfoItem.setFare(item[26] == null ? null : (BigDecimal)item[26]);
            orderInfoItem.setOrderSpecialPrice(item[27] == null ? null : (BigDecimal)item[27]);
            orderInfoItem.setOrderDiscountPrice(item[28] == null ? null : (BigDecimal)item[28]);
            orderInfoItem.setDiscountPoolPrice(item[29] == null ? null : (BigDecimal)item[29]);
            orderInfoItem.setOrderPointPrice(item[30] == null ? null : (BigDecimal)item[30]);
            orderInfoItem.setPayType(item[31] == null ? GoodsBeforePayStatus.AFTER_PAY.getValue() : ((Integer)item[31]).intValue());
            OrderAuditSettingVo settingVo = new OrderAuditSettingVo();
            settingVo.setId(item[32] == null ? null : item[32].toString());
            settingVo.setAuditNodeSettings(item[33] == null ? null : item[33].toString());
            settingVo.setAuditVersion(item[34] == null ? null : item[34].toString());
            orderInfoItem.setOrderAuditSetting(settingVo);
            orderInfos.add(orderInfoItem);
        }
        return new PageImpl(orderInfos, pageable, result.getTotalElements());
    }

    @Override
    public OrderInfoVo findDetailsByOrderCode(String orderCode) {
        Object productSpecificationCode;
        Set<OrderProduct> orderProducts;
        List productSpecificationCodes;
        List productSpecifications;
        OrderAuditSetting setting;
        Customer customer;
        if (StringUtils.isBlank((CharSequence)orderCode)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        OrderInfo orderInfo = this.orderInfoRepository.findDetailsByOrderCodeAndTenantCode(orderCode, tenantCode);
        if (orderInfo == null) {
            return null;
        }
        OrderInfoVo orderInfoVo = (OrderInfoVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)orderInfo, OrderInfoVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"orderProducts", "orderFiles", "logisticsInfo", "orderStatusLoggers"});
        HashSet orderProductVos = orderInfoVo.getOrderProducts();
        if (!CollectionUtils.isEmpty(orderProductVos)) {
            orderProductVos = Sets.newLinkedHashSet((Iterable)orderProductVos.stream().sorted(Comparator.comparing(OrderProductVo::getId)).collect(Collectors.toList()));
            orderInfoVo.setOrderProducts(orderProductVos);
        } else {
            orderProductVos = Sets.newHashSet();
        }
        String customerCode = orderInfo.getCustomerCode();
        String warehouseCode = null;
        if (!StringUtils.isBlank((CharSequence)customerCode) && (customer = this.customerService.findByTenantCodeAndCustomerCode(TenantUtils.getTenantCode(), customerCode)) != null) {
            orderInfoVo.setCustomerCode(customer.getCustomerCode());
            orderInfoVo.setCustomerName(customer.getCustomerName());
            orderInfoVo.setCustomerPhone(customer.getPhone());
            orderInfoVo.setContactPerson(customer.getContactPerson());
            orderInfoVo.setRelevanceUserAccount(customer.getRelevanceUserAccount());
            warehouseCode = customer.getWarehouseCode();
            orderInfoVo.setWarehouseCode(warehouseCode);
            WarehouseInfo warehouseInfo = this.warehouseInfoService.findByWarehouseCode(warehouseCode);
            Validate.notNull((Object)warehouseInfo, (String)"\u672a\u67e5\u8be2\u5230\u5ba2\u6237\u9ed8\u8ba4\u4ed3\u5e93", (Object[])new Object[0]);
            orderInfoVo.setWarehouseName(warehouseInfo.getWarehouseName());
        }
        if ((setting = this.orderAuditSettingService.findByOrderId(orderInfo.getId())) != null) {
            OrderAuditSettingVo settingVo = (OrderAuditSettingVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)setting, OrderAuditSettingVo.class, HashSet.class, ArrayList.class, new String[0]);
            orderInfoVo.setOrderAuditSetting(settingVo);
            List<OrderAuditLog> auditLogs = this.orderAuditLogService.findByOrderIdAndVersion(orderInfo.getId(), setting.getAuditVersion());
            if (!CollectionUtils.isEmpty(auditLogs)) {
                Collection orderAuditLogVos = this.nebulaToolkitService.copyCollectionByWhiteList(auditLogs, OrderAuditLog.class, OrderAuditLogVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                orderInfoVo.setOrderAuditLogs(Sets.newLinkedHashSet((Iterable)orderAuditLogVos));
            }
        }
        if (CollectionUtils.isEmpty((Collection)(productSpecifications = this.productSpecificationVoService.findBySpecificationCodeList(productSpecificationCodes = (orderProducts = orderInfo.getOrderProducts()).stream().map(OrderProduct::getProductSpecificationCode).collect(Collectors.toList()))))) {
            return orderInfoVo;
        }
        for (OrderProductVo orderProductVoItem : orderProductVos) {
            ProductUnitSpecificationAndPriceVo productUnitAndPriceVo;
            Set productUnitAndPriceVos;
            ProductBarCodeInfoVo productBarCodeInfo;
            Set productBarCodeInfos;
            productSpecificationCode = orderProductVoItem.getProductSpecificationCode();
            String unitCodetarget = orderProductVoItem.getUnitCode();
            ProductSpecificationVo productSpecificationVo = productSpecifications.stream().filter(arg_0 -> OrderInfoVoServiceImpl.lambda$findDetailsByOrderCode$0((String)productSpecificationCode, arg_0)).findFirst().orElse(null);
            if (productSpecificationVo == null) continue;
            orderProductVoItem.setMainImageName(productSpecificationVo.getMainImageName());
            orderProductVoItem.setMainImagePath(productSpecificationVo.getMainImagePath());
            ProductVo productVo = productSpecificationVo.getProduct();
            if (productVo != null) {
                orderProductVoItem.setProductCode(productVo.getProductCode());
                orderProductVoItem.setProductName(productVo.getProductName());
                ProductBrandVo productBrand = productVo.getProductBrand();
                if (productBrand != null) {
                    orderProductVoItem.setBrandCode(productBrand.getBrandCode());
                    orderProductVoItem.setBrandName(productBrand.getBrandName());
                }
            }
            if (!CollectionUtils.isEmpty((Collection)(productBarCodeInfos = productSpecificationVo.getProductBarCodeInfos())) && (productBarCodeInfo = (ProductBarCodeInfoVo)productBarCodeInfos.stream().filter(item -> StringUtils.equals((CharSequence)item.getUnitCode(), (CharSequence)unitCodetarget)).findFirst().orElse(null)) != null) {
                orderProductVoItem.setInternationalBarcode(productBarCodeInfo.getBarCode());
            }
            if (CollectionUtils.isEmpty((Collection)(productUnitAndPriceVos = productVo.getProductUnitSpecificationAndPrices())) || (productUnitAndPriceVo = (ProductUnitSpecificationAndPriceVo)productUnitAndPriceVos.stream().filter(item -> {
                ProductUnitVo productUnit = item.getProductUnit();
                if (productUnit == null) {
                    return false;
                }
                String unitCode = productUnit.getUnitCode();
                return StringUtils.equals((CharSequence)unitCode, (CharSequence)unitCodetarget);
            }).findFirst().orElse(null)) == null) continue;
            ProductUnitVo productUnit = productUnitAndPriceVo.getProductUnit();
            orderProductVoItem.setUnitName(productUnit.getUnitName());
            orderProductVoItem.setUnitCode(productUnit.getUnitCode());
        }
        List warehouseProducts = this.warehouseProductService.findByProductSpecificationCodeListAndWarehouseCode(productSpecificationCodes, warehouseCode);
        if (CollectionUtils.isEmpty((Collection)warehouseProducts)) {
            return orderInfoVo;
        }
        Map<String, BigDecimal> usableInventoryMapping = warehouseProducts.stream().collect(Collectors.toMap(WarehouseProduct::getProductSpecificationCode, WarehouseProduct::getUsableInventory));
        productSpecificationCode = orderProductVos.iterator();
        while (productSpecificationCode.hasNext()) {
            OrderProductVo orderProductVoItem;
            BigDecimal usableInventory = usableInventoryMapping.get((orderProductVoItem = (OrderProductVo)productSpecificationCode.next()).getProductSpecificationCode());
            orderProductVoItem.setUsableInventory(usableInventory == null ? BigDecimal.valueOf(0L) : usableInventory);
        }
        List doneExpenses = this.warehouseProductsExpenseVoService.findPreemptQuantityByRelevanceCode(orderCode);
        if (CollectionUtils.isEmpty((Collection)doneExpenses)) {
            return orderInfoVo;
        }
        HashMap<String, BigDecimal> deliveryProducts = new HashMap<String, BigDecimal>();
        for (WarehouseProductsExpenseProductVo currentExpenseProductItem : doneExpenses) {
            String orderProductId = currentExpenseProductItem.getOrderProductId();
            Validate.notBlank((CharSequence)orderProductId, (String)"\u4ece\u51fa\u5e93\u5355\u67e5\u8be2\u5230\u5546\u54c1\u89c4\u683c\u7f16\u53f7\u4e3a\u7a7a\u7684\u51fa\u5e93\u660e\u7ec6\uff0c\u8bf7\u68c0\u67e5\u8ba2\u5355[%s]\u5bf9\u5e94\u7684\u51fa\u5e93\u5355", (Object[])new Object[]{orderCode});
            BigDecimal quantity = currentExpenseProductItem.getQuantity();
            if (deliveryProducts.get(orderProductId) != null) {
                deliveryProducts.put(orderProductId, ((BigDecimal)deliveryProducts.get(orderProductId)).add(quantity));
                continue;
            }
            deliveryProducts.put(orderProductId, quantity);
        }
        Iterator iterator = orderProductVos.iterator();
        while (iterator.hasNext()) {
            OrderProductVo orderProductVoItem;
            BigDecimal deliveryQuantity = (BigDecimal)deliveryProducts.get((orderProductVoItem = (OrderProductVo)iterator.next()).getId());
            orderProductVoItem.setDeliveryQuantity(deliveryQuantity == null ? BigDecimal.valueOf(0L) : deliveryQuantity);
        }
        return orderInfoVo;
    }

    private static /* synthetic */ boolean lambda$findDetailsByOrderCode$0(String productSpecificationCode, ProductSpecificationVo item) {
        return StringUtils.equals((CharSequence)productSpecificationCode, (CharSequence)item.getProductSpecificationCode());
    }
}

