/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.service.internal;

import com.bizunited.empower.business.common.util.SecurityUtils;
import com.bizunited.empower.business.order.entity.OrderLogisticsInfo;
import com.bizunited.empower.business.order.repository.OrderLogisticsInfoRepository;
import com.bizunited.empower.business.order.service.OrderLogisticsInfoService;
import java.util.Date;
import java.util.Optional;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="OrderLogisticsInfoServiceImpl")
public class OrderLogisticsInfoServiceImpl
implements OrderLogisticsInfoService {
    @Autowired
    private OrderLogisticsInfoRepository orderLogisticsInfoRepository;

    @Override
    @Transactional
    public OrderLogisticsInfo create(OrderLogisticsInfo orderLogisticsInfo) {
        OrderLogisticsInfo current = this.createForm(orderLogisticsInfo);
        return current;
    }

    @Override
    @Transactional
    public OrderLogisticsInfo createForm(OrderLogisticsInfo orderLogisticsInfo) {
        Date now = new Date();
        orderLogisticsInfo.setCreateAccount(SecurityUtils.getUserAccount());
        orderLogisticsInfo.setCreateTime(now);
        orderLogisticsInfo.setModifyAccount(SecurityUtils.getUserAccount());
        orderLogisticsInfo.setModifyTime(now);
        this.createValidation(orderLogisticsInfo);
        this.orderLogisticsInfoRepository.save((Object)orderLogisticsInfo);
        return orderLogisticsInfo;
    }

    private void createValidation(OrderLogisticsInfo orderLogisticsInfo) {
        Validate.notNull((Object)((Object)orderLogisticsInfo), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)orderLogisticsInfo.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        orderLogisticsInfo.setId(null);
        Validate.notNull((Object)((Object)orderLogisticsInfo.getOrderInfo()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u524d\u914d\u9001\u4fe1\u606f\u4e00\u5b9a\u9700\u8981\u6709\u5bf9\u5e94\u7684\u8ba2\u5355\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.notNull((Object)orderLogisticsInfo.getDeliveryDate(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4ea4\u8d27\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Date deliveryDate = orderLogisticsInfo.getDeliveryDate();
        Validate.notNull((Object)deliveryDate, (String)"\u4ea4\u8d27\u65e5\u671f\u5fc5\u987b\u586b\u5199", (Object[])new Object[0]);
        Date now = new Date();
        Validate.isTrue((DateUtils.truncatedCompareTo((Date)now, (Date)new Date(deliveryDate.getTime()), (int)5) <= 0 ? 1 : 0) != 0, (String)"\u4ea4\u8d27\u65e5\u671f\u4e0d\u80fd\u5728\u4eca\u5929\u4e4b\u524d\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderLogisticsInfo.getContactPerson(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8054\u7cfb\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderLogisticsInfo.getPhone(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8054\u7cfb\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderLogisticsInfo.getAddress(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((orderLogisticsInfo.getLogisticsName() == null || orderLogisticsInfo.getLogisticsName().length() < 255 ? 1 : 0) != 0, (String)"\u7269\u6d41\u516c\u53f8,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((orderLogisticsInfo.getLogisticsCode() == null || orderLogisticsInfo.getLogisticsCode().length() < 255 ? 1 : 0) != 0, (String)"\u7269\u6d41\u5355\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((orderLogisticsInfo.getDeliveryCode() == null || orderLogisticsInfo.getDeliveryCode().length() < 255 ? 1 : 0) != 0, (String)"\u914d\u9001\u7f16\u53f7,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((orderLogisticsInfo.getDeliveryMethod() == null || orderLogisticsInfo.getDeliveryMethod().length() < 255 ? 1 : 0) != 0, (String)"\u914d\u9001\u65b9\u5f0f,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((orderLogisticsInfo.getContactPerson() == null || orderLogisticsInfo.getContactPerson().length() < 255 ? 1 : 0) != 0, (String)"\u8054\u7cfb\u4eba,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((orderLogisticsInfo.getPhone() == null || orderLogisticsInfo.getPhone().length() < 255 ? 1 : 0) != 0, (String)"\u8054\u7cfb\u7535\u8bdd,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((orderLogisticsInfo.getAddress() == null || orderLogisticsInfo.getAddress().length() < 255 ? 1 : 0) != 0, (String)"\u5730\u5740,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((orderLogisticsInfo.getLogisticsStatus() == null || orderLogisticsInfo.getLogisticsStatus().length() < 255 ? 1 : 0) != 0, (String)"\u7269\u6d41\u72b6\u6001,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public OrderLogisticsInfo update(OrderLogisticsInfo orderLogisticsInfo) {
        OrderLogisticsInfo current = this.updateForm(orderLogisticsInfo);
        return current;
    }

    @Override
    @Transactional
    public OrderLogisticsInfo updateForm(OrderLogisticsInfo orderLogisticsInfo) {
        this.updateValidation(orderLogisticsInfo);
        String currentId = orderLogisticsInfo.getId();
        Optional op_currentOrderLogisticsInfo = this.orderLogisticsInfoRepository.findById(currentId);
        OrderLogisticsInfo currentOrderLogisticsInfo = op_currentOrderLogisticsInfo.orElse(null);
        currentOrderLogisticsInfo = (OrderLogisticsInfo)((Object)Validate.notNull((Object)((Object)currentOrderLogisticsInfo), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]));
        Date now = new Date();
        currentOrderLogisticsInfo.setModifyAccount(SecurityUtils.getUserAccount());
        currentOrderLogisticsInfo.setModifyTime(now);
        currentOrderLogisticsInfo.setLogisticsName(orderLogisticsInfo.getLogisticsName());
        currentOrderLogisticsInfo.setLogisticsCode(orderLogisticsInfo.getLogisticsCode());
        currentOrderLogisticsInfo.setDeliveryCode(orderLogisticsInfo.getDeliveryCode());
        currentOrderLogisticsInfo.setDeliveryMethod(orderLogisticsInfo.getDeliveryMethod());
        currentOrderLogisticsInfo.setDeliveryDate(orderLogisticsInfo.getDeliveryDate());
        currentOrderLogisticsInfo.setContactPerson(orderLogisticsInfo.getContactPerson());
        currentOrderLogisticsInfo.setPhone(orderLogisticsInfo.getPhone());
        currentOrderLogisticsInfo.setAddress(orderLogisticsInfo.getAddress());
        currentOrderLogisticsInfo.setLogisticsStatus(orderLogisticsInfo.getLogisticsStatus());
        this.orderLogisticsInfoRepository.saveAndFlush((Object)currentOrderLogisticsInfo);
        return currentOrderLogisticsInfo;
    }

    private void updateValidation(OrderLogisticsInfo orderLogisticsInfo) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)orderLogisticsInfo.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)orderLogisticsInfo.getOrderInfo()), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u524d\u914d\u9001\u4fe1\u606f\u4e00\u5b9a\u9700\u8981\u6709\u5bf9\u5e94\u7684\u8ba2\u5355\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderLogisticsInfo.getDeliveryMethod(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u914d\u9001\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)orderLogisticsInfo.getDeliveryDate(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u4ea4\u8d27\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderLogisticsInfo.getContactPerson(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u8054\u7cfb\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderLogisticsInfo.getPhone(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u8054\u7cfb\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderLogisticsInfo.getAddress(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((orderLogisticsInfo.getLogisticsName() == null || orderLogisticsInfo.getLogisticsName().length() < 255 ? 1 : 0) != 0, (String)"\u7269\u6d41\u516c\u53f8,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((orderLogisticsInfo.getLogisticsCode() == null || orderLogisticsInfo.getLogisticsCode().length() < 255 ? 1 : 0) != 0, (String)"\u7269\u6d41\u5355\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((orderLogisticsInfo.getDeliveryCode() == null || orderLogisticsInfo.getDeliveryCode().length() < 255 ? 1 : 0) != 0, (String)"\u914d\u9001\u7f16\u53f7,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((orderLogisticsInfo.getDeliveryMethod() == null || orderLogisticsInfo.getDeliveryMethod().length() < 255 ? 1 : 0) != 0, (String)"\u914d\u9001\u65b9\u5f0f,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((orderLogisticsInfo.getContactPerson() == null || orderLogisticsInfo.getContactPerson().length() < 255 ? 1 : 0) != 0, (String)"\u8054\u7cfb\u4eba,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((orderLogisticsInfo.getPhone() == null || orderLogisticsInfo.getPhone().length() < 255 ? 1 : 0) != 0, (String)"\u8054\u7cfb\u7535\u8bdd,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((orderLogisticsInfo.getAddress() == null || orderLogisticsInfo.getAddress().length() < 255 ? 1 : 0) != 0, (String)"\u5730\u5740,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((orderLogisticsInfo.getLogisticsStatus() == null || orderLogisticsInfo.getLogisticsStatus().length() < 255 ? 1 : 0) != 0, (String)"\u7269\u6d41\u72b6\u6001,\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    public OrderLogisticsInfo findDetailsByOrderInfo(String orderInfo) {
        if (StringUtils.isBlank((CharSequence)orderInfo)) {
            return null;
        }
        return this.orderLogisticsInfoRepository.findDetailsByOrderInfo(orderInfo);
    }

    @Override
    public OrderLogisticsInfo findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.orderLogisticsInfoRepository.findDetailsById(id);
    }

    @Override
    public OrderLogisticsInfo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.orderLogisticsInfoRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    @Transactional
    public void deleteByIds(String[] ids) {
        if (ids == null || ids.length <= 0) {
            return;
        }
        this.orderLogisticsInfoRepository.deleteByIds(ids);
    }
}

