/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.service.internal;

import com.bizunited.empower.business.common.util.SecurityUtils;
import com.bizunited.empower.business.order.entity.OrderProduct;
import com.bizunited.empower.business.order.repository.OrderProductRepository;
import com.bizunited.empower.business.order.service.OrderProductService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="OrderProductServiceImpl")
public class OrderProductServiceImpl
implements OrderProductService {
    @Autowired
    private OrderProductRepository orderProductRepository;

    @Override
    @Transactional
    public OrderProduct create(OrderProduct orderProduct) {
        OrderProduct current = this.createForm(orderProduct);
        return current;
    }

    @Override
    @Transactional
    public OrderProduct createForm(OrderProduct orderProduct) {
        Date now = new Date();
        this.createValidation(orderProduct);
        orderProduct.setCreateAccount(SecurityUtils.getUserAccount());
        orderProduct.setCreateTime(now);
        orderProduct.setModifyAccount(SecurityUtils.getUserAccount());
        orderProduct.setModifyTime(now);
        BigDecimal subtotalAmount = this.analysisProductsAubtotalAmount(orderProduct);
        orderProduct.setSubtotalAmount(subtotalAmount);
        this.orderProductRepository.save((Object)orderProduct);
        return orderProduct;
    }

    private void createValidation(OrderProduct orderProduct) {
        Validate.notNull((Object)((Object)orderProduct), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)orderProduct.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        orderProduct.setId(null);
        Validate.notNull((Object)((Object)orderProduct.getOrderInfo()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u4fe1\u606f\u4e00\u5b9a\u9700\u8981\u6709\u5bf9\u5e94\u7684\u8ba2\u5355\u4fe1\u606f!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderProduct.getProductSpecificationCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\uff08\u89c4\u683c\uff09\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderProduct.getProductSpecificationName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\uff08\u89c4\u683c\uff09\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderProduct.getUnitCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orderProduct.getUnitName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)orderProduct.getOrderQuantity(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8ba2\u8d27\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((orderProduct.getOrderQuantity().floatValue() > 0.0f ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u8ba2\u8d27\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        Validate.notNull((Object)orderProduct.getGift(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u662f\u8d60\u54c1\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((orderProduct.getProductSpecificationCode() == null || orderProduct.getProductSpecificationCode().length() < 128 ? 1 : 0) != 0, (String)"\u5546\u54c1\uff08\u89c4\u683c\uff09\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((orderProduct.getProductSpecificationName() == null || orderProduct.getProductSpecificationName().length() < 128 ? 1 : 0) != 0, (String)"\u5546\u54c1\uff08\u89c4\u683c\uff09\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((orderProduct.getInternationalBarcode() == null || orderProduct.getInternationalBarcode().length() < 255 ? 1 : 0) != 0, (String)"\u56fd\u9645\u6761\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((orderProduct.getUnitCode() == null || orderProduct.getUnitCode().length() <= 64 ? 1 : 0) != 0, (String)"\u5355\u4f4d,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((orderProduct.getUnitName() == null || orderProduct.getUnitName().length() <= 128 ? 1 : 0) != 0, (String)"\u5355\u4f4d\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((orderProduct.getRemark() == null || orderProduct.getRemark().length() < 255 ? 1 : 0) != 0, (String)"\u5907\u6ce8,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    private BigDecimal analysisProductsAubtotalAmount(OrderProduct orderProduct) {
        BigDecimal orderQuantity = orderProduct.getOrderQuantity();
        Validate.notNull((Object)orderQuantity, (String)"\u8ba2\u5355\u5546\u54c1[%s]\u7684\u8ba2\u8d27\u6570\u91cf\u5fc5\u987b\u4f20\u5165", (Object[])new Object[]{orderProduct.getProductSpecificationName()});
        Validate.isTrue((orderQuantity.floatValue() >= 0.0f ? 1 : 0) != 0, (String)"\u8ba2\u5355\u5546\u54c1[%s]\u7684\u8ba2\u8d27\u6570\u91cf\u4e0d\u80fd\u4e3a\u8d1f\u6570!", (Object[])new Object[]{orderProduct.getProductSpecificationName()});
        BigDecimal unitPrice = orderProduct.getUnitPrice();
        Validate.notNull((Object)unitPrice, (String)"\u8ba2\u5355\u5546\u54c1[%s]\u7684\u8ba2\u8d27\u5355\u4ef7\u5fc5\u987b\u4f20\u5165", (Object[])new Object[]{orderProduct.getProductSpecificationName()});
        Validate.isTrue((unitPrice.floatValue() >= 0.0f ? 1 : 0) != 0, (String)"\u8ba2\u5355\u5546\u54c1[%s]\u7684\u8ba2\u8d27\u5355\u4ef7\u4e0d\u80fd\u4e3a\u8d1f\u6570!", (Object[])new Object[]{orderProduct.getProductSpecificationName()});
        BigDecimal subtotalAmount = orderQuantity.multiply(unitPrice).setScale(4, RoundingMode.HALF_UP);
        return subtotalAmount;
    }

    @Override
    public BigDecimal analysisProductsTotal(Set<OrderProduct> orderProducts) {
        Validate.isTrue((!CollectionUtils.isEmpty(orderProducts) ? 1 : 0) != 0, (String)"\u8fdb\u884c\u8ba2\u5355\u5546\u54c1\u8ba1\u7b97\u65f6\uff0c\u5fc5\u987b\u81f3\u5c11\u51fa\u5165\u4e00\u4e2a\u5546\u54c1\u6761\u76ee!!", (Object[])new Object[0]);
        Set effectiveOrderProducts = orderProducts.stream().filter(item -> item.getGift() == 0).collect(Collectors.toSet());
        Set<OrderProduct> giftOrderProducts = orderProducts.stream().filter(item -> item.getGift() == 1).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(effectiveOrderProducts)) {
            orderProducts.forEach(item -> item.setSubtotalAmount(BigDecimal.valueOf(0L)));
            return BigDecimal.valueOf(0L);
        }
        BigDecimal total = BigDecimal.valueOf(0L);
        for (OrderProduct effectiveOrderProduct : effectiveOrderProducts) {
            BigDecimal subtotalAmount = this.analysisProductsAubtotalAmount(effectiveOrderProduct);
            effectiveOrderProduct.setSubtotalAmount(subtotalAmount);
            total = total.add(subtotalAmount);
        }
        if (!CollectionUtils.isEmpty(giftOrderProducts)) {
            giftOrderProducts.forEach(item -> item.setSubtotalAmount(BigDecimal.valueOf(0L)));
        }
        return total;
    }

    @Override
    public Set<OrderProduct> findDetailsByOrderInfo(String orderInfo) {
        if (StringUtils.isBlank((CharSequence)orderInfo)) {
            return Sets.newHashSet();
        }
        return this.orderProductRepository.findDetailsByOrderInfo(orderInfo);
    }

    @Override
    public OrderProduct findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.orderProductRepository.findDetailsById(id);
    }

    @Override
    public OrderProduct findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.orderProductRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    @Transactional
    public void deleteByIds(String[] ids) {
        if (ids == null || ids.length <= 0) {
            return;
        }
        this.orderProductRepository.deleteByIds(ids);
    }

    @Override
    public boolean existBySpecificationCode(String specificationCode) {
        String tenantCode = TenantUtils.getTenantCode();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{specificationCode, tenantCode})) {
            return false;
        }
        return this.orderProductRepository.countByTenantCodeAndSpecificationCode(tenantCode, specificationCode) > 0L;
    }

    @Override
    public boolean existBySpecificationCodes(Set<String> specificationCodes) {
        String tenantCode = TenantUtils.getTenantCode();
        if (CollectionUtils.isEmpty(specificationCodes) || StringUtils.isBlank((CharSequence)tenantCode)) {
            return false;
        }
        return this.orderProductRepository.countByTenantCodeAndSpecificationCodes(tenantCode, specificationCodes) > 0L;
    }

    @Override
    public boolean existBySpecificationCodeAndSpecificationName(String specificationCode, String specificationName) {
        String tenantCode = TenantUtils.getTenantCode();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tenantCode, specificationCode, specificationName})) {
            return false;
        }
        return this.orderProductRepository.countByTenantCodeAndSpecificationCodeAndSpecificationName(tenantCode, specificationCode, specificationName) > 0L;
    }

    @Override
    public boolean existByUnitCode(String unitCode) {
        String tenantCode = TenantUtils.getTenantCode();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{unitCode, tenantCode})) {
            return false;
        }
        return this.orderProductRepository.existByUnitCodeAndTenantCode(unitCode, tenantCode) > 0L;
    }

    @Override
    public boolean existByUnitCodes(Set<String> unitCodes) {
        String tenantCode = TenantUtils.getTenantCode();
        if (CollectionUtils.isEmpty(unitCodes) || StringUtils.isBlank((CharSequence)tenantCode)) {
            return false;
        }
        return this.orderProductRepository.existByUnitCodesAndTenantCode(unitCodes, tenantCode) > 0L;
    }

    @Override
    public boolean existByUnitCodeAndUnitName(String unitCode, String unitName) {
        String tenantCode = TenantUtils.getTenantCode();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{unitCode, tenantCode, unitName})) {
            return false;
        }
        return this.orderProductRepository.existByUnitCodeAndUnitNameAndTenantCode(unitCode, unitName, tenantCode) > 0L;
    }
}

