/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.service.internal;

import com.bizunited.empower.business.order.entity.OrderInfo;
import com.bizunited.empower.business.order.entity.OrderStatusLogger;
import com.bizunited.empower.business.order.repository.OrderStatusLoggerRepository;
import com.bizunited.empower.business.order.service.OrderStatusLoggerService;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="OrderStatusLoggerServiceImpl")
public class OrderStatusLoggerServiceImpl
implements OrderStatusLoggerService {
    @Autowired
    private OrderStatusLoggerRepository orderStatusLoggerRepository;

    @Override
    @Transactional
    public void create(String orderId, String opAccount, Integer previouStatus, Integer currentStatus) {
        Validate.notBlank((CharSequence)orderId, (String)"\u8ba2\u5355\u6280\u672f\u7f16\u53f7\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5\uff01\uff01", (Object[])new Object[0]);
        Validate.isTrue((currentStatus >= 1 && currentStatus <= 7 || currentStatus == 100 || currentStatus == 200 || currentStatus == 999 ? 1 : 0) != 0, (String)"\u4e0d\u5408\u6cd5\u7684\u8ba2\u5355\u6d41\u8f6c\u72b6\u6001\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        OrderStatusLogger logger = new OrderStatusLogger();
        logger.setCurrentStatus(currentStatus);
        logger.setLoggerTime(new Date());
        logger.setPreviouStatus(previouStatus);
        logger.setOpAccount(opAccount);
        OrderInfo currrentOrder = new OrderInfo();
        currrentOrder.setId(orderId);
        logger.setOrderInfo(currrentOrder);
        this.createForm(logger);
    }

    private OrderStatusLogger createForm(OrderStatusLogger orderStatusLogger) {
        this.createValidation(orderStatusLogger);
        this.orderStatusLoggerRepository.save((Object)orderStatusLogger);
        return orderStatusLogger;
    }

    private void createValidation(OrderStatusLogger orderStatusLogger) {
        Validate.notNull((Object)((Object)orderStatusLogger), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)orderStatusLogger.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        orderStatusLogger.setId(null);
        Validate.notNull((Object)orderStatusLogger.getLoggerTime(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u64cd\u4f5c\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)orderStatusLogger.getCurrentStatus(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u524d\u8ba2\u5355\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((orderStatusLogger.getOpAccount() == null || orderStatusLogger.getOpAccount().length() < 255 ? 1 : 0) != 0, (String)"\u64cd\u4f5c\u8005\u8d26\u53f7\uff08\u53ef\u80fd\u6ca1\u6709\u64cd\u4f5c\u8005\uff09,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    public Set<OrderStatusLogger> findDetailsByOrderInfo(String orderInfo) {
        if (StringUtils.isBlank((CharSequence)orderInfo)) {
            return Sets.newHashSet();
        }
        return this.orderStatusLoggerRepository.findDetailsByOrderInfo(orderInfo);
    }

    @Override
    public OrderStatusLogger findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.orderStatusLoggerRepository.findDetailsById(id);
    }

    @Override
    public OrderStatusLogger findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.orderStatusLoggerRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        OrderStatusLogger current = this.findById(id);
        if (current != null) {
            this.orderStatusLoggerRepository.delete((Object)current);
        }
    }
}

