/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.service.internal;

import com.bizunited.empower.business.common.util.SecurityUtils;
import com.bizunited.empower.business.order.entity.ReturnAuditLog;
import com.bizunited.empower.business.order.repository.ReturnAuditLogRepository;
import com.bizunited.empower.business.order.service.ReturnAuditLogService;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReturnAuditLogServiceImpl
implements ReturnAuditLogService {
    @Autowired
    private ReturnAuditLogRepository returnAuditLogRepository;

    @Override
    @Transactional
    public ReturnAuditLog create(ReturnAuditLog auditLog) {
        Validate.notNull((Object)((Object)auditLog), (String)"\u9000\u8d27\u5355\u5ba1\u6838\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditLog.getAuditStatus(), (String)"\u9000\u8d27\u5355\u5ba1\u6838\u72b6\u6001\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditLog.getAuditVersion(), (String)"\u9000\u8d27\u5355\u7248\u672c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)auditLog.getId()), (String)"\u521b\u5efa\u5ba1\u6838\u8bb0\u5f55\u65f6\uff0cid\u4e3b\u952e\u4e0d\u80fd\u6709\u503c", (Object[])new Object[0]);
        Date now = new Date();
        String account = SecurityUtils.getUserAccount();
        auditLog.setCreateAccount(account);
        auditLog.setModifyAccount(account);
        auditLog.setCreateTime(now);
        auditLog.setModifyTime(now);
        return (ReturnAuditLog)((Object)this.returnAuditLogRepository.saveAndFlush((Object)auditLog));
    }

    @Override
    public Set<ReturnAuditLog> findByReturnId(String returnId) {
        if (StringUtils.isBlank((CharSequence)returnId)) {
            return Sets.newHashSet();
        }
        return this.returnAuditLogRepository.findByReturnId(returnId);
    }
}

