/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.empower.business.order.service.internal;

import com.bizunited.empower.business.common.util.SecurityUtils;
import com.bizunited.empower.business.order.entity.ReturnFile;
import com.bizunited.empower.business.order.repository.ReturnFileRepository;
import com.bizunited.empower.business.order.service.ReturnFileService;
import java.util.Date;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="_ReturnFileServiceImpl")
public class ReturnFileServiceImpl
implements ReturnFileService {
    @Autowired
    private ReturnFileRepository returnFileRepository;

    @Override
    public ReturnFile create(ReturnFile returnFile) {
        ReturnFile current = this.createForm(returnFile);
        return current;
    }

    @Override
    @Transactional
    public ReturnFile createForm(ReturnFile returnFile) {
        Date now = new Date();
        returnFile.setCreateAccount(SecurityUtils.getUserAccount());
        returnFile.setCreateTime(now);
        returnFile.setModifyAccount(SecurityUtils.getUserAccount());
        returnFile.setModifyTime(now);
        this.createValidation(returnFile);
        this.returnFileRepository.save((Object)returnFile);
        return returnFile;
    }

    private void createValidation(ReturnFile returnFile) {
        Validate.notNull((Object)((Object)returnFile), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)returnFile.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        returnFile.setId(null);
        Validate.notBlank((CharSequence)returnFile.getRelativePath(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u76f8\u5bf9\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)returnFile.getFileName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u539f\u59cb\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)returnFile.getReFileName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u91cd\u547d\u540d\u540e\u7684\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((returnFile.getRelativePath() == null || returnFile.getRelativePath().length() < 255 ? 1 : 0) != 0, (String)"\u76f8\u5bf9\u8def\u5f84,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((returnFile.getFileName() == null || returnFile.getFileName().length() < 128 ? 1 : 0) != 0, (String)"\u539f\u59cb\u6587\u4ef6\u540d,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((returnFile.getReFileName() == null || returnFile.getReFileName().length() < 128 ? 1 : 0) != 0, (String)"\u91cd\u547d\u540d\u540e\u7684\u6587\u4ef6\u540d,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public void deleteByIds(String[] ids) {
        if (ids == null || ids.length <= 0) {
            return;
        }
        this.returnFileRepository.deleteByIds(ids);
    }
}

